<?php

    require('partials/landing-header.php');

?>

<main class="max-w-4xl mx-auto px-6 py-12">

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">About <span translate="no"><?= SITE_NAME ?></span></h2>
      <p class="mb-4">
        <span translate="no"><?= SITE_NAME ?></span> stands as a premier financial institution dedicated to delivering seamless, innovative, and trustworthy banking solutions. Guided by a commitment to excellence and integrity, <span translate="no"><?= SITE_NAME ?></span> endeavors to foster enduring relationships with its clients by offering superior service across all facets of banking.
      </p>
    </section>

    <section class="mb-8">
      <h2 class="text-2xl font-semibold mb-4 text-blue-650">Our History</h2>
      <p class="mb-4">
        Established with the primary objective of providing accessible and dependable financial services that address the evolving needs of individuals, enterprises, and institutions. From its inception, <span translate="no"><?= SITE_NAME ?></span> has embraced a philosophy centered on seamless integration of technology and personalized service to ensure an effortless banking experience.
      </p>

      <p class="mb-4">
        Throughout its history, <span translate="no"><?= SITE_NAME ?></span> has demonstrated a consistent trajectory of growth and innovation, driven by a strategic focus on operational excellence and customer satisfaction. The bank’s adoption of advanced digital platforms, coupled with its rigorous adherence to security and compliance standards, underscores its commitment to delivering uninterrupted, efficient financial solutions.
      </p>

      <p class="mb-4">
        <span translate="no"><?= SITE_NAME ?></span>’s unwavering dedication to seamless service delivery has earned it a distinguished reputation as a trusted partner in wealth creation and economic development. By continually refining its products and services, <span translate="no"><?= SITE_NAME ?></span> ensures that its clients benefit from smooth, accessible, and reliable banking experiences in an ever-changing financial landscape.
      </p>

    </section>
</main>

<?php

    require('partials/landing-footer.php');

?>