<?php

    require('utility/partials/header.php');
    
    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn);

        $userType = 'USER';

        if (!$userData) {

            $userData = thirdPartyData($id, $conn);

            if (!$userData) {

                echo '<script>
                
                    swal({
                    
                        title: "Error!",

                        text: "User not found!",

                        icon: "error"

                    }).then(() => {
                    
                        window.history.go(-1);
                    
                    });
                
                </script>';

                exit;

            }    

        }

    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid URL Parameter(s)",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Billing Code Status: <span class="<?= $userData['bcode-status'] == 'ACTIVE' ? ' text-success' : ' text-danger' ?>"><?= $userData['bcode-status'] ?></span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="code-status?id=<?= $id ?>&action=<?= $userData['bcode-status'] != 'ACTIVE' ? 'enable' : 'disable' ?>" class="btn btn-<?= $userData['bcode-status'] != 'ACTIVE' ? 'success' : 'danger' ?>"><span><?= $userData['bcode-status'] != 'ACTIVE' ? 'Activate' : 'Deactivate' ?> Billing Codes</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?= join(' ', [$userData['firstname'], $userData['lastname']]) ?> Billing Codes <?= '(' . bcodeCount($id, $conn) . ')' ?></h4>
                <div class="nk-block-des">
                    <p>Below is the list of Billing codes</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col"><span class="sub-text">#</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Code ID</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">Name</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Code</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Type</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Payment</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $codeFound = false; // Code Flag

                            // Fetch All User's Code
                        
                            $codes = mysqli_prepare($conn, "SELECT * FROM `billing_codes` WHERE `user_id` = ? ORDER BY `id` DESC"); // Prepare Statement

                            mysqli_stmt_bind_param($codes, "s", $id); // Bind Parameter(s)

                            mysqli_stmt_execute($codes); // Execute Statement

                            $codesResult = mysqli_stmt_get_result($codes); // Get Statement Result

                            if (mysqli_num_rows($codesResult) > 0) { // Compare Result Mass

                                $codeFound = true; // Update Flag

                                $codesData = mysqli_fetch_all($codesResult, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($codesResult); // Free Result

                            mysqli_stmt_close($codes); // Close Statement

                            // Check Flag

                            if ($codeFound) {

                                $i = 0; 

                                foreach ($codesData as $codeData): // Iterate Through Rows

                                    $i++;

                                    $codeId = $codeData['code_id'];

                                    $code = $codeData['code'];

                                    $name = $codeData['name'];

                                    $abbr = $codeData['abbr'];

                                    $descr = $codeData['descr'];

                                    $status = $codeData['status'];

                                    $type = $codeData['type'];

                                    $payMethod = $codeData['payment_method'];

                                    $percentage = $codeData['percentage'];

                                    $amount = $codeData['amount'];

                                ?>    

                                    <tr class="nk-tb-item">
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $i ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $codeId ?></span>
                                        </td>
                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= $name ?><span class="dot dot-success d-md-none ml-1"></span>
                                                    </span>
                                                    <span>
                                                        <?= $abbr ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span>
                                            <?= (strlen($code) <= 6) ? substr($code, 0, 2) . '****' : substr($code, 0, 2) . '****' . substr($code, -2) ?>
                                            </span>
                                        </td>
                                        <td class="nk-tb-col tb-col-lg" data-order="">
                                            <div class="user-info">
                                                <span class="tb-lead">
                                                    <?= $type ?><span class="dot dot-success d-md-none ml-1"></span>
                                                </span>
                                                <span>
                                                    <?= ($type == 'PERCENTAGE') ? $percentage . '%' : '$' . $amount ?>
                                                </span>
                                            </div>
                                        </td>
                                        <td class="nk-tb-col tb-col-lg">
                                            <span>
                                                <?= $payMethod ?>
                                            </span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <ul class="list-status">
                                                
                                                <?php
                                                
                                                    if ($status == 'PAID') {

                                                        echo '<li><em class="icon text-success ni ni-check-circle"></em> <span>PAID</span></li>';

                                                    } else {

                                                        echo '<li><em class="icon text-danger ni ni-alert-circle"></em> <span>UNPAID</span><li>';

                                                    }
                                                
                                                ?>

                                            </ul>
                                        </td>
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form class="bcode-mgmt-form" method="post">
                                                <input type="hidden" name="bcode-id" value="<?= $codeId ?>">
                                                <ul class="nk-tb-actions gx-1">
                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" name="send-bcode" value="SEND" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Dispense Code">
                                                            <em class="icon ni ni-send text-success"></em>
                                                        </button>
                                                    </li>


                                                    <li>
                                                        <div class="dropdown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <!-- <li class="divider"></li> -->
                                                                    <li><a href="edit-code?id=<?= $codeId ?>"><em
                                                                                class="icon ni ni-edit"></em><span>Edit Code</span></a></li>
                                                                    <li><button class="btn w-100" name="delete-bcode" value="DELETE" type="submit"><em
                                                                                class="icon ni ni-trash text-danger"></em><span>Delete</span></a>
                                                                    </li>

                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </form>    
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-lock-fill"></em> Create Billing Code</h5>
        </div>
        <form id="codeForm" method="post">
            <div class="card-body">
                <b>Billing Code Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-pin">Code</label>
                            <input type="text" class="form-control" id="code-pin" name="code-pin"
                                placeholder="****" minlength="6" required>
                                <input type="hidden" class="form-control" id="user-id" name="user-id"
                                value="<?= isset($id) ? $id : '' ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-name">Code Name</label>
                            <input type="text" class="form-control" id="code-name" name="code-name"
                                placeholder="e.g Transfer Authorization Code" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-abbr">Code Abbreviation</label>
                            <input type="text" class="form-control" id="code-abbr" name="code-abbr"
                                placeholder="e.g TAC" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-pay">Payment Method</label>
                            <select type="text" class="form-control" id="code-pay" name="code-pay">

                                <option value="AUTOMATIC">Automatic</option>

                                <option value="MANUAL">Manual</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-type">Code Type</label>
                            <select type="text" class="form-control" id="code-type" name="code-type">

                                <option value="PERCENTAGE">Percentage</option>

                                <option value="FIXED AMOUNT">Fixed Amount</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-percent">Code Percentage (%)</label>
                            <input type="number" class="form-control" id="code-percent" name="code-percent" min="0.01" step="0.01"
                                placeholder="(Min 0.01%) Required for Percentage Code Type">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-amount">Code Amount (USD)</label>
                            <input type="number" class="form-control" id="code-amount" name="code-amount" min="0.01" step="0.01"
                                placeholder="Required for Fixed amount Code Type">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="code-directive">Code Directive</label>
                            <input type="text" class="form-control" id="code-directive" name="code-directive"
                                placeholder="e.g Enter Transfer Code (TAC)">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="form-label" for="code-error">Error Code</label>
                            <input type="text" class="form-control" id="code-error" name="code-error"
                                placeholder="Error Code">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="code-desc">Short Description</label>
                            <textarea class="form-control" id="code-desc" name="code-desc" placeholder="A paragraph describing the code" required></textarea>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="code-msg">Code Message</label>
                            <textarea class="form-control" id="code-msg" name="code-msg" placeholder="Full code description. Separate paragraphs with ,," required></textarea>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>