<?php

  require('utility/partials/header.php');

  if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

    $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

    $userData = userData($id, $conn);

    if (!$userData) {

      echo '<script>
      
        swal({
        
            title: "Error!",

            text: "User not found!",

            icon: "error",

        }).then(() => {
        
            window.history.go(-1);

        });
      
      </script>';

      exit;

    }

    if (!is_null($userData['trans-pin'])) {

      echo '<script>
      
        swal({
        
            title: "Attention!",

            text: "User fully registered!",

            icon: "info",

        }).then(() => {
        
            window.history.go(-1);

        });
      
      </script>';

    }

  } else {

    echo '<script>
        
        swal({
        
            title: "Error!",

            text: "Invalid URL Credential!",

            icon: "error",

        }).then(() => {
        
          window.history.go(-1);

        });
    
    </script>';

    exit;

  }

?>

<div class="nk-content">
  <div class="container-xl wide-lg">
    <div class="nk-content-body">
      <div class="nk-block-head">
        <div class="nk-block-head-sub">
        </div>
        <div class="nk-block-between-md g-4 card-bordered">
          <div class="nk-block-head-content">
            <h4 class="nk-block-title fw-normal">Finalize Registration.</h4>
            <div class="nk-block-des">
              <p>
              </p>
            </div>
          </div>
        </div><!-- .nk-block-between -->
      </div><!-- .nk-block-head -->
    </div>
  </div>
  <div class="card card-bordered s-4 col-lg-12 p-0">
    <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
      <h5 class="text-white"><em class="icon ni ni-user-add-fill"></em> Fill user details correctly</h5>
    </div>
    <form id="finalizeRegForm" method="post">
      <div class="card-body">
        <b>Personal Details</b>
        <hr>
        <div class="row">
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="marital">Marital Status</label>
              <select type="text" class="form-control" name="marital">
                <option value="UNKNOWN">Unknown</option>
                <option value="MARRIED">Married</option>
                <option value="SINGLE">Single</option>
              </select>
              <input type="hidden" name="user-id" value="<?= $id ?>">
            </div>
          </div>
          
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="gender">Gender</label>
              <select type="text" class="form-control" name="gender">
                <option value="MALE">Male</option>
                <option value="FEMALE">Female</option>
                <option value="OTHERS">Others</option>
              </select>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="telephone">Telephone</label>
              <input type="tel" class="form-control" name="telephone" placeholder="Telephone" required>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="religion">Religion</label>
              <input type="text" class="form-control" name="religion" placeholder="Religion">
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="citizen">Nationality</label>
              <input type="text" class="form-control" name="citizen" placeholder="Citizenship" required>
            </div>
          </div>
          
          <div class="col-md-12">
            <hr>
            <b>Address Details</b>
            <hr>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="zip-code">Zip Code</label>
              <input type="text" class="form-control" name="zip-code" placeholder="Enter Zip Code" required>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="street-address">Street</label>
              <input type="text" class="form-control" name="street-address" placeholder="Enter Street address" required>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="city">City</label>
              <input type="text" class="form-control" name="city" placeholder="Enter City" required>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="state">State</label>
              <input type="text" class="form-control" name="state" placeholder="Enter State" required>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="country">Country</label>
              <input type="text" class="form-control" name="country" placeholder="Enter Country" required>
            </div>
          </div>
        </div>

        <hr>
        <b>Security Details</b>
        <hr>

        <div class="row">

          <div class="col-md-6">
            <div class="form-group">
                <label class="form-label" for="sq-1">Secret Question 1</label>
                <select class="form-control form-control-lg" name="sq-1">

                    <option value="What is the name of your first pet?">What is the name of your first pet?</option>

                    <option value="In what city were you born?">In what city were you born?</option>

                    <option value="What is your mother's maiden name?">What is your mother's maiden name?</option>

                    <option value="What was the name of your elementary school?">What was the name of your elementary school?</option>

                    <option value="What was your childhood nickname?">What was your childhood nickname?</option>

                    <option value="What was the street name you grew up on?">What was the street name you grew up on?</option>

                    <option value="What was the make and model of your first car?">What was the make and model of your first car?</option>

                    <option value="What is your father's middle name?">What is your father's middle name?</option>

                    <option value="What is your oldest sibling’s middle name?">What is your oldest sibling’s middle name?</option>

                    <option value="What is the name of the hospital where you were born?">What is the name of the hospital where you were born?</option>

                    <option value="What was the name of your first teacher?">What was the name of your first teacher?</option>

                    <option value="What was the name of your first school friend?">What was the name of your first school friend?</option>

                    <option value="What was your first job title?">What was your first job title?</option>

                    <option value="What company gave you your first paycheck?">What company gave you your first paycheck?</option>

                    <option value="What was your dream job as a child?">What was your dream job as a child?</option>

                    <option value="What was the first concert you attended?">What was the first concert you attended?</option>

                    <option value="What was the first movie you saw in a theater?">What was the first movie you saw in a theater?</option>

                    <option value="What was your first mobile phone brand?">What was your first mobile phone brand?</option>

                    <option value="What was your first email address (without the domain)?">What was your first email address (without the domain)?</option>

                    <option value="What was the name of your first boss?">What was the name of your first boss?</option>

                </select>
                <input type="hidden" name="id" value="<?= $id ?>">
            </div>
          </div>
          <div class="col-md-6">
              <div class="form-group">
                  <label class="form-label" for="answer-1">Answer 1</label>
                  <input type="text" class="form-control form-control-lg" name="answer-1" required>
              </div>
          </div>
          <div class="col-md-6">
              <div class="form-group">
                  <label class="form-label" for="sq-2">Secret Question 2</label>
                  <select class="form-control form-control-lg" name="sq-2">

                      <option value="What is your favorite movie of all time?">What is your favorite movie of all time?</option>

                      <option value="What was your favorite subject in school?">What was your favorite subject in school?</option>

                      <option value="What is your favorite sports team?">What is your favorite sports team?</option>

                      <option value="What is your favorite book?">What is your favorite book?</option>

                      <option value="What is your favorite childhood TV show?">What is your favorite childhood TV show?</option>

                      <option value="Where did you go on your first flight?">Where did you go on your first flight?</option>

                      <option value="What is the name of the first beach you visited?">What is the name of the first beach you visited?</option>

                      <option value="What city did you visit on your first vacation?">What city did you visit on your first vacation?</option>

                      <option value="What is the name of your favorite restaurant in your hometown?">What is the name of your favorite restaurant in your hometown?</option>

                      <option value="Where did you celebrate your last birthday?">Where did you celebrate your last birthday?</option>

                      <option value="What was the name of your childhood best friend?">What was the name of your childhood best friend?</option>

                      <option value="What was your favorite toy as a child?">What was your favorite toy as a child?</option>

                      <option value="What game did you play most as a child?">What game did you play most as a child?</option>

                      <option value="What did you want to be when you grew up?">What did you want to be when you grew up?</option>

                      <option value="What was the color of your childhood bedroom?">What was the color of your childhood bedroom?</option>

                      <option value="What was the name of the town your grandparents lived in?">What was the name of the town your grandparents lived in?</option>

                      <option value="What was the name of your first roommate?">What was the name of your first roommate?</option>

                      <option value="What is the name of a place you’ve always wanted to visit?">What is the name of a place you’ve always wanted to visit?</option>

                      <option value="What was the first foreign country you visited?">What was the first foreign country you visited?</option>

                      <option value="What is the name of your favorite vacation spot?">What is the name of your favorite vacation spot?</option>

                      <option value="What is the name of your first boyfriend/girlfriend?">What is the name of your first boyfriend/girlfriend?</option>

                      <option value="What was the name of your first crush?">What was the name of your first crush?</option>

                      <option value="What is your best friend’s nickname?">What is your best friend’s nickname?</option>

                      <option value="Where did you meet your significant other?">Where did you meet your significant other?</option>

                      <option value="What is the anniversary month of your parents?">What is the anniversary month of your parents?</option>

                      <option value="What is your favorite meal your mom/dad used to cook?">What is your favorite meal your mom/dad used to cook?</option>

                      <option value="What is your favorite dessert?">What is your favorite dessert?</option>

                      <option value="What is your least favorite food?">What is your least favorite food?</option>

                      <option value="What was your favorite food as a child?">What was your favorite food as a child?</option>

                      <option value="What’s the name of your favorite hometown café or eatery?">What’s the name of your favorite hometown café or eatery?</option>

                      <option value="In what city did you attend your first wedding?">In what city did you attend your first wedding?</option>

                      <option value="Who was your childhood hero?">Who was your childhood hero?</option>

                      <option value="What was your high school mascot?">What was your high school mascot?</option>

                      <option value="What was the theme of your prom?">What was the theme of your prom?</option>

                      <option value="What was your graduation year?">What was your graduation year?</option>

                      <option value="What was the name of your imaginary friend?">What was the name of your imaginary friend?</option>

                      <option value="What is the name of your favorite video game character?">What is the name of your favorite video game character?</option>

                      <option value="What color was your first bicycle?">What color was your first bicycle?</option>

                      <option value="What is your favorite board game?">What is your favorite board game?</option>

                      <option value="What is a unique talent or hobby you had growing up?">What is a unique talent or hobby you had growing up?</option>

                  </select>
              </div>
          </div>
          <div class="col-md-6">
              <div class="form-group">
                <label class="form-label" for="answer-2">Answer 2</label>
                <input type="text" class="form-control form-control-lg" name="answer-2" required>
              </div>
          </div>

          <div class="col-md-4">
            <div class="form-group">
              <label class="form-label" for="login-alerts">Login Alerts</label>
              <select class="form-control" name="login-alerts">

                <option value="ENABLED">ENABLED</option>

                <option value="DISABLED">DISABLED</option>

              </select>
            </div>
          </div>

          <div class="col-md-4">
            <div class="form-group">
                <label class="form-label" for="transc-pin">Transaction PIN</label>
                <input type="text" minlength="6" maxlength="6" class="form-control form-control-lg" name="transc-pin" required>
            </div>    
          </div>

        </div>
        
        <hr>
        <b>NOK Details</b>
        <hr>
        
        <div class="row">
        
          <div class="col-md-4">
              <div class="form-group">
                  <label class="form-label" for="nok-fname">Firstname</label>
                  <input type="text" class="form-control form-control-lg" name="nok-fname" required>
              </div>
          </div>

          <div class="col-md-4">
              <div class="form-group">
                  <label class="form-label" for="nok-mname">Middlename</label>
                  <input type="text" class="form-control form-control-lg" name="nok-mname">
              </div>
          </div>

          <div class="col-md-4">
              <div class="form-group">
                  <label class="form-label" for="nok-lname">Lastname</label>
                  <input type="text" class="form-control form-control-lg" name="nok-lname" required>
              </div>
          </div>

          <div class="col-md-4">
              <div class="form-group">
                  <label class="form-label" for="nok-dob">Date Of Birth</label>
                  <input type="date" class="form-control form-control-lg" name="nok-dob" required>
              </div>
          </div>

          <div class="col-md-4">
              <div class="form-group">
                  <label class="form-label" for="nok-rel">Relationship</label>
                  <input type="text" class="form-control form-control-lg" name="nok-rel" required>
              </div>
          </div>

          <div class="col-md-12">
              <div class="form-group">
                  <label class="form-label" for="nok-address">Address</label>
                  <textarea rows="5" class="form-control form-control-lg" name="nok-address" required></textarea>
              </div>
          </div>

        </div>

        <div class="row">

          <div class="col-md-4">
            <div class="form-group">
                <span class="form-label">Send Login Credentials (Recommended)</span>
                <div class="g-3 align-center flex-wrap">
                  <div class="g">
                    <div class="form-group">
                        <input type="checkbox" class="form-control-checkbox" name="notify">
                        <label class="form-control-label" for="notify">Send email</label>
                    </div>
                  </div>
                </div>
            </div>
          </div>

        </div>

      </div>
      <div class="card-footer">
        <button id="finalize-reg" type="submit" class="btn btn-primary regUser">Submit</button>
        <button type="reset" class="btn btn-danger ">Reset</button>
      </div>
    </form>
  </div>

<?php

  require('utility/partials/footer.php');

?>