<?php

    require('../controls/config/config.php'); // Configuration File

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = true; // Flag

        // Fetch Payment Data

        $stmt = mysqli_prepare($conn, "SELECT * FROM `payments` WHERE `pay_id` = ?"); // Prepare Statement
        
        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $proof = $row['pay_proof'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if  (!$found) {

            echo '<script>

                alert("Record not found");

                window.history.go(-1);

            </script>';

            exit();

        }

        $delete = mysqli_prepare($conn, "DELETE FROM `payments` WHERE `pay_id` = ?"); // Prepare Statement
    
        mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($delete)) { // Execute Statement

            if (!empty($proof)) {

                $proof = '../' . str_replace('../', '', $proof); // Re-construct File Path

                if (is_file($proof) && file_exists($proof)) {

                    unlink($proof);

                } 

            }

            echo '<script>

                alert("Payment deleted!");

                window.history.go(-1);

            </script>';

        } else {

            echo '<script>

                alert("An error occurred");

                window.history.go(-1);

            </script>';

            exit();

        }

        mysqli_stmt_close($delete); // Close Statement

    } else {
 
        echo '<script>

            alert("An error occurred");

            window.history.go(-1);

        </script>';

        exit();

    }

?>