<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $paymentFound = false; // Payment Detection Flag

        $payment = mysqli_prepare($conn, "SELECT `A`.*, COALESCE(`B`.`fname`, `C`.`fname`) AS `fname`, COALESCE(`B`.`mname`, `C`.`mname`) AS `mname`, COALESCE(`B`.`lname`, `C`.`lname`) AS `lname`, COALESCE(`B`.`email`, `C`.`email`) AS `email`, CASE WHEN `B`.`user_id` IS NOT NULL THEN 'USER' WHEN `C`.`tp_id` IS NOT NULL THEN 'THIRD PARTY' ELSE 'UNKNOWN' END AS `user_type` FROM `deposits` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` LEFT JOIN `third_party` AS `C` ON `A`.`user_id` = `C`.`tp_id` WHERE `A`.`dep_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($payment, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($payment); // Execute Statement

        $result = mysqli_stmt_get_result($payment); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

            $paymentFound = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $userClass = $row['user_type'];

                $datetime = date('l d M, Y [h:i a]', strtotime($row['dep_time']));

                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                $email = $row['email'];

                $method = $row['dep_channel'];

                $amount = $row['amount'];

                $currency = $row['currency'];

                $item = $row['account'];

                $itemId = $row['acc_id'];

                $related = $row['related_transc'];

                $cryptoCoin = $row['dep_asset'];

                $resourceId = $row['identifier'];

                $destination = $row['channel_attr'];

                $owner = $row['vendor'];

                $proof = SITE_BASE_URL . '/' . htmlspecialchars(str_replace('../',  '', $row['dep_proof']));

                $user = $row['user_id'];

                if ($method == 'CRYPTO' || $method == 'BANK') {

                    $method .= " ($cryptoCoin)";

                }

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($payment); // Close Statement

        if (!$paymentFound) { // Check Flag

            echo '<script>

                swal({

                    title: "Error!",

                    icon: "error",

                    text: "No record found!"

                }).then(() => {
                
                    window.history.go(-1);

                });

            </script>';

            exit;

        }
    

    } else {

        echo '<script>

            swal({

                title: "Error!",

                icon: "error",

                text: "An an error occurred!"

            }).then(() => {
            
                window.history.go(-1);

            });

        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Deposit Details</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-lock-fill"></em>Deposit Details<?= isset($id) ? ' (' . $id . ')' : '' ?></h5>
        </div>
        <div class="card-body">
            <b>Deposit Details</b>
            <hr>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="form-label" for="code-pin">Payment Identifier</label>
                        <input type="text" class="form-control" id="code-pin" name="code-pin"
                        value="<?= isset($id) ? $id : '' ?>" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="form-label" for="code-name">Datetime</label>
                        <input type="text" class="form-control" id="code-name" name="code-name" value="<?= isset($datetime) ?$datetime : '' ?>" readonly>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="form-label" for="code-abbr">User (<?= $userClass ?>)</label>
                        <input type="text" class="form-control" id="code-abbr" name="code-abbr"
                            readonly value="<?= isset($name) ? $name : '' ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="form-label" for="code-pay">Account</label>
                        <input type="text" class="form-control" id="code-abbr" name="code-abbr"
                            readonly value="<?= isset($item) ? $item : '' ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="form-label" for="code-type">Account Identifier</label>
                        <input type="text" class="form-control" id="code-abbr" name="code-abbr"
                            readonly value="<?= isset($itemId) ? $itemId : '' ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="form-label" for="code-percent">Payment Method</label>
                        <input type="text" class="form-control" id="code-abbr" name="code-abbr"
                            readonly value="<?= isset($method) ? $method : '' ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="form-label" for="code-amount">Payment Channel Data</label>
                        <input type="text" class="form-control" id="code-abbr" name="code-abbr"
                            readonly value="<?= isset($destination) ? $destination : '' ?>">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label" for="code-directive">Payment Channel Vendor (Owner)</label>
                        <input type="text" class="form-control" id="code-abbr" name="code-abbr"
                            readonly value="<?= isset($owner) && ($owner != null) ? $owner : '(EMPTY)' ?>">
                    </div>
                </div>
                
                
            </div>
            
        </div>
        <div class="card-footer">
           <button onclick="return window.open('<?= isset($proof) ? $proof : '' ?>', '_blank')" type="button" class="btn btn-info">View Proof <em class="icon ni ni-external-alt"></em></button>
           <button onclick="return window.location.href='deposits'" type="button" class="btn btn-danger"><em class="icon ni ni-history"></em> Back to Deposits</button>   
        </div> 
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>