<?php

    require('utility/partials/header.php');
    
    // checkInstallUrl($site_url)

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id']) && isset($_REQUEST['user-id']) && !empty($_REQUEST['user-id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $accData = accountData($id, $user, $conn);

        if (!$accData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "Account not found!",

                    icon: "error",

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
            
            swal({
            
                title: "Error!",

                text: "Invalid URL Credential!",

                icon: "error",

            }).then(() => {
            
                window.history.go(-1);

            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">User Accounts</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="billing-codes?id=<?= $user ?>" class="btn btn-dark"><span>See Billing Codes</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>


    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-sign-dollar"></em> Edit <?= $accData['currency'] ?> Account</h5>
        </div>
        <form id="edit-acc-Form" method="post">
            <div class="card-body">
                <b>Account Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="currency">Currency</label>
                            <select class="form-control" name="currency">

                                <option value="<?= $accData['currency'] ?>"><?= $accData['currency'] . '(' . $currCodeNames[$accData['currency']]  . ')' ?></option>

                                <?php
                                
                                    $currencies = []; // Store User Currencies

                                    $requests = []; // Store Currenncy Requests

                                    $stmt = mysqli_prepare($conn, "SELECT `A`.`currency` AS `currencies`, `B`.`identifier` AS `requests` FROM `accounts` AS `A` LEFT JOIN `requests` AS `B` ON `A`.`user_id` = `B`.`user_id` AND `B`.`type` = ? WHERE `A`.`user_id` = ? ORDER BY `A`.`currency`, `B`.`identifier` DESC");

                                    $type = 'ACCOUNT';

                                    mysqli_stmt_bind_param($stmt, "ss", $type, $id); // Bind Parameter(s)

                                    mysqli_stmt_execute($stmt); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                                    if (mysqli_num_rows($result) > 0) {

                                        while ($row = mysqli_fetch_assoc($result)) {

                                            $currencies[] = $row['currencies'];

                                            $requests[] = $row['requests'];

                                        }

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt); // Close Statement

                                    // Merge currencies and requests arrays to exclude both from $currCodeNames
                                    $excludeCurrencies = array_merge($currencies, $requests);

                                    // Filter out NULL or invalid values (non-scalar values) from $excludeCurrencies
                                    $excludeCurrencies = array_filter($excludeCurrencies, function($value) {
                                        return is_scalar($value); // Keep only scalar values (strings or integers)
                                    });

                                    // Filter out the user's currencies and requests from the $currCodeNames array
                                    $filter = array_diff_key($currCodeNames, array_flip($excludeCurrencies));
                                
                                    foreach ($filter as $code => $name): // Get Remaining Currencies ?>

                                        <option value="<?= $code ?>"><?= $code . '(' . $name . ')' ?></option>

                                    <?php endforeach;

                                ?>
                            </select>
                                <input type="hidden" class="form-control" id="user-id" name="user-id"
                                value="<?= isset($user) ? $user : '' ?>">

                                <input type="hidden" class="form-control" id="acc-id" name="acc-id"
                                value="<?= isset($id) ? $id : '' ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="account-type">Account Type</label>
                            <select type="text" class="form-control" name="account-type">

                                <option value="CHECKING" <?= $accData['type'] == 'CHECKING' ? ' selected' : null ?>>Checking Account</option>
                                <option value="SAVINGS" <?= $accData['type'] == 'SAVINGS' ? ' selected' : null ?>>Saving Account</option>
                                <option value="FIXED DEPOSIT" <?= $accData['type'] == 'FIXED DEPOSIT' ? ' selected' : null ?>>Fixed Deposit Account</option>
                                <option value="CURRENT" <?= $accData['type'] == 'CURRENT' ? ' selected' : null ?>>Current Account</option>
                                <option value="JOINT" <?= $accData['type'] == 'JOINT' ? ' selected' : null ?>>Joint Account</option>
                                
                                <option value="NON RESIDENT" <?= $accData['type'] == 'NON RESIDENT' ? ' selected' : null ?>>Non Resident Account</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="balance">Balance</label>
                            <input type="number" class="form-control" name="balance" step="0.01" min="0" value="<?= $accData['balance'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="acc-number">Account Number</label>
                            <input type="number" class="form-control" name="acc-number" value="<?= $accData['acc-number'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="bank">Bank</label>
                            <select type="text" class="form-control" name="bank">

                                <option value="<?= $accData['bank-id'] ?>"><?= $accData['bank'] ?></option>

                                <option value="0">Select Bank</option>

                                <?php
                                
                                    $stmt = mysqli_prepare($conn, "SELECT * FROM `banks`");

                                    mysqli_stmt_execute($stmt);

                                    $result = mysqli_stmt_get_result($stmt);

                                    if (mysqli_num_rows($result) > 0) {

                                        while ($row = mysqli_fetch_assoc($result)) { ?>

                                            <option value="<?= $row['bank_id'] ?>"><?= $row['name'] . ' (' . $row['country'] . ')'  ?></option>

                                        <?php }

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt); // Close Statement

                                ?>

                            </select>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button id="edit-acc" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>