<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $planData = planData($id, $conn); //  Get Plan Data

        if (!$planData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "Plan not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

        // Look for Timing Factors

        $factors = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `timing_factors` ORDER BY `hours`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) {

            $factors = mysqli_fetch_all($result, MYSQLI_ASSOC); // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$factors) {

            echo '<script>
            
                swal({

                    icon: "warning",

                    title: "Important!",

                    text: "Please set up timing factors!"
                
                }).then(() => {
                
                    window.location.href = "timing";
                
                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid URL Parameter",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    } 

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Edit Investment Plan</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="payments" class="btn btn-secondary"><span>Payments</span> <em
                                        class="icon ni ni-coins"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-invest"></em> Edit <?= $planData['name'] ?></h5>
        </div>
        <form id="editPlanForm" method="post" enctype="multipart/form-data" autocomplete="off">
            <div class="card-body">
                <b>Plan Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-2">
                        <img class="w-100" src="<?= '../' . str_replace('../', '', $planData['image']) ?>" alt="">
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <label class="form-label" for="plan-name">Plan Name</label>
                            <input type="text" class="form-control" id="plan-name" name="plan-name"
                                placeholder="Plan Name (E.g BTC/ETH)" value="<?= $planData['name'] ?>" required>
                            <input type="hidden" name="old-image" value="<?= $planData['image'] ?>">
                            <input type="hidden" name="inv-id" value="<?= $id ?>">    
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="form-group">
                            <label class="form-label" for="plan-category">Plan Category</label>
                            <select class="form-control" id="plan-category" name="plan-category">

                                <option value="0">Select Plan Category</option>
                                
                                <option value="CRYPTO"<?= $planData['type'] == 'CRYPTO' ? ' selected' : null ?>>CRYPTO</option>

                                <option value="STOCKS"<?= $planData['type'] == 'STOCKS' ? ' selected' : null ?>>STOCKS</option>

                                <option value="FOREX"<?= $planData['type'] == 'FOREX' ? ' selected' : null ?>>FX</option>

                                <option value="COMMODITY"<?= $planData['type'] == 'COMMODITY' ? ' selected' : null ?>>COMMODITY</option>

                                <option value="REALTY"<?= $planData['type'] == 'REALTY' ? ' selected' : null ?>>REAL ESTATE</option>

                                <option value="OPTIONS"<?= $planData['type'] == 'OPTIONS' ? ' selected' : null ?>>OPTIONS</option>

                                <option value="BONDS"<?= $planData['type'] == 'BONDS' ? ' selected' : null ?>>BONDS</option>

                                <option value="OTHERS"<?= $planData['type'] == 'OTHERS' ? ' selected' : null ?>>OTHERS</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-return">ROI Type</label>
                            <select class="form-control" id="plan-return" name="plan-return">

                                <option value="0">Specify Return Type</option>

                                <option value="FIXED"<?= $planData['return'] == 'FIXED' ? ' selected' : null ?>>FIXED</option>

                                <option value="VARIABLE"<?= $planData['return'] == 'VARIABLE' ? ' selected' : null ?>>VARIABLE</option>

                                <option value="COMPOUND"<?= $planData['return'] == 'COMPOUND' ? ' selected' : null ?>>COMPOUND</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-min">Minimum Price (USD)</label>
                            <input type="number" step="0.01" class="form-control" id="plan-min" name="plan-min" value="<?= $planData['min'] ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-max">Maximum  Price (USD)</label>
                            <input type="number" step="0.01" class="form-control" id="plan-max" name="plan-max" value="<?= $planData['max'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-duration">Duration (DAYS)</label>
                            <input type="number" step="0.01" class="form-control" id="plan-duration" name="plan-duration" value="<?= $planData['lifetime'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-min">Interest Rate (%)</label>
                            <input type="number" step="0.01" class="form-control" id="plan-rate" name="plan-rate" value="<?= $planData['interest'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-frequency">Payout Frequency</label>
                            <select class="form-control" id="plan-frequency" name="plan-frequency">

                                <option value="0">Select Payout Frequency</option>

                                <?php
                                                                
                                    foreach($factors as $factor):

                                        echo '<option value="' . $factor['factor'] . '"' . (($factor['factor'] == $planData['payout']) ? ' selected' : null) . '>' . $factor['factor'] . '</option>';

                                    endforeach;
                                
                                ?>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-risk">Risk</label>
                            <select class="form-control" id="plan-risk" name="plan-risk">

                                <option value="0">Specify Risk</option>

                                <option value="LOW"<?= $planData['risk'] == 'LOW' ? ' selected' : null ?>>LOW</option>

                                <option value="MEDIUM"<?= $planData['risk'] == 'MEDIUM' ? ' selected' : null ?>>MEDIUM</option>

                                <option value="HIGH"<?= $planData['risk'] == 'HIGH' ? ' selected' : null ?>>HIGH</option>

                                <option value="VOLATILE"<?= $planData['risk'] == 'VOLATILE' ? ' selected' : null ?>>VOLATILE</option>

                                <option value="EXTREME"<?= $planData['risk'] == 'EXTREME' ? ' selected' : null ?>>EXTREME</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="plan-image">Plan Image (Optional)</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="plan-image" accept="image/*">
                                <label class="custom-file-label" for="plan-image">Upload Plan image</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="plan-desc">Short Description (Optional)</label>
                            <textarea class="form-control" id="plan-desc" name="plan-desc" placeholder="A paragraph describing the plan"><?= $planData['descr'] ?></textarea>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button onclick="return confirm('Have you confirmed the data?')" type="submit" id="editPlan" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>