<?php

    require('utility/partials/header.php');
    
    if (isset($_REQUEST['id']) && !empty($_REQUEST['id']) && isset($_REQUEST['user-id']) && !empty($_REQUEST['user-id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($user, $conn);

        $tpData = thirdPartyData($id, $conn);

        if (!$userData || !$tpData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error",

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
            
            swal({
            
                title: "Error!",

                text: "Invalid URL Credential!",

                icon: "error",

            }).then(() => {
            
                window.history.go(-1);

            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Edit Third Party (<?= $tpData['firstname'] . ' ' . $tpData['lastname'] ?>)</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="joint-users?id=<?= $user ?>" class="btn btn-warning"><span>Joint Users</span> <em
                                        class="icon ni ni-users"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-users"></em>Edit Joint User</h5>
        </div>
        <form id="editJointUserForm" method="post">
            <div class="card-body">
                <b>Personal Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="fname">Firstname</label>
                            <input type="text" class="form-control" name="fname" value="<?= $tpData['firstname'] ?>" required>
                            <input type="hidden" class="form-control" name="id" value="<?= $id ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="mname">Middlename</label>
                            <input type="text" class="form-control" name="mname" value="<?= $tpData['middlename'] ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="lname">Lastname</label>
                            <input type="text" class="form-control" name="lname" value="<?= $tpData['lastname'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="email">Email Address</label>
                            <input type="email" class="form-control" name="email" value="<?= $tpData['email'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="password">Password</label>
                            <input type="text" class="form-control" name="password" value="<?= $tpData['raw-key'] ?>" minlength="8" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="gender">Gender</label>
                            <select class="form-control" name="gender">
                                <option value="0">Select Gender</option>
                                <option value="Male"<?= $tpData['gender'] === 'Male' ? ' selected' : null ?>>Male</option>
                                <option value="Female"<?= $tpData['gender'] === 'Female' ? ' selected' : null ?>>Female</option>
                                <option value="Others"<?= $tpData['gender'] === 'Others' ? ' selected' : null ?>>Others</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="title">Title</label>
                            <select class="form-control" name="title">
                                <option value="0">Select Title</option>
                                <option value="Mr"<?= $tpData['title'] === 'Mr' ? ' selected' : null ?>>Mr</option>
                                <option value="Mrs"<?= $tpData['title'] === 'Mrs' ? ' selected' : null ?>>Mrs</option>
                                <option value="Ms"<?= $tpData['title'] === 'Ms' ? ' selected' : null ?>>Ms</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-12">
                        <br>
                        <b>Banking Details</b>
                        <hr>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="acc-status">Account Status</label>
                            <select class="form-control" name="acc-status">

                                <option value="0">Select Account Status</option>

                                <option value="ACTIVE"<?= $tpData['account-status'] === 'ACTIVE' ? ' selected' : null ?>>ACTIVE</option>

                                <option value="SUSPENDED"<?= $tpData['account-status'] === 'SUSPENDED' ? ' selected' : null ?>>SUSPENDED</option>

                                <option value="INACTIVE"<?= $tpData['account-status'] === 'INACTIVE' ? ' selected' : null ?>>INACTIVE</option>

                                <option value="TRANSFER DISABLED"<?= $tpData['account-status'] === 'TRANSFER DISABLED' ? ' selected' : null ?>>TRANSFER DISABLED</option>

                                <option value="WIRE DISABLED"<?= $tpData['account-status'] === 'WIRE DISABLED' ? ' selected' : null ?>>WIRE DISABLED</option>

                                <option value="LOCAL AND TAG DISABLED"<?= $tpData['account-status'] === 'LOCAL AND TAG DISABLED' ? ' selected' : null ?>>LOCAL & TAG DISABLED</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="wth-limit">Withdrawal Limit (Amount)</label>
                            <input type="number" class="form-control" name="wth-limit" step="0.01" min="1" value="<?= $tpData['wth-limit'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="trans-limit">Transaction Limit</label>
                            <input type="number" class="form-control" name="trans-limit" min="1" value="<?= $tpData['trans-limit'] ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="trans-count">Transaction Count</label>
                            <input type="number" class="form-control" name="trans-count" min="0" value="<?= $tpData['trans-count'] ?? 0 ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <span class="form-label">Restrict Account Access</span>
                            <div class="g-3 align-center flex-wrap">
                                
                                <?php
                                
                                    $userAccounts = userAccounts($user, $conn); // Main User Account

                                    if ($userAccounts) {

                                        $barred = $tpData['no-access']; // Get Barred Accounts

                                        if (is_null($barred)) {

                                            foreach ($userAccounts as $account) { 
                                                
                                                $currency = $account['currency']; ?>

                                                <div class="g">
                                                    <div class="form-group">
                                                        <input type="checkbox" class="form-control-checkbox" name="barred[]" value="<?= $currency ?>">
                                                        <label class="form-control-label" for="barred"><?= $currency ?></label>
                                                    </div>
                                                </div>

                                            <?php }

                                        } else {

                                            $barredList = array_map('trim', explode(',', $barred)); // Convert to an array

                                            foreach ($userAccounts as $index => $account): 
                                            
                                                $currency = $account['currency'];
                                                
                                                $checked = in_array($currency, $barredList); ?>
                                                
                                                <div class="g">
                                                    <div class="form-group">
                                                        <input type="checkbox" class="form-control-checkbox" name="barred[]" value="<?= $currency ?>"<?= $checked ? ' checked' : null ?>>
                                                        <label class="form-control-label" for="barred"><?= $currency ?></label>
                                                    </div>
                                                </div>

                                            <?php endforeach;

                                        }    

                                    } else {

                                        echo '<p>No account found!</p>';

                                    }
                                
                                ?>

                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button id="editJointUser" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>