<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $found = false;

        $stmt = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `trans_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {

            $found = true;

            while ($row = mysqli_fetch_assoc($result)) {

                $date = $row['date'];

                $user = $row['user_id'];

                $type = $row['type'];

                $scope = $row['action'];

                $account = $row['acc_id'];

                $amount = $row['amount'];

                $dest = $row['recpt_acc'];

                $recipient = $row['recpt_name'];

                $bank = $row['recpt_bank'];

                $descr = $row['descr'];

                $codeType = $row['banking_codetype'];

                $code = $row['banking_code'];

                $status = $row['status'];

                $approval = $row['approval_flag'];

            }

        }

        mysqli_free_result($result);

        mysqli_stmt_close($stmt);

        if (!$found) {

            echo '<script>
        
                swal({
                
                    title: "Error!",

                    text: "Transaction not found",

                    icon: "error"
                
                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

        $thirdParty = false; // Third Party Flag

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            $userData = thirdPartyData($user, $conn); // Try Third Party

            if ($userData) {

                $thirdParty = true; // Update Flag

                $mainUser = $userData['main-user'];
  
            }

        }

        if (!$userData) {

            echo '<script>
        
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error"
                
                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid URL Parameter",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">

     <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Edit Transaction.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.back(-1)" class="btn btn-info text-white"><span>Back</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="create-user" class="btn btn-primary"><span>Add new account</span> <em
                                        class="icon ni ni-user-add-fill"></em></a></li>

                        </ul>

                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    
    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-edit"></em>Edit Transaction</h5>
        </div>
        <form id="transcForm" method="post">
            <div class="card-body">
                <b>Edit Transaction ~ <?= $id ?></b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="trans-date">Date</label>
                            <input type="datetime-local" class="form-control" name="transc-date" required value="<?= $date ?>">
                                <input type="hidden" class="form-control" id="user-id" name="user-id"
                                value="<?= $user ?>">
                                <input type="hidden" class="form-control" id="transc-id" name="transc-id"
                                value="<?= $id ?>">
                                <input type="hidden" class="form-control" id="approval-flag" name="approval-flag"
                                value="<?= $approval ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="transc-type">Type</label>
                            <select class="form-control" name="transc-type">

                                <option value="CREDIT"<?= $type == 'CREDIT' ? ' selected' : null ?>>CREDIT</option>

                                <option value="DEBIT"<?= $type == 'DEBIT' ? ' selected' : null ?>>DEBIT</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="transc-action">Scope</label>
                            <select class="form-control" name="transc-action">

                                <option value="0">Select Transaction Scope</option>

                                <option value="DEPOSIT"<?= $scope == 'DEPOSIT' ? ' selected' : null ?>>DEPOSIT</option>
                                
                                <option value="WITHDRAWAL"<?= $scope == 'WITHDRAWAL' ? ' selected' : null ?>>WITHDRAWAL</option>
                                
                                <option value="SERVICE FEE"<?= $scope == 'SERVICE FEE' ? ' selected' : null ?>>SERVICE FEE / CHARGE</option>

                                <option value="CROSS-BORDER TRANSFER"<?= $scope == 'CROSS-BORDER TRANSFER' ? ' selected' : null ?>>CROSS-BORDER TRANSFER</option>

                                <option value="LOCAL TRANSFER"<?= $scope == 'LOCAL TRANSFER' ? ' selected' : null ?>>LOCAL TRANSFER</option>

                                <option value="SWAP"<?= $scope == 'SWAP' ? ' selected' : null ?>>CURRENCY SWAP</option>

                                <option value="LOAN"<?= $scope == 'LOAN' ? ' selected' : null ?>>LOAN</option>

                                <option value="ROI"<?= $scope == 'ROI' ? ' selected' : null ?>>ROI</option>

                                <option value="MISCELLANOUS"<?= $scope == 'MISCELLANOUS' ? ' selected' : null ?>>OTHERS</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="transc-account">Account / Currency</label>
                            <select type="text" class="form-control" id="code-pay" name="transc-account">                                

                                <option value="0">Select Account</option>

                                <?php

                                    $userAccounts = userAccounts($user, $conn);

                                    if (!$userAccounts && $thirdParty) {

                                        $userAccounts = userAccounts($mainUser, $conn);

                                    } 

                                    if ($userAccounts) {

                                        foreach ($userAccounts as $row): ?>

                                            <option value="<?= $row['acc_id'] ?>"<?= $row['acc_id'] == $account ? ' selected' : null ?>><?= $row['currency'] ?></option>

                                        <?php endforeach;

                                    }

                                ?>    

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="transc-amount">Amount</label>
                            <input type="number" class="form-control" min="0.01" step="0.01" id="transc-amount" name="transc-amount" value="<?= $amount ?>" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="code-percent">Recipient Account (For Transfers)</label>
                            <input type="text" class="form-control" id="transc-destination" name="transc-destination" value="<?= $dest ?>">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="transc-bank">Recipient Bank (For Transfers)</label>
                            <input type="text" class="form-control" id="code-amount" name="transc-bank" value="<?= $bank ?>">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="transc-recipient">Recipient / Account Name (For Transfers)</label>
                            <input type="text" class="form-control" name="transc-recipient" value="<?= $recipient ?>">
                        </div>
                    </div>
                   <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="transc-code-type">Banking Code Type (For Cross-border Transfers)</label>
                            <select class="form-control" name="transc-code-type">

                                <option value="0">Select Code Type</option>

                                <option value="SWIFT CODE"<?= $codeType == 'SWIFT CODE' ? ' selected' : null ?>>SWIFT CODE</option>

                                <option value="IBAN"<?= $codeType == 'IBAN' ? ' selected' : null ?>>IBAN</option>

                                <option value="SORT CODE"<?= $codeType == 'SORT CODE' ? ' selected' : null ?>>SORT CODE</option>
                                
                                <option value="ABA NUMBER"<?= $codeType == 'ABA NUMBER' ? ' selected' : null ?>>ABA NUMBER</option>

                                <option value="CLABE"<?= $codeType == 'CLABE' ? ' selected' : null ?>>CLABE</option>

                                <option value="IFSC"<?= $codeType == 'IFSC' ? ' selected' : null ?>>IFSC</option>

                                <option value="BSB"<?= $codeType == 'BSB' ? ' selected' : null ?>>BSB</option>

                                <option value="RTN"<?= $codeType == 'RTN' ? ' selected' : null ?>>RTN</option>

                                <option value="NSC"<?= $codeType == 'NSC' ? ' selected' : null ?>>NSC</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="transc-bank-code">Bank Code(For Cross-border Transfers)</label>
                            <input type="text" class="form-control" name="transc-bank-code" value="<?= $code ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="transc-status">Status</label>
                            <select class="form-control" name="transc-status">

                                <option value="COMPLETED"<?= $status == 'COMPLETED' ? ' selected' : null ?>>COMPLETED</option>

                                <option value="INCOMPLETE"<?= $status == 'INCOMPLETE' ? ' selected' : null ?>>INCOMPLETE</option>

                                <option value="PENDING"<?= $status == 'PENDING' ? ' selected' : null ?>>PENDING</option>

                                <option value="DISPUTED"<?= $status == 'DISPUTED' ? ' selected' : null ?>>DISPUTED</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label" for="transc-descr">Description</label>
                            <textarea class="form-control" id="code-desc" name="transc-descr"><?= $descr ?></textarea>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button onclick="return confirm('Have you confirmed the data?')" type="submit" id="edit-transc" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>