<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $accounts = userAccounts($id, $conn); // Fetch User Accounts

        if (!$accounts) {

            echo '<script>
        
                swal({
                
                    title: "Error!",

                    text: "Couldn\'t find any account!",

                    icon: "error"
                
                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }
    

    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid URL Parameter",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Fund User.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="debit-user?id=<?= $id ?>" class="btn btn-danger"><span>Debit User</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-preview card-bordered">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-wallet-fill"></em>Credit User Account</h5>
        </div>
        <form id="creditForm" method="post">
            <div class="card-body">
                <div class="form-control-group p-2">
                    <label for="account">Account</label>
                    <input type="hidden" name="user-id" value="<?= isset($id) ? $id : '' ?>">
                    <select name="account" class="form-control form-control-lg form-control-outlined">

                        <option value="0">Select an Account</option>

                        <?php
                        
                            if ($accounts) {

                                foreach ($accounts as $account): ?>

                                    <option value="<?= $account['acc_id'] ?>"><?= $account['currency'] . ' [' . $account['acc_num'] . '] ' . $currSymbol[$account['currency']] . number_format($account['balance'], 2) ?></option>

                                <?php endforeach;

                            }
                        
                        ?>

                    </select>
                </div>
                <div class="form-control-group p-2">
                    <label for="amount">Amount</label>
                    <input type="number" step="0.01" class="form-control form-control" id="amount" name="amount" required>
                </div>
                <div class="form-control-group p-2">
                    <label>Datetime</label>
                    <input type="datetime-local" class="form-control form-control" id="date" name="date">
                </div>
                <div class="form-control-wrap p-2">
                    <label for="descr">Description</label>
                    <textarea class="form-control nicEdit" id="" name="descr" placeholder="Description"></textarea>
                </div>
            </div>
            <div class="card-footer">
                <button class="btn btn-primary" type="submit" id="creditBtn" onclick="return confirm('Have you verified the details?')">Proceed</button>
            </div>    
        </form>
    </div>
</div>

<?php

    require('utility/partials/footer.php');

?>