<?php

    require('utility/partials/header.php');
    
    // checkInstallUrl($site_url)

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn);

        if (!$userData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error",

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;

        } else if (!jointAccounts($id, $conn)) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "Requires a joint account!",

                    icon: "warning",

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
            
            swal({
            
                title: "Error!",

                text: "Invalid URL Credential!",

                icon: "error",

            }).then(() => {
            
                window.history.go(-1);

            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Third Party Users</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="billing-codes?id=<?= $id ?>" class="btn btn-dark"><span>See Billing Codes</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?= join (' ', [$userData['firstname'], $userData['lastname']]) ?> Joint Users <?= '(' . thirdPartyCount($id, $conn) . ')' ?></h4>
                <div class="nk-block-des">
                    <p>Below is the list of Third Party Users</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">                         
                            <th class="nk-tb-col"><span class="sub-text">#</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Withdrawal Limit</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Transactions / Limit</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">Barred Access</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $found = false; // Flag

                            // Fetch All User's Joint Holders
                        
                            $stmt = mysqli_prepare($conn, "SELECT * FROM `third_party` WHERE `user_id` = ? ORDER BY `id` DESC"); // Prepare Statement

                            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($found) {

                                $i = 0; 

                                foreach ($data as $row): // Iterate Through Rows

                                    $i++;

                                    $tpyID = $row['tp_id'];

                                    $name = join(' ', [$row['fname'], $row['lname']]);

                                    $email = $row['email'];

                                    $wLimit = $row['wth_limit'] ?? 0;

                                    $tLimit = $row['trans_limit'] ?? 0.00;

                                    $tCount = $row['trans_count'] ?? 0;

                                    $barred = $row['no_access'] ?? 'NONE';

                                    $status = $row['status'];

                                ?>    

                                    <tr class="nk-tb-item">
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $i ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $name ?></span>
                                            <span><?= $email ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $tCount . '/' . $tLimit ?></span>
                                        </td>
                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= $barred ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $status ?></span>
                                        </td>
                                        
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form class="jointUserMgmt-form" method="post">
                                                <input type="hidden" name="tpy-id" value="<?= $tpyID ?>">
                                                <ul class="nk-tb-actions gx-1">
                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" value="DELETE" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Delete User">
                                                            <em class="icon ni ni-trash text-danger"></em>
                                                        </button>
                                                    </li>

                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" value="RESET" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Reset Limits">
                                                            <em class="icon ni ni-reload text-success"></em>
                                                        </button>
                                                    </li>

                                                    <li>
                                                        <div class="dropdown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <!-- <li class="divider"></li> -->
                                                                    <li><a href="third-party-transactions?id=<?= $tpyID ?>"><em
                                                                                class="icon ni ni-repeat"></em><span>Transactions</span></a>
                                                                    </li>
                                                                    <li><a href="billing-codes?id=<?= $tpyID ?>"><em class="icon ni ni-unlock"></em><span>Billing Codes</span></a>
                                                                    </li>
                                                                    <li><a href="edit-joint-user?id=<?= $tpyID ?>&user-id=<?= $id ?>"><em class="icon ni ni-edit"></em><span>Edit Joint User</span></a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </form>
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-users"></em> Add a Joint User</h5>
        </div>
        <form id="addJointUserForm" method="post">
            <div class="card-body">
                <b>Personal Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="fname">Firstname</label>
                            <input type="text" class="form-control" name="fname" required>
                            <input type="hidden" class="form-control" name="id" value="<?= $id ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="mname">Middlename</label>
                            <input type="text" class="form-control" name="mname">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="lname">Lastname</label>
                            <input type="text" class="form-control" name="lname" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="email">Email Address</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="gender">Gender</label>
                            <select class="form-control" name="gender">
                                <option value="0">Select Gender</option>
                                <option value="Male">Male</option>
                                <option value="Female">Female</option>
                                <option value="Others">Others</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="title">Title</label>
                            <select class="form-control" name="title">
                                <option value="0">Select Title</option>
                                <option value="Mr">Mr</option>
                                <option value="Mrs">Mrs</option>
                                <option value="Ms">Ms</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-12">
                        <br>
                        <b>Banking Details</b>
                        <hr>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="acc-status">Account Status</label>
                            <select class="form-control" name="acc-status">

                                <option value="0">Select Account Status</option>

                                <option value="ACTIVE">ACTIVE</option>

                                <option value="SUSPENDED">SUSPENDED</option>

                                <option value="INACTIVE">INACTIVE</option>

                                <option value="TRANSFER DISABLED">TRANSFER DISABLED</option>

                                <option value="WIRE DISABLED">WIRE DISABLED</option>

                                <option value="LOCAL AND TAG DISABLED">LOCAL & TAG DISABLED</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="wth-limit">Withdrawal Limit (Amount)</label>
                            <input type="number" class="form-control" name="wth-limit" step="0.01" min="1" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="trans-limit">Transaction Limit</label>
                            <input type="number" class="form-control" name="trans-limit" min="1" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <span class="form-label">Restrict Account Access</span>
                            <div class="g-3 align-center flex-wrap">
                                
                                <?php
                                
                                    $userAccounts = userAccounts($id, $conn);

                                    if ($userAccounts) {

                                        foreach ($userAccounts as $account): 
                                        
                                            $currency = $account['currency']; ?>
                                            
                                            <div class="g">
                                                <div class="form-group">
                                                    <input type="checkbox" class="form-control-checkbox" name="barred[]" value="<?= $currency ?>">
                                                    <label class="form-control-label" for="barred"><?= $currency ?></label>
                                                </div>
                                            </div>

                                        <?php endforeach;

                                    } else {

                                        echo '<p>No Account Found</p>';

                                    }
                                
                                ?>

                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button id="addJointUser" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>