<?php

    require('utility/partials/header.php');
    
    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Get Subscription Payout Schedule

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `repayments_schedule` WHERE `loan_id` = ? ORDER BY `id`"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s) 

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data


        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$found) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "Repayment schedule not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid Data",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal"><?= $id ?> <i>Repayment Schedule</i></span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">Repayment Schedule</h4>
                <div class="nk-block-des">
                    <p>Below is the list of All Repayments</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">

                        <th class="nk-tb-col">#</th>

                        <th class="nk-tb-col"><span class="sub-text">Due Date</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Amount</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Action</span></th>
                    </tr>
                </thead>
                <tbody>

                    <?php
                    
                        // Check Flag

                        if ($found) {

                            // Iterate Through Records

                            $i = 0; // Intiate Counter

                            foreach ($data as $row):

                                $i++; // Increment Counter

                                $payID = $row['id'];

                                $due = strtotime($row['due']);

                                $amount = $row['amount'];

                                $status = $row['status'];
                                
                                if ($status == 'PAID') {

                                    $status = '<span class="text-success">' . $status . '</span>';

                                } else if ($status == 'OVERDUE') {

                                    $status = '<span class="text-danger">' . $status . '</span>';

                                } else {

                                    $status = '<span class="text-warning">' . $status . '</span>';

                                } ?>

                                <tr class="nk-tb-item">
                                    <td class="nk-tb-col">
                                        <span><?= $i ?></span>
                                    </td>
                                    <td class="nk-tb-col">
                                        <div class="user-card">
                                            <div class="user-info">
                                                <span class="tb-lead">
                                                    <?= date('l M d, Y', $due) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <span class="tb-lead">
                                            <?= $amount ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <?= $status ?>
                                    </td>
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <form method="post" class="user-rpym-form">

                                            <input type="hidden" name="repay-id" value="<?= $payID ?>">

                                            <ul class="nk-tb-actions gx-1">

                                                <li class="nk-tb-action-hidden">

                                                    <a href="edit-repayment?id=<?= $payID ?>" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Edit Repayment Record">
                                                        <em class="icon ni ni-edit text-primary"></em>
                                                    </a>

                                                </li>

                                                <li class="nk-tb-action-hidden">

                                                    <button type="submit" name="delete" value="DELETE" class="btn btn-trigger btn-icon"
                                                        data-toggle="tooltip" data-placement="top" title="Delete Repayment Record">
                                                        <em class="icon ni ni-trash text-danger"></em>
                                                    </button>

                                                </li>

                                            </ul>

                                        </form>    


                                    </td>
                                </tr>

                            <?php endforeach;

                        }

                    ?>

                </tbody>
            </table>
        </div>
    </div><!-- .card-preview -->
    </div> <!-- nk-block -->

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>