<?php

    require('utility/partials/header.php');

?>

<div class="nk-content">
  <div class="container-xl wide-lg">
    <div class="nk-content-body">
      <div class="nk-block-head">
        <div class="nk-block-head-sub">
        </div>
        <div class="nk-block-between-md g-4 card-bordered">
          <div class="nk-block-head-content">
            <h4 class="nk-block-title fw-normal">Log in activity</h4>
            <div class="nk-block-des">
              <p>Recent Log in</p>
            </div>
          </div>
          <div class="nk-block-head-content">
            <ul class="nk-block-tools gx-3">
              <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em
                    class="icon ni ni-arrow-left"></em></a></li>
              <li><a href="fund-user" class="btn btn-success"><span>Fund an account</span> <em
                    class="icon ni ni-invest"></em></a></li>
            </ul>
          </div><!-- .nk-block-head-content -->
        </div><!-- .nk-block-between -->
      </div><!-- .nk-block-head -->
    </div>
  </div>
  <div class="card card-preview ">
    <div class="card-inner p-0">
      <table class="datatable-init table">
        <thead>
          <tr>
            <th>Date</th>
            <th>IP</th>
            <th>User</th>
            <th>Device</th>
            <th>Browser</th>
            <th>Location</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>

          <?php

            $found = false; // Flag
          
            $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname` FROM `activity_logs` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` ORDER BY `A`.`id` DESC"); // Prepare Statement

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

              $found = true; // Update Flag

              $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($stmt); // Close Statement

            if ($found) { // Check Flag

                foreach($data as $row):

                    $rowId = $row['id'];

                    $userName = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                    $date = $row['logged_in'];

                    $ip = $row['ip_address'] ?? 'UNKNOWN';

                    $device = $row['device'] ?? 'UNKNOWN';

                    $browser = $row['browser'] ?? 'UNKNOWN';

                    $location = $row['location'] ?? 'UNKNOWN';

                    $status = $row['status'] ?? 'UNCERTAIN'; ?>

                    <tr>

                    <td><?= date('l d M, Y (H:i)', strtotime($date)) ?></td>

                    <td><?= $ip ?></td>

                    <td><p><?= $userName ?? 'UNKNOWN' ?></p></td>

                    <td><?= $device ?></td>

                    <td><?= $browser ?></td>

                    <td><?= $location ?></td>

                    <td><p><?= $status ?></p></td>

                    <td>
                        <form method="post" class="log-mgmt-form">
                        <input type="hidden" name="log-id" value="<?= $rowId ?>">
                        <button class="btn btn-sm text-danger bg-white" type="submit"><em class="icon ni ni-trash"></em> Delete</button>
                        </form>
                    </td>

                    </tr>

                <?php endforeach;

            }
          
          ?>
        
        </tbody>
      </table>
    </div>
  </div>

  <?php

  require('utility/partials/footer.php');

?>