<?php

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">General Settings.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="branding" class="btn btn-success"><span>Logo Settings</span> <em
                                        class="icon ni ni-setting"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="title nk-block-title">Basic settings</h4>
                <div class="nk-block-des">
                    <p>You can modify the basic contents of the website using the form below.</p>
                </div>
            </div>
        </div>
        <div class="card card-bordered">
            <div class="card-inner">
                <div class="card-head">
                    <h5 class="card-title">Website Setting</h5>
                </div>
                <form class="gy-3" id="webForm" method="post">
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="site-name">Base URL</label>
                                <span class="form-note">Specify the exact url where your website is installed.(e.g
                                    "https://example.com" for domain and "https://example.com/folder" for folder
                                    level)</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" id="webURL" value="<?= SITE_BASE_URL ?>"
                                        name="webURL" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="site-name">Home Page URL</label>
                                <span class="form-note">Specify the exact url of your website Homepage</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" id="webHome" value="<?= HOME_PAGE ?>"
                                        name="webHome">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="site-name">Site Name</label>
                                <span class="form-note">Specify the name of your website. (e.g Facebook LLC)</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" id="webName" value="<?= SITE_NAME ?>"
                                        name="webName" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="site-name">Site title</label>
                                <span class="form-note">Specify the Title of your website. (e.g Facebook LLC)</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" id="webTitle" value="<?= SITE_TITLE ?>"
                                        name="webTitle" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Site Description</label>
                                <span class="form-note">Specify site description, for SEO (Meta Tag)</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <textarea class="form-control" id="webDescr"
                                        name="webDescr" required><?= SITE_DESCR ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Email address</label>
                                <span class="form-note">Specify the email of your website.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="email" class="form-control" id="webMail"
                                        name="webMail" value="<?= SITE_CONTACT_EMAIL ?>" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Bank Name</label>
                                <span class="form-note">Specify the name of your bank.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="tel" class="form-control" id="bankName"
                                        name="bankName" value="<?= BANK_NAME ?>" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Bank Address</label>
                                <span class="form-note">Your Bank's physical address</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <textarea class="form-control" id="bankAddr"
                                        name="bankAddr"><?= BANK_ADDRESS ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Phone Number</label>
                                <span class="form-note">Specify the phone number of your website.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="tel" class="form-control" id="webPhone"
                                        name="webPhone" value="<?= BANK_PHONE ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Support URL (Live Chat)</label>
                                <span class="form-note">Specify the address of your company.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" id="webSupport"
                                        value="<?= SITE_SUPPORT ?>" name="webSupport" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Crypto Vendor URL (Buy Crypto)</label>
                                <span class="form-note">Specify the address link to purchase crypto for pay page.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" id="webVendor"
                                        value="<?= CRYPTO_VENDOR ?>" name="webVendor" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Virtual Card Fee (USD)</label>
                                <span class="form-note">Specify Fee for New Virtual Card.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="number" step="0.01" class="form-control" id="webCardFee"
                                        value="<?= CARD_FEE ?>" name="webCardFee" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Max Virtual Cards</label>
                                <span class="form-note">Specify maximum cards per user (Leave empty for no limit, Set as Zero (0) for no cards).</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="number" step="0.01" class="form-control" id="webCardMax"
                                        value="<?= MAX_CARD ?>" name="webCardMax">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Swap Rate (%)</label>
                                <span class="form-note">Specify currency swap rate.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="number" step="0.1" class="form-control" id="webSwap"
                                        value="<?= SWAP_RATE ?>" name="webSwap" placeholder="3.8%" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr>

                    <div class="data-head">
                        <h6 class="overline-title">Preferences</h6>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">KYC Required</label>
                                <span class="form-note">Make KYC required. Must be completed to gain access to dashboard.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (KYC_PREF == 'REQUIRED') ? ' checked' : '' ?> value="REQUIRED" name="kycPref" id="kyc-enable" required>
                                        <label class="custom-control-label" for="kyc-enable">YES</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"value="NOT REQUIRED"<?= (KYC_PREF == 'NOT REQUIRED') ? ' checked' : '' ?> name="kycPref" id="kyc-disable">
                                        <label class="custom-control-label" for="kyc-disable">NO</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Registration Approval.</label>
                                <span class="form-note">Decide to manually approve registration.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (REG_PREF == 'MANUAL') ? ' checked' : '' ?> value="MANUAL" name="regPref" id="reg-enable" required>
                                        <label class="custom-control-label" for="reg-enable">ENABLED</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (REG_PREF == 'AUTOMATIC') ? ' checked' : '' ?> value="AUTOMATIC" name="regPref" id="reg-disable">
                                        <label class="custom-control-label" for="reg-disable">DISABLED</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Transaction Approval.</label>
                                <span class="form-note">Decide if all transactions should be automatically approved or not .</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (TRANSF_PREF == 'MANUAL') ? ' checked' : '' ?> value="MANUAL" name="transfPref" id="transc-enable" required>
                                        <label class="custom-control-label" for="transc-enable">MANUAL</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (TRANSF_PREF == 'AUTOMATIC') ? ' checked' : '' ?> value="AUTOMATIC" name="transfPref" id="transc-disable">
                                        <label class="custom-control-label" for="transc-disable">AUTOMATIC</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Account Request Approval.</label>
                                <span class="form-note">Decide to manually approve account requests.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (ACC_PREF == 'MANUAL') ? ' checked' : '' ?> value="MANUAL" name="accPref" id="acc-enable" required>
                                        <label class="custom-control-label" for="acc-enable">MANUAL</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (ACC_PREF == 'AUTOMATIC') ? ' checked' : '' ?> value="AUTOMATIC" name="accPref" id="acc-disable">
                                        <label class="custom-control-label" for="acc-disable">AUTOMATIC</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Virtual Card Request Approval.</label>
                                <span class="form-note">Decide to manually approve virtual card requests.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (CARD_PREF == 'MANUAL') ? ' checked' : '' ?> value="MANUAL" name="cardPref" id="card-enable" required>
                                        <label class="custom-control-label" for="card-enable">MANUAL</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (CARD_PREF == 'AUTOMATIC') ? ' checked' : '' ?> value="AUTOMATIC" name="cardPref" id="card-disable">
                                        <label class="custom-control-label" for="card-disable">AUTOMATIC</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <!-- <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Face ID Login.</label>
                                <span class="form-note">Allow Face ID Login.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (FACE_ID == 'ENABLED') ? ' checked' : '' ?> value="ENABLED" name="faceID" id="faceID-enable" required>
                                        <label class="custom-control-label" for="faceID-enable">ENABLED</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (FACE_ID == 'DISABLED') ? ' checked' : '' ?> value="DISABLED" name="faceID" id="faceID-disable">
                                        <label class="custom-control-label" for="faceID-disable">DISABLED</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>
                        </div>
                    </div> -->

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Display User Login Info</label>
                                <span class="form-note">Display user login info on dashboard.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (DISPLAY_UI == 'ENABLED') ? ' checked' : '' ?> value="ENABLED" name="user-info" id="user-info-enable" required>
                                        <label class="custom-control-label" for="user-info-enable">YES</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input" value="DISABLED"<?= (DISPLAY_UI == 'DISABLED') ? ' checked' : '' ?> name="user-info" id="user-info-disable">
                                        <label class="custom-control-label" for="user-info-disable">NO</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label">Pay page popup</label>
                                <span class="form-note">Display Popup on pay page load, notify users to double-check addresses.</span>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <ul class="custom-control-group g-3 align-center flex-wrap">
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input"<?= (PAY_POPUP == 'ON') ? ' checked' : '' ?> value="ON" name="pay-popup" id="pay-popup-enable" required>
                                        <label class="custom-control-label" for="pay-popup-enable">YES</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" class="custom-control-input" value="OFF"<?= (PAY_POPUP == 'OFF') ? ' checked' : '' ?> name="pay-popup" id="pay-popup-disable">
                                        <label class="custom-control-label" for="pay-popup-disable">NO</label>
                                    </div>
                                </li>
                                <li>
                                </li>
                            </ul>
                        </div>
                    </div>

                    <hr>
                    
                    <div class="row g-3">
                        <div class="col-lg-7 offset-lg-5">
                            <div class="form-group mt-2">
                                <button type="submit" class="btn btn-lg btn-primary" id="webBtn" onclick="return confirm('Have you confirmed the information?')">Update</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- card -->
    </div><!-- .nk-block -->

</div>

<?php

    require('utility/partials/footer.php');

?>