<?php

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Support Tickets</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="settings"
                                    class="btn btn-info">
                                    <span>General Settings</span> <em class="icon ni ni-setting"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">
                    Support Tickets (<?= ticketsCount($conn) ?>)
                </h4>
                <div class="nk-block-des">
                    <p>Below is the list of support tickets</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col"><span class="sub-text">#</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Chat ID</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">User</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Last Seen</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Created</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $found = false; // Flag

                            // Fetch Ticket Data
                        
                            // $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`created_at` AS `message_time`, `B`.`message_text` AS `last_message`, `B`.`sender` AS `party`, COALESCE(`C`.`email`, `D`.`email`) AS `email`, COALESCE(`C`.`fname`, `D`.`fname`) AS `fname`, COALESCE(`C`.`mname`, `D`.`mname`) AS `mname`, COALESCE(`C`.`lname`, `D`.`lname`) AS `lname`, CASE WHEN `C`.`user_id` IS NOT NULL THEN 'USER' WHEN `D`.`tp_id` IS NOT NULL THEN 'THIRD PARTY' ELSE 'UNKNOWN' END AS `user_type` FROM `support_tickets` AS `A` LEFT JOIN (SELECT `ticket_id`, `created_at`, `message_text`, `sender` FROM `messages` WHERE (`ticket_id`, `created_at`) IN (SELECT `ticket_id`, MAX(`created_at`) FROM `messages` GROUP BY `ticket_id`)) AS `B` ON `A`.`ticket_id` = `B`.`ticket_id` LEFT JOIN `users` AS `C` ON `A`.`user_id` = `C`.`user_id` LEFT JOIN `third_party` AS `D` ON `A`.`user_id` = `D`.`tp_id` ORDER BY `B`.`created_at` DESC"); // Prepare Statement

                            $stmt = mysqli_prepare($conn, "SELECT 
  A.*, 
  B.created_at AS message_time, 
  B.message_text AS last_message, 
  B.sender AS party, 
  COALESCE(C.email, D.email) AS email, 
  COALESCE(C.fname, D.fname) AS fname, 
  COALESCE(C.mname, D.mname) AS mname, 
  COALESCE(C.lname, D.lname) AS lname, 
  CASE 
    WHEN C.user_id IS NOT NULL THEN 'USER' 
    WHEN D.tp_id IS NOT NULL THEN 'THIRD PARTY' 
    ELSE 'UNKNOWN' 
  END AS user_type 
FROM support_tickets AS A 
LEFT JOIN (
  SELECT ticket_id, created_at, message_text, sender
  FROM (
    SELECT
      ticket_id,
      created_at,
      message_text,
      sender,
      ROW_NUMBER() OVER (PARTITION BY ticket_id ORDER BY created_at DESC) AS rn
    FROM messages
  ) t
  WHERE rn = 1
) AS B ON A.ticket_id = B.ticket_id 
LEFT JOIN users AS C ON A.user_id = C.user_id 
LEFT JOIN third_party AS D ON A.user_id = D.tp_id 
ORDER BY B.created_at DESC");

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($found) {

                                $i = 0; 

                                foreach ($data as $row): // Iterate Through Rows

                                    $i++;

                                    $id = $row['ticket_id'];

                                    $user = $row['user_id'];

                                    $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                    $email = $row['email'];

                                    $created = date('D M d, Y (H:i)', strtotime($row['created_at']));

                                    $lastMsg = $row['last_message'];

                                    if (strlen($lastMsg) > 12) {

                                        $lastMsg = substr($lastMsg, 0, 12) . '...';

                                    }

                                    $msgTime = date('D M d, Y (H:i)', strtotime($row['message_time']));

                                    $party = $row['party'];

                                    if ($party == $user) {

                                        $sender = join(' ', [$row['fname'], $row['lname']]);

                                    } else {

                                        $sender = 'You';

                                    }

                                    $status = $row['status'];

                        ?>

                            <tr class="nk-tb-item">
                                <td class="nk-tb-col">
                                    <span>
                                        <?= $i ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col tb-col-md">
                                    <span class="tb-lead">
                                        <?= $id ?>
                                    </span>
                                    <span><?= $status ?></span>
                                </td>
                                <td class="nk-tb-col">
                                    <div class="user-card">
                                        <div class="user-info">
                                            <span class="tb-lead">
                                                <?= $name ?>
                                            </span>
                                            <span>
                                                <?= $email ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="nk-tb-col tb-col-md">
                                    <span class="tb-lead"><?= $sender. ': ' . $lastMsg ?></span>
                                    <span><?= $msgTime ?></span>
                                </td>
                                <td class="nk-tb-col tb-col-lg" data-order="">
                                    <div class="user-info">
                                        <span class="tb-lead">
                                            <?= $created ?>
                                        </span>
                                    </div>
                                </td>

                                <td class="nk-tb-col nk-tb-col-tools text-right">
                                    <form method="post" class="ticket-mgmt-form">
                                        <input type="hidden" name="ticket-id" value="<?= $id ?>">
                                        <ul class="nk-tb-actions gx-1">
                                            
                                            <li class="nk-tb-action-hidden">
                                                <a href="chat-conversation?id=<?= $id ?>"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Reply / View Chat">
                                                    <em class="icon ni ni-chat text-info"></em>
                                                </a>
                                            </li>
                                            <?php

                                                if ($status == 'OPEN' || $status == 'REPLIED' || $status == 'ANSWERED') { ?>

                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" name="pause-chat" value="PAUSE"
                                                            class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                            title="Pause / Put On Hold">
                                                            <em class="icon ni ni-pause text-warning"></em>
                                                        </button>
                                                    </li>

                                                <?php } else if ($status == 'ON HOLD') { ?>

                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" name="resume-chat" value="RESUME"
                                                            class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                            title="Disable Hold / Resume">
                                                            <em class="icon ni ni-play text-success"></em>
                                                        </button>
                                                    </li>

                                                <?php }

                                            ?>
                                            <li class="nk-tb-action-hidden">
                                                <button type="submit" name="delete" value="DELETE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Delete Conversation">
                                                    <em class="icon ni ni-trash text-danger"></em>
                                                </button>
                                            </li>
                                        </ul>
                                    </form>
                                </td>
                            </tr>

                        <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->

</div><!-- .components-preview -->


<?php

    require('utility/partials/footer.php');

?>