<?php 

    require('utility/partials/header.php');

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">All time transactions.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a href="dashboard" class="btn btn-primary"><span>Home</span> <em
                                        class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="fund-user" class="btn btn-success"><span>Fund an account</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>

    <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">
                        <th class="nk-tb-col"><span class="sub-text">#</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Ref Number</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Initiator / Account</span></th>
                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">Amount</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Description</span></th>
                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Type</span></th>
                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Scope</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Action</span></th>

                    </tr>
                </thead>
                <tbody>

                    <?php
                    
                        // Get All Transactions

                        $foundTransc = false; // Flag 

                        $transactions = mysqli_prepare($conn, "SELECT `A`.*, COALESCE(`B`.`fname`, `C`.`fname`) AS `fname`, COALESCE(`B`.`mname`, `C`.`mname`) AS `mname`, COALESCE(`B`.`lname`, `C`.`lname`) AS `lname`, CASE WHEN `B`.`user_id` IS NOT NULL THEN 'USER' WHEN `C`.`tp_id` IS NOT NULL THEN 'THIRD PARTY' ELSE 'UNKNOWN' END AS `user_type` FROM `transactions` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` LEFT JOIN `third_party` AS `C` ON `A`.`user_id` = `C`.`tp_id` ORDER BY `A`.`date` DESC"); // Prepare Statement

                        mysqli_stmt_execute($transactions); // Execute Statement

                        $resultTrans = mysqli_stmt_get_result($transactions); // Get Statement Result

                        if (mysqli_num_rows($resultTrans) > 0) { // Compare Result Mass

                            $foundTransc = true; // Update Flag

                            $data = mysqli_fetch_all($resultTrans, MYSQLI_ASSOC);

                        }

                        mysqli_free_result($resultTrans); // Free Result

                        mysqli_stmt_close($transactions); // Close Statement

                        if ($foundTransc) {

                            $i = 0;

                            foreach ($data as $row):

                                $i++;

                                $userClass = $row['user_type'];

                                $amount = $row['amount'];

                                $status = $row['status'];

                                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                $desc = $row['descr'];

                                $currency = $row['currency'];

                                $date = $row['date'];

                                $type = $row['type'];

                                $scope = $row['action'];

                                $account = $row['acc_num'];

                                $id = $row['trans_id'];

                                $user = $row['user_id'];

                                if ($type == "DEBIT") {

                                    $icon = "wallet-out";
                                    $color = "text-danger";
                                    $sign = "-";

                                } else {
                                    $icon = "wallet-in";
                                    $color = "text-success";
                                    $sign = "+";
                                }
                                    if ($status == 'COMPLETED') {

                                        $status = '<span class="text-success">' . $status . '</span>';

                                    } else if ($status == 'PROCESSING') {

                                        $status = '<span class="text-warning">PENDING</span>';

                                    } else {
                                        
                                        $status = '<span class="text-danger">' . $status . '</span>';
                                    
                                    }

                            ?>    

                                <tr class="nk-tb-item">
                            
                                    <td class="nk-tb-col tb-col-md">
                                        <span>
                                            <?= $i ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col">
                                        <div class="user-card">
                                            <div class="user-info">
                                                <span class="tb-lead">
                                                    <?= $id ?><span class="dot dot-success d-md-none ml-1"></span>
                                                </span>
                                                <span>
                                                    <?= date('l jS, F, Y (h:i A)', strtotime($date)) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                        <span class="tb-amount">
                                            <?= $name .' (' . $userClass . ')' ?>
                                        </span>
                                        <span>
                                            <?= $account ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                        <span class="tb-amount <?= $color ?>">
                                            <i class="ni ni-<?= $icon ?>"></si>
                                            <?= $sign . $currSymbol[$currency] .  number_format($amount, 2) ?><span class="currency">
                                                <?= $currency ?>
                                            </span>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <span>
                                            <?= $desc ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-lg" data-order="Email Verified">
                                        <ul class="list-status <?= $color ?>">
                                            <?= $type ?>
                                        </ul>
                                    </td>
                                    <td class="nk-tb-col tb-col-lg">
                                        <span>
                                            <?= $scope ?>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <?= $status ?>
                                    </td>
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <form method="post" class="transc-mgmt-form">
                                            <input type="hidden" name="transc-id" value="<?= $id ?>">
                                            <ul class="nk-tb-actions gx-1">
                                                <li class="nk-tb-action-hidden">
                                                    <a href="edit-transaction?id=<?= $id ?>"
                                                        class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                        title="Edit">
                                                        <em class="icon ni ni-edit"></em>
                                                    </a>
                                                </li>
                                                <li class="nk-tb-action-hidden">
                                                    <button type="submit" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Delete">
                                                        <em class="icon ni ni-trash text-danger"></em>
                                                    </button>
                                                </li>
                                                <?php
                                                
                                                    if ($userClass == 'USER') { ?>
                                                        
                                                        <li>
                                                            <div class="dropdown">
                                                                <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                    data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                                <div class="dropdown-menu dropdown-menu-right">
                                                                    <ul class="link-list-opt no-bdr">
                                                                        <li><a href="user-details?id=<?= $user ?>"><em class="icon ni ni-user"></em><span>View
                                                                                    User Detalis</span></a></li>

                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </li>

                                                    <?php }
                                                
                                                ?>
                                            </ul>
                                        </form>    
                                    </td>
                                </tr>

                            <?php endforeach;

                        }    
                        
                    ?>
                                
                </tbody>
            </table>
        </div>
    </div><!-- .card-preview -->


</div>



<?php

    require('utility/partials/footer.php');

?>