<?php

    require('utility/partials/header.php');
    
    // checkInstallUrl($site_url)

    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn);

        if (!$userData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error",

                }).then(() => {
                
                    window.history.go(-1);

                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
            
            swal({
            
                title: "Error!",

                text: "Invalid URL Credential!",

                icon: "error",

            }).then(() => {
            
                window.history.go(-1);

            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">User Accounts</span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                            <li><a href="billing-codes?id=<?= $id ?>" class="btn btn-dark"><span>See Billing Codes</span> <em
                                        class="icon ni ni-invest"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?= join (' ', [$userData['firstname'], $userData['lastname']]) ?> Accounts <?= '(' . accountCount($id, $conn) . ')' ?></h4>
                <div class="nk-block-des">
                    <p>Below is the list of Accounts</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col"><span class="sub-text">#</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Account ID</span></th>
                            <th class="nk-tb-col"><span class="sub-text">Account Number</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">Type</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Balance</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right"></th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $found = false; // Flag

                            // Fetch All User's Account
                        
                            $stmt = mysqli_prepare($conn, "SELECT * FROM `accounts` WHERE `user_id` = ? ORDER BY `class`, `id` DESC"); // Prepare Statement

                            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                                $found = true; // Update Flag

                                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Check Flag

                            if ($found) {

                                $i = 0; 

                                foreach ($data as $row): // Iterate Through Rows

                                    $i++;

                                    $accId = $row['acc_id'];

                                    $accNum = $row['acc_num'];

                                    $type = $row['type'];

                                    $class = $row['class'];

                                    $balance = $row['balance'];

                                    $currency = $row['currency'];

                                    $symbol = $currSymbol[$currency];

                                ?>    

                                    <tr class="nk-tb-item">
                                        <td class="nk-tb-col tb-col-md">
                                            <span><?= $i ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $accId ?></span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $accNum ?></span>
                                        </td>
                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= $type ?>
                                                    </span>
                                                    <span>
                                                        <?= $class ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <td class="nk-tb-col tb-col-md">
                                            <span class="tb-lead"><?= $symbol . number_format($balance, 2) ?></span>
                                            <span><?= $currency ?></span>
                                        </td>
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form class="acc-mgmt-form" method="post">
                                                <input type="hidden" name="account-id" value="<?= $accId ?>">
                                                <input type="hidden" name="user-id" value="<?= $id ?>">
                                                <ul class="nk-tb-actions gx-1">
                                                    <?php

                                                        if ($class != 'PRIMARY') { ?>

                                                            <li class="nk-tb-action-hidden">
                                                                <button type="submit" name="primary-account" value="PRIMARY" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Make Primary Account">
                                                                    <em class="icon ni ni-star-fill text-warning"></em>
                                                                </button>
                                                            </li>

                                                        <?php }

                                                    ?>
                                                    <li class="nk-tb-action-hidden">
                                                        <a href="edit-account?id=<?= $accId ?>&user-id=<?= $id ?>" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Edit Account">
                                                            <em class="icon ni ni-edit text-info"></em>
                                                        </a>
                                                    </li>
                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" name="reset-account" value="RESET" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Reset Account Balance">
                                                            <em class="icon ni ni-reload text-warning"></em>
                                                        </button>
                                                    </li>

                                                    <li>
                                                        <div class="dropdown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <li><button class="btn w-100" type="submit" name="delete-account" value="DELETE"><em
                                                                                class="icon ni ni-trash text-danger"></em><span>Delete</span></button>
                                                                    </li>

                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>

                                                </ul>
                                            </form>    
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-sign-dollar"></em> Create an Account</h5>
        </div>
        <form id="add-acc-Form" method="post">
            <div class="card-body">
                <b>Account Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label class="form-label" for="currency">Currency</label>
                            <select class="form-control" name="currency">
                                <?php
                                
                                    $currencies = []; // Store User Currencies

                                    $requests = []; // Store Currenncy Requests

                                    $stmt = mysqli_prepare($conn, "SELECT `A`.`currency` AS `currencies`, `B`.`identifier` AS `requests` FROM `accounts` AS `A` LEFT JOIN `requests` AS `B` ON `A`.`user_id` = `B`.`user_id` AND `B`.`type` = ? WHERE `A`.`user_id` = ? ORDER BY `A`.`currency`, `B`.`identifier` DESC");

                                    $type = 'ACCOUNT';

                                    mysqli_stmt_bind_param($stmt, "ss", $type, $id); // Bind Parameter(s)

                                    mysqli_stmt_execute($stmt); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                                    if (mysqli_num_rows($result) > 0) {

                                        while ($row = mysqli_fetch_assoc($result)) {

                                            $currencies[] = $row['currencies'];

                                            $requests[] = $row['requests'];

                                        }

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt); // Close Statement

                                    // Merge currencies and requests arrays to exclude both from $currCodeNames
                                    $excludeCurrencies = array_merge($currencies, $requests);

                                    // Filter out NULL or invalid values (non-scalar values) from $excludeCurrencies
                                    $excludeCurrencies = array_filter($excludeCurrencies, function($value) {
                                        return is_scalar($value); // Keep only scalar values (strings or integers)
                                    });

                                    // Filter out the user's currencies and requests from the $currCodeNames array
                                    $filter = array_diff_key($currCodeNames, array_flip($excludeCurrencies));
                                
                                    foreach ($filter as $code => $name): // Get Remaining Currencies ?>

                                        <option value="<?= $code ?>"><?= $code . '(' . $name . ')' ?></option>

                                    <?php endforeach;

                                ?>
                            </select>
                                <input type="hidden" class="form-control" id="user-id" name="user-id"
                                value="<?= isset($id) ? $id : '' ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="account-type">Account Type</label>
                            <select type="text" class="form-control" name="account-type">

                                <option value="CHECKING">Checking Account</option>
                                <option value="SAVINGS">Saving Account</option>
                                <option value="FIXED DEPOSIT">Fixed Deposit Account</option>
                                <option value="CURRENT">Current Account</option>
                                <option value="JOINT">Joint Account</option>
                                
                                <option value="NON RESIDENT">Non Resident Account</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="balance">Balance</label>
                            <input type="number" class="form-control" name="balance" step="0.01" min="0">
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button id="add-acc" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>