<?php

  require('utility/partials/header.php');

  if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

    $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

    $userData = userData($id, $conn); //  Get Plan Data

    if (!$userData) {

      echo '<script>
      
        swal({
        
            title: "Error!",

            text: "User not found!",

            icon: "error"

        }).then(() => {
        
            window.history.go(-1);
        
        });
      
      </script>';

      exit;

    }

  } else {

    echo '<script>

      swal({

        title: "Error!",

        text: "Invalid URL Parameter",

        icon: "error"

      }).then(() => {

        window.history.go(-1);

      });

    </script>';

    exit;

  } 

?>

<div class="nk-content">
  <div class="container-xl wide-lg">
    <div class="nk-content-body">
      <div class="nk-block-head">
        <div class="nk-block-head-sub">
        </div>
        <div class="nk-block-between-md g-4 card-bordered">
          <div class="nk-block-head-content">
            <h4 class="nk-block-title fw-normal">Log in activites (<?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?>)
            </h4>
            <div class="nk-block-des">
              <p>
              </p>
            </div>
          </div>
          <div class="nk-block-head-content">
            <ul class="nk-block-tools gx-3">
              <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em
                    class="icon ni ni-arrow-left"></em></a></li>
              <li>
                <li><a onclick="return(confirm('Delete User Activity Logs?'))" href="delete-user-logs?id=<?= $id ?>" class="btn btn-danger"><span>Clear Activity Log</span> <em class="icon ni ni-trash"></em></a></li>
              </li>
            </ul>
          </div><!-- .nk-block-head-content -->
        </div><!-- .nk-block-between -->
      </div><!-- .nk-block-head -->
    </div>
  </div>
  <div class="card card-preview ">
    <div class="card-inner p-0">
      <table class="datatable-init table">
        <thead>
          <tr>
            <th>Date</th>
            <th>IP</th>
            <th>Device</th>
            <th>Browser</th>
            <th>Location</th>
            <th>Status</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>

          <?php

            $found = false; // Flag
          
            $stmt = mysqli_prepare($conn, "SELECT * FROM `activity_logs` WHERE `user_id` = ? ORDER BY `id` DESC"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameters

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

            if (mysqli_num_rows($result) > 0) { // Compare Result Mass

              $found = true; // Update Flag

              $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get All Rows

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($stmt); // Close Statement

            if ($found) { // Check Flag

              foreach($data as $row):

                $rowId = $row['id'];

                $date = $row['logged_in'];

                $ip = $row['ip_address'] ?? 'UNKNOWN';

                $device = $row['device'] ?? 'UNKNOWN';

                $browser = $row['browser'] ?? 'UNKNOWN';

                $location = $row['location'] ?? 'UNKNOWN';

                $status = $row['status'] ?? 'UNCERTAIN'; ?>

                <tr>

                  <td><?= date('l d M, Y (H:i)', strtotime($date)) ?></td>

                  <td><?= $ip ?></td>

                  <td><?= $device ?></td>

                  <td><?= $browser ?></td>

                  <td><?= $location ?></td>

                  <td><p><?= $status ?></p></td>

                  <td>
                    <form method="post" class="log-mgmt-form">
                      <input type="hidden" name="log-id" value="<?= $rowId ?>">
                      <button class="btn btn-sm text-danger bg-white" type="submit"><em class="icon ni ni-trash"></em> Delete</button>
                    </form>
                  </td>

                </tr>

              <?php endforeach;

            }
          
          ?>
        
        </tbody>
      </table>
    </div>
  </div>

  <?php

  require('utility/partials/footer.php');

?>