<?php

    require('utility/partials/header.php');
    
    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn);

        if (!$userData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

        $accounts = userAccounts($id, $conn); // Get User Accounts

        if (!$accounts) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User account(s) not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid Data",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal"><?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?> <i>Virtual Cards</i></span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?= join (' ', [$userData['firstname'], $userData['lastname']]) ?> Virtual Cards <?= '(' . vCardCount($id, $conn) . ')' ?></h4>
                <div class="nk-block-des">
                    <p>Below is the list of Virtual Cards</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">
                        <!-- <th class="nk-tb-col nk-tb-col-check">
                            <div class="custom-control custom-control-sm custom-checkbox notext">
                                <input type="checkbox" class="custom-control-input" id="uid">
                                <label class="custom-control-label" for="uid"></label>
                            </div>
                        </th> -->

                        <th class="nk-tb-col">#</th>

                        <th class="nk-tb-col"><span class="sub-text">User</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Type</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Balance</span></th>
                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">Card Details</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Action</span></th>
                    </tr>
                </thead>
                <tbody>

                    <?php
                    
                        // Get Virtual Cards

                        $cardFound = false; // Flag

                        $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`fname`, `B`.`mname`, `B`.`lname`, `B`.`email` FROM `virtual_cards` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` WHERE `A`.`user_id` = ? ORDER BY `A`.`id` DESC"); // Prepare Statement

                        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

                        mysqli_stmt_execute($stmt); // Execute Statement

                        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

                            $cardFound = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Fetch All Data

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($stmt); // Close Statement

                        // Check Flag

                        if ($cardFound) {

                            // Iterate Through Records

                            $i = 0; // Intiate Counter

                            foreach ($data as $row):

                                $i++; // Increment Counter

                                $card = $row['card_id'];

                                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                                $email = $row['email'];

                                $number = $row['card_number'];

                                $cvv = $row['cvv'];

                                $expires = date('m/y', strtotime($row['expires']));

                                $provider = $row['provider']; 
                                
                                $currency = $row['currency'];

                                $symbol = $currSymbol[$currency];

                                $balance = $row['balance'] ?? 0;

                                $status = $row['status'];
                                
                                if ($status == 'ACTIVE') {

                                    $status = '<span class="text-success">' . $status . '</span>';

                                } else if ($status == 'EXPIRED') {

                                    $status = '<span class="text-danger">' . $status . '</span>';

                                } else {

                                    $status = '<span class="text-warning">' . $status . '</span>';

                                }

                                ?>

                                <tr class="nk-tb-item">
                                    <td class="nk-tb-col">
                                        <span><?= $i ?></span>
                                    </td>
                                    <td class="nk-tb-col">
                                        <div class="user-card">
                                            <div class="user-info">
                                                <span class="tb-lead">
                                                    <?= $name ?>
                                                </span>
                                                <span>
                                                    <?= $email ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                        <span class="tb-amount">
                                            <?= $provider ?>
                                        </span>
                                        <span><?= substr($number, 0, 3) . '*****' ?></span>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                        <span class="tb-amount">
                                            <?= $symbol . number_format($balance, 2) ?><span class="currency">
                                            <?= $currency ?>
                                            </span>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-md">
                                        <span class="tb-lead">
                                            <?= substr($number, 0, 5) .'*****' ?>
                                        </span>
                                        <span><?= $cvv ?></span>
                                        <span>
                                            <?= $expires ?>
                                        </span><br>
                                    </td>

                                    <td class="nk-tb-col tb-col-md">
                                        <?= $status ?>
                                    </td>
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <form method="post" class="vCard_form">

                                            <input type="hidden" name="card-id" value="<?= $card ?>">

                                            <ul class="nk-tb-actions gx-1">

                                                <li class="nk-tb-action-hidden">

                                                    <a href="card-balance?id=<?= $card ?>" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="Edit Balance">
                                                        <em class="icon ni ni-sign-dollar text-primary"></em>
                                                    </a>

                                                </li>

                                                <?php
                                                
                                                    if ($row['status'] != 'EXPIRED') { ?>

                                                        <li class="nk-tb-action-hidden">

                                                        <button type="submit" name="change-status" value="<?= ($row['status'] == 'ACTIVE') ? 'DEACTIVATE' : 'ACTIVATE' ?>" class="btn btn-trigger btn-icon"
                                                            data-toggle="tooltip" data-placement="top" title="<?= ($row['status'] == 'ACTIVE') ? 'Deactivate ' : 'Activate ' ?>Card">
                                                            <em class="icon ni ni-shield-star text-<?= ($row['status'] == 'ACTIVE') ? 'danger' : 'success' ?>"></em>
                                                        </button>

                                                        </li>

                                                    <?php } 

                                                ?>
                                                
                                                <li class="nk-tb-action-hidden">

                                                    <button type="submit" name="delete" value="DELETE" class="btn btn-trigger btn-icon"
                                                        data-toggle="tooltip" data-placement="top" title="Delete Card">
                                                        <em class="icon ni ni-trash text-danger"></em>
                                                    </button>

                                                </li>

                                                <li>

                                                    <div class="drodown">
                                                        <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                            data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                        <div class="dropdown-menu dropdown-menu-right">
                                                            <ul class="link-list-opt no-bdr">
                                                            <a href="card-details?id=<?= $card ?>">
                                                                <em class="icon ni ni-edit text-danger"></em><span>Edit Card</span>
                                                            </a>



                                                            </ul>
                                                        </div>
                                                    </div>

                                                </li>

                                            </ul>

                                        </form>    


                                    </td>
                                </tr>

                            <?php endforeach;

                        }

                    ?>

                </tbody>
            </table>
        </div>
    </div><!-- .card-preview -->
    </div> <!-- nk-block -->

    <div class="card card-bordered s-4 col-lg-12 p-0">
        <div class="card-header font-weight-bold text-light" style="background-color:#033d75;">
            <h5 class="text-white"><em class="icon ni ni-cc-alt2-fill"></em> Create Virtual Card</h5>
        </div>
        <form id="cardForm" method="post">
            <div class="card-body">
                <b>Virtual Card Details</b>
                <hr>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <input type="hidden" name="user" value="<?= isset($id) ? $id : '' ?>">
                            <label class="form-label" for="card-provider">Provider</label>
                            <select class="form-control" id="card-provider" name="card-provider"
                                required>
                            
                                <option value="AMEX">AMEX</option>

                                <option value="MASTERCARD">MasterCard</option>

                                <option value="VISA">VISA</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="card-expires">Valid Till (End of the Month)</label>
                            <input type="date" class="form-control" id="code-abbr" name="card-expires">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="card-fund">Fund Card</label>
                            <select class="form-control" id="card-fund" name="card-fund"
                                required>
                            
                                <option value="BOTH">All Sources</option>

                                <option value="BALANCE">From Account Balance</option>

                                <option value="PAY">From Deposit</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="card-currency">Currency/Account</label>
                            <select class="form-control" name="card-currency">

                                <?php
                                
                                    foreach ($accounts as $acc): // Display User Account(s)
                                    
                                        $currency = $acc['currency'];

                                        $number = $acc['acc_num'];

                                    ?>

                                        <option value="<?= $currency ?>"><?= $currency . ' ' . substr($number, 0, 4) . str_repeat('*', strlen($number - 5)) ?></option>

                                    <?php endforeach;
                                
                                ?>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="card-balance">Balance</label>
                            <input class="form-control" type="number" name="card-balance" min="0" step="0.01">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label" for="card-color">Color</label>
                            <input type="color" class="form-control" id="card-color" name="card-color">
                            <div class="custom-control custom-control-sm custom-checkbox"><input type="checkbox" class="custom-control-input" id="radomize-color" name="radomize-color" checked><label class="custom-control-label" for="radomize-color">Use Random Color</label></div>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="card-footer">
                <button id="addCard" onclick="return confirm('Have you confirmed the data?')" type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>