<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn); // Fetch User Data 

    }
    
    // if($email_verify != 0){
    //     $emailVerify = '<li><em class="icon text-success ni ni-check-circle"></em> <span>Email</span></li>';
    // }else{$emailVerify = '  <li><em class="icon text-danger ni ni-alert-circle"></em> <span>Email</span></li>';}

    // if($userdetails['status'] == 'pending'){
    //     $suspend = ' <li><a class="" href="unblock?id='.$userid.'"><em class="icon ni ni-user-fill-c"></em><span>Unblock account</span></a></li>';
    //     $stat = '<span class="tb-status text-danger">Suspended</span>';
    // }else {$stat = '<span class="tb-status text-success">Active</span>';
    //     $suspend = ' <li><a class="" href="suspend?id='.$userid.'"><em class="icon ni ni-user-fill-c"></em><span>Suspend account</span></a></li>';
    // }

?>

<!-- content @s -->
<div class="nk-content nk-content-fluid">
    <div class="nk-block-head-content">
        <a onclick="window.history.go(-1)" class="btn btn-outline-light bg-white d-none d-sm-inline-flex"><em class="icon ni ni-arrow-left"></em><span>Back</span></a>
        <a onclick="window.history.go(-1)" class="btn btn-icon btn-outline-light bg-white d-inline-flex d-sm-none"><em class="icon ni ni-arrow-left"></em></a>
    </div>
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block">
                <div class="card card-bordered">
                    <div class="card-aside-wrap">
                        <div class="card-inner card-inner-lg">
                            <div class="nk-block-head nk-block-head-lg">
                                <div class="nk-block-between">
                                    <div class="nk-block-head-content">
                                        <h4 class="nk-block-title">Personal Information</h4>
                                        <div class="nk-block-des">
                                            <p>Basic info, like name, address etc.</p>
                                        </div>
                                    </div>
                                    <div class="nk-block-head-content align-self-start d-lg-none">
                                        <a href="#" class="toggle btn btn-icon btn-trigger mt-n1"
                                            data-target="userAside"><em class="icon ni ni-menu-alt-r"></em></a>
                                    </div>
                                </div>
                            </div><!-- .nk-block-head -->
                            <div class="nk-block">
                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Basics</h6>
                                    </div>
                                    <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                        <div class="data-col">
                                            <span class="data-label">Full Name</span>
                                            <span class="data-value">
                                                <?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more"><em
                                                    class="icon ni ni-forward-ios"></em></span></div>
                                    </div><!-- data-item -->
                                    <div class="data-item">
                                        <div class="data-col">
                                            <span class="data-label">Email</span>
                                            <span class="data-value">
                                                <?= $userData['email'] ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more disable"><em
                                                    class="icon ni ni-lock-alt"></em></span></div>
                                    </div><!-- data-item -->
                                    <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                        <div class="data-col">
                                            <span class="data-label">Password</span>
                                            <span class="data-value">
                                                <?= substr($userData['raw-key'], 0, 2) . '****' . substr($userData['raw-key'], -2) ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more"><em
                                                    class="icon ni ni-forward-ios"></em></span></div>
                                    </div><!-- data-item -->
                                    <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                        <div class="data-col">
                                            <span class="data-label">Phone Number</span>
                                            <span class="data-value text-soft">
                                                <?= $userData['phone'] ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more"><em
                                                    class="icon ni ni-forward-ios"></em></span></div>
                                    </div><!-- data-item -->
                                    <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                        <div class="data-col">
                                            <span class="data-label">Date of Birth</span>
                                            <span class="data-value">
                                                <?= $userData['dob'] ? date('l, M d, Y', strtotime($userData['dob'])) : '-' ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more"><em
                                                    class="icon ni ni-forward-ios"></em></span></div>
                                    </div><!-- data-item -->
                                    <div class="data-item" data-toggle="modal" data-target="#profile-edit">
                                        <div class="data-col">
                                            <span class="data-label">Account Status</span>
                                            <span class="data-value">
                                                <?= $userData['account-status'] ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more"><em
                                                    class="icon ni ni-forward-ios"></em></span></div>
                                    </div><!-- data-item -->
                                    <div class="data-item" data-toggle="modal" data-target="#profile-edit"
                                        data-tab-target="#address">
                                        <div class="data-col">
                                            <span class="data-label">Registration Status</span>
                                            <span class="data-value">
                                                <?= $userData['reg-status'] ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more"><em
                                                    class="icon ni ni-forward-ios"></em></span></div>
                                    </div><!-- data-item -->
                                    <div class="data-item" data-toggle="modal" data-target="#profile-edit"
                                        data-tab-target="#address">
                                        <div class="data-col">
                                            <span class="data-label">Transfers / Withdrawals</span>
                                            <span class="data-value">
                                                <?= $userData['transfer-status'] ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more"><em
                                                    class="icon ni ni-forward-ios"></em></span></div>
                                    </div><!-- data-item -->
                                    <div class="data-item" data-toggle="modal" data-target="#profile-edit"
                                        data-tab-target="#address">
                                        <div class="data-col">
                                            <span class="data-label">Billing Codes</span>
                                            <span class="data-value">
                                                <?= $userData['bcode-status'] ?>
                                            </span>
                                        </div>
                                        <div class="data-col data-col-end"><span class="data-more"><em
                                                    class="icon ni ni-forward-ios"></em></span></div>
                                    </div><!-- data-item -->
                                </div><!-- data-list -->
                                <div class="nk-data data-list">
                                    <div class="data-head">
                                        <h6 class="overline-title">Preferences & KYC</h6>
                                    </div>
                                    <div class="data-item">
                                        <div class="data-col">
                                            <span class="data-label">2FA Auth</span>
                                            <span class="data-value"><?= $userData['auth'] ?></span>
                                        </div>
                                        <div class="data-col data-col-end"><a href="#" data-toggle="modal"
                                                data-target="#profile-edit" class="link link-primary">Change
                                                </a></div>
                                    </div><!-- data-item -->
                                    <div class="data-item">
                                        <div class="data-col">
                                            <span class="data-label">Login Alerts</span>
                                            <span class="data-value"><?= $userData['login-alerts'] ?></span>
                                        </div>
                                        <div class="data-col data-col-end"><a href="#" data-toggle="modal"
                                                data-target="#profile-edit" class="link link-primary">Change</a>
                                        </div>
                                    </div><!-- data-item -->
                                    <div class="data-item">
                                        <div class="data-col">
                                            <span class="data-label">KYC Verification</span>
                                            <span class="data-value">
                                                <?= $userData['kyc-status'] ? $userData['kyc-status'] : 'UNVERIFIED' ?>
                                                <?= ($userData['kyc-bypass'] == 'ON') ? '<br>(KYC BYPASS ACTIVE)' : null ?>
                                            </span>
                                        </div>
                                        <?php

                                            if (!is_null($userData['kyc-real'])) { ?>

                                                <div class="data-col data-col-end">
                                                    <a href="user-kyc?id=<?= $id ?>" class="link link-primary">View</a>
                                                </div>

                                            <?php }    

                                        ?>
                                    </div><!-- data-item -->
                                </div><!-- data-list -->
                            </div><!-- .nk-block -->
                        </div>
                        <div class="card-aside card-aside-left user-aside toggle-slide toggle-slide-left toggle-break-lg"
                            data-content="userAside" data-toggle-screen="lg" data-toggle-overlay="true">
                            <div class="card-inner-group" data-simplebar>
                                <div class="card-inner">
                                    <div class="user-card">
                                        <div class="user-avatar bg-primary">

                                            <?= $userData['profile-image'] ? '<img src="'. SITE_BASE_URL . '/' . htmlspecialchars(str_replace('../', '', $userData['profile-image'])) . '" alt="">' : '<span>' . strtoupper($userData['firstname'][0] . $userData['lastname'][0]) . '</span>' ?>
                                            
                                        </div>
                                        <div class="user-info">
                                            <span class="lead-text">
                                                <?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?>
                                            </span>

                                            <span class="sub-text">
                                                <?= $userData['email'] ?>
                                            </span>
                                        </div>
                                        <div class="user-action">
                                            <div class="dropdown">
                                                <a class="btn btn-icon btn-trigger mr-n2" data-toggle="dropdown"
                                                    href="#"><em class="icon ni ni-more-v"></em></a>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    <ul class="link-list-opt no-bdr">
                                                        <li>
                                                            <a data-toggle="modal" data-target="#edit-pfp">
                                                                <em class="icon ni ni-camera-fill"></em>
                                                                <span>Change Photo</span>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="user-notifications?id=<?= $id ?>">
                                                                <em class="icon ni ni-bell-fill"></em>
                                                                <span>Notifications</span>
                                                            </a>
                                                        </li>

                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- .user-card -->
                                </div><!-- .card-inner -->
                                <div class="card-inner">
                                    <div class="user-account-info py-0">
                                        <h6 class="overline-title-alt">
                                            <?= $userData['reg-date'] ? 'Joined:' . date('l, M d, Y', strtotime($userData['reg-date'])) : '' ?>
                                        </h6>
                                        <div class="user-balance">Accounts:
                                            <small class="currency currency-btc">
                                                <?= accountCount($id, $conn) ?>
                                            </small>
                                        </div>
                                        <span class="lead-text">Total Billing Codes:
                                            <?= bcodeCount($id, $conn) ?>
                                        </span>
                                    </div>
                                </div><!-- .card-inner -->
                                <div class="card-inner p-0">
                                    <ul class="link-list-menu">
                                        <li><a class="active" href="#"><em
                                                    class="icon ni ni-user-fill-c"></em><span>Personal
                                                    Infomation</span></a></li>
                                        <li><a href="user-accounts?id=<?= $id ?>"><em
                                        class="icon ni ni-sign-dollar"></em><span>Accounts (<?= accountCount($id, $conn) ?>)</span></a></li>
                                        <?php
                                        
                                            if (jointAccounts($id, $conn)) { ?>

                                                <li><a href="joint-users?id=<?= $id ?>">
                                                    <em class="icon ni ni-users"></em><span>Joint Users (<?= thirdPartyCount($id, $conn) ?>)</span>
                                                </a></li>

                                            <?php }
                                        
                                        ?>
                                        <li><a href="billing-codes?id=<?= $id ?>"><em
                                        class="icon ni ni-lock-alt-fill"></em><span>Billing Codes (<?= bcodeCount($id, $conn) ?>)</span></a></li>
                                        <li><a href="user-cards?id=<?= $id ?>"><em
                                        class="icon ni ni-cc-alt-fill"></em><span>Virtual Cards (<?= vCardCount($id, $conn) ?>)</span></a></li>
                                        <li>
                                            <a href="user-invoices?id=<?= $id ?>"><em class="icon ni ni-files"></em><span>Invoices (<?= invoiceCount($id, $conn) ?>)</span></a>
                                        </li>
                                        <li>
                                            <a href="user-investments?id=<?= $id ?>"><em class="icon ni ni-invest"></em><span>Investments (<?= subsCount($id, $conn) ?>)</span></a>
                                        </li>
                                        <li>
                                            <a href="user-loans?id=<?= $id ?>"><em class="icon ni ni-coin"></em><span>Loans (<?= loanCount($id, $conn) ?>)</span></a>
                                        </li>
                                        <li><a href="fund-user?id=<?= $id ?>"><em
                                                    class="icon ni ni-wallet-in"></em><span>Credit Account</span></a>
                                        </li>
                                        <li><a href="user-transactions?id=<?= $id ?>"><em class="icon ni ni-tranx"></em><span>Transaction History</span></a>
                                        </li>

                                        <li><a href="debit-user?id=<?= $id ?>"><em
                                                    class="icon ni ni-wallet-out"></em><span>Debit Account</span></a>
                                        </li>

                                        <li><a href="withdrawal-settings?id=<?= $id ?>"><em
                                                    class="icon ni ni-activity-round-fill"></em><span>Withdrawal Settings</span></a></li>

                                        <li><a href="user-activity?id=<?= $id ?>"><em
                                                    class="icon ni ni-activity-round-fill"></em><span>Account
                                                    Activity</span></a></li>
                                        <li><a href="password-reset?id=<?= $id ?>"><em
                                                    class="icon ni ni-lock-alt-fill"></em><span>Security
                                                    Settings</span></a></li>
                                    </ul>
                                </div><!-- .card-inner -->
                            </div><!-- .card-inner-group -->
                        </div><!-- card-aside -->
                    </div><!-- .card-aside-wrap -->
                </div><!-- .card -->
            </div><!-- .nk-block -->
        </div>
    </div>


    <!--MODAL: User Details  -->

    <div class="modal fade" tabindex="-1" role="dialog" id="profile-edit">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <a href="#" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                <div class="modal-body modal-body-lg">
                    <h5 class="title">Update User Details</h5>
                    <ul class="nk-nav nav nav-tabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#personal">Personal</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#banking">Banking</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#security">Security</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#misc">Misc.</a>
                        </li>
                    </ul><!-- .nav-tabs -->
                    <div class="tab-content">
                        <div class="tab-pane active" id="personal">
                            <form method="post" id="form-user-details">
                                <div class="row gy-4">
                                    <input type="hidden" name="user-id" value="<?= $id ?>">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="firstname">First Name</label>
                                            <input type="text" class="form-control form-control-lg"
                                                value="<?= $userData['firstname'] ?>" placeholder="Enter Firstname"
                                                name="firstname" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="middlename">Middle Name</label>
                                            <input type="text" name="middlename"
                                                class="form-control form-control-lg" value="<?= $userData['middlename'] ?>"
                                                placeholder="Enter Middlename">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="lastname">Last Name</label>
                                            <input type="text" name="lastname"
                                                class="form-control form-control-lg" value="<?= $userData['lastname'] ?>"
                                                placeholder="Enter Lastname" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="phone">Phone Number</label>
                                            <input type="tel" class="form-control form-control-lg" name="phone"
                                                value="<?= $userData['phone'] ?>" placeholder="Phone Number" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="email">Email address</label>
                                            <input type="email" class="form-control form-control-lg" name="email"
                                                value="<?= $userData['email'] ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="password">Password</label>
                                            <input type="text" class="form-control form-control-lg" name="password"
                                                value="<?= $userData['raw-key'] ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="dob">Date of Birth</label>
                                            <input type="date" class="form-control form-control-lg"
                                                value="<?= $userData['dob'] ?>" name="dob" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="citizen">Nationality</label>
                                            <input type="text" class="form-control form-control-lg" name="citizen" value="<?= $userData['citizen'] ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <p>Address Details</p>
                                        <hr>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="zip">ZIP code</label>
                                            <input type="text" class="form-control form-control-lg" name="zip"
                                                value="<?= $userData['zip'] ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="street">Street Address</label>
                                            <input type="text" class="form-control form-control-lg" name="street"
                                                value="<?= $userData['street'] ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="city">City</label>
                                            <input type="text" class="form-control form-control-lg" name="city"
                                                value="<?= $userData['city'] ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="state">State</label>
                                            <input type="text" class="form-control form-control-lg" name="state"
                                                value="<?= $userData['state'] ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="country">Country</label>
                                            <input type="text" class="form-control form-control-lg" name="country" value="<?= $userData['country'] ?>" required>
                                        </div>
                                    </div>
                            
                                    <div class="col-12">
                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                            <li>
                                                <button type="submit" class="btn btn-lg btn-primary" id="update-user-details">Update Profile</button>
                                            </li>
                                            <li>
                                                <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </form>
                        </div><!-- .tab-pane -->
                        <div class="tab-pane" id="banking">
                            <form method="post" id="form-banking-details">
                                <div class="row gy-4">
                                    <input type="hidden" name="user-id" value="<?= $id ?>">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="reg-date">Registered</label>
                                            <input type="date" class="form-control form-control-lg" name="reg-date" value="<?= $userData['reg-date'] ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="user-tag">Username</label>
                                            <input type="text" class="form-control form-control-lg" name="user-tag" minlength="3" value="<?= $userData['tag'] ?>">
                                        </div>
                                    </div>
                            
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="acc-status">Account Status</label>
                                            <select class="form-control form-control-lg" name="acc-status">

                                                <option value="ACTIVE"<?= $userData['account-status'] == 'ACTIVE' ? ' selected' : '' ?>>ACTIVE</option>

                                                <option value="BANNED"<?= $userData['account-status'] == 'BANNED' ? ' selected' : '' ?>>BANNED</option>

                                                <option value="BLOCKED"<?= $userData['account-status'] == 'BLOCKED' ? ' selected' : '' ?>>BLOCKED</option>

                                                <option value="INACTIVE"<?= $userData['account-status'] == 'INACTIVE' ? ' selected' : '' ?>>INACTIVE</option>

                                                <option value="SUSPENDED"<?= $userData['account-status'] == 'SUSPENDED' ? ' selected' : '' ?>>SUSPENDED</option>

                                                <option value="TRANSFER DISABLED"<?= $userData['account-status'] == 'TRANSFER DISABLED' ? ' selected' : '' ?>>TRANSFER DISABLED</option>
                                                
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="auth-factor">2FA Authentication</label>
                                            <select class="form-control form-control-lg" name="auth-factor">

                                                <option value="ENABLED"<?= $userData['auth'] == 'ENABLED' ? ' selected' : '' ?>>ENABLED</option>

                                                <option value="DISABLED"<?= $userData['auth'] == 'DISABLED' ? ' selected' : '' ?>>DISABLED</option>
                                                
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="bcode-status">Billing codes</label>
                                            <select class="form-control form-control-lg" name="bcode-status">

                                                <option value="INACTIVE"<?= $userData['bcode-status'] == 'INACTIVE' ? ' selected' : '' ?>>INACTIVE</option>

                                                <option value="ACTIVE"<?= $userData['bcode-status'] == 'ACTIVE' ? ' selected' : '' ?>>ACTIVE</option>
                                                
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="transfer-status">Transfer /  Withdraw</label>
                                            <select class="form-control form-control-lg" name="transfer-status">

                                                <option value="ACTIVE"<?= $userData['transfer-status'] == 'ACTIVE' ? ' selected' : '' ?>>ACTIVE</option>

                                                <option value="DISABLED"<?= $userData['transfer-status'] == 'DISABLED' ? ' selected' : '' ?>>DISABLED</option>
                                                
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="kyc-bypass">KYC Bypass*</label>
                                            <select class="form-control form-control-lg" name="kyc-bypass">

                                                <option value="ON"<?= $userData['kyc-bypass'] == 'ON' ? ' selected' : '' ?>>ACTIVE</option>

                                                <option value="OFF"<?= $userData['kyc-bypass'] == 'OFF' ? ' selected' : '' ?>>DISABLED</option>
                                                
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="login-alerts">Login Alerts</label>
                                            <select class="form-control form-control-lg" name="login-alerts">

                                                <option value="ENABLED"<?= $userData['login-alerts'] == 'ENABLED' ? ' selected' : '' ?>>ENABLED</option>

                                                <option value="DISABLED"<?= $userData['login-alerts'] == 'DISABLED' ? ' selected' : '' ?>>DISABLED</option>
                                                
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="transc-pin">Transaction PIN</label>
                                            <input type="text" minlength="6" maxlength="6" value="<?= $userData['trans-pin'] ?>" class="form-control form-control-lg" name="transc-pin" required>
                                        </div>    
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="invest-by">Invest Through</label>
                                            <select class="form-control form-control-lg" name="invest-by">
                                                <option value="PAY"<?= $userData['investment-channel'] === 'PAY' ? ' selected' : null ?>>Invest Through Payment Page</option>
                                                <option value="BALANCE"<?= $userData['investment-channel'] === 'BALANCE' ? ' selected' : null ?>>Invest Through Account Balance</option>
                                                <option value="BOTH"<?= $userData['investment-channel'] === 'BOTH' ? ' selected' : null ?>>Invest Through All Channels</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12">

                                        <i>* KYC Bypass Ignores the user's KYC. Sets it to VERIFIED irrespective of current KYC status.</i>

                                    </div>
                                 
                                    <div class="col-12">
                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                            <li>
                                                <button type="submit" id="update-banking-details" class="btn btn-lg btn-primary">Update</button>
                                            </li>
                                            <li>
                                                <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                            </li>
                                        </ul>
                                    </div>

                                </div>
                            </form>
                        </div><!-- .tab-pane -->
                        <div class="tab-pane" id="security">
                            <form method="post" id="form-security-details">
                                <div class="row gy-4">
                                    <input type="hidden" name="user-id" value="<?= $id ?>">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="sq-1">Secret Question 1</label>
                                            <select class="form-control form-control-lg" name="sq-1">

                                                <option value="<?= $userData['secret-question'] ?>"><?= $userData['secret-question'] ?></option>

                                                <option value="What is the name of your first pet?">What is the name of your first pet?</option>

                                                <option value="In what city were you born?">In what city were you born?</option>

                                                <option value="What is your mother's maiden name?">What is your mother's maiden name?</option>

                                                <option value="What was the name of your elementary school?">What was the name of your elementary school?</option>

                                                <option value="What was your childhood nickname?">What was your childhood nickname?</option>

                                                <option value="What was the street name you grew up on?">What was the street name you grew up on?</option>

                                                <option value="What was the make and model of your first car?">What was the make and model of your first car?</option>

                                                <option value="What is your father's middle name?">What is your father's middle name?</option>

                                                <option value="What is your oldest sibling’s middle name?">What is your oldest sibling’s middle name?</option>

                                                <option value="What is the name of the hospital where you were born?">What is the name of the hospital where you were born?</option>

                                                <option value="What was the name of your first teacher?">What was the name of your first teacher?</option>

                                                <option value="What was the name of your first school friend?">What was the name of your first school friend?</option>

                                                <option value="What was your first job title?">What was your first job title?</option>

                                                <option value="What company gave you your first paycheck?">What company gave you your first paycheck?</option>

                                                <option value="What was your dream job as a child?">What was your dream job as a child?</option>

                                                <option value="What was the first concert you attended?">What was the first concert you attended?</option>

                                                <option value="What was the first movie you saw in a theater?">What was the first movie you saw in a theater?</option>

                                                <option value="What was your first mobile phone brand?">What was your first mobile phone brand?</option>

                                                <option value="What was your first email address (without the domain)?">What was your first email address (without the domain)?</option>

                                                <option value="What was the name of your first boss?">What was the name of your first boss?</option>

                                            </select>
                                            <input type="hidden" name="id" value="<?= $id ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="answer-1">Answer 1</label>
                                            <input type="text" class="form-control form-control-lg" name="answer-1" value="<?= $userData['answer-1'] ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="sq-2">Secret Question 2</label>
                                            <select class="form-control form-control-lg" name="sq-2">

                                                <option value="<?= $userData['secret-questionB'] ?>"><?= $userData['secret-questionB'] ?></option>

                                                <option value="What is your favorite movie of all time?">What is your favorite movie of all time?</option>

                                                <option value="What was your favorite subject in school?">What was your favorite subject in school?</option>

                                                <option value="What is your favorite sports team?">What is your favorite sports team?</option>

                                                <option value="What is your favorite book?">What is your favorite book?</option>

                                                <option value="What is your favorite childhood TV show?">What is your favorite childhood TV show?</option>

                                                <option value="Where did you go on your first flight?">Where did you go on your first flight?</option>

                                                <option value="What is the name of the first beach you visited?">What is the name of the first beach you visited?</option>

                                                <option value="What city did you visit on your first vacation?">What city did you visit on your first vacation?</option>

                                                <option value="What is the name of your favorite restaurant in your hometown?">What is the name of your favorite restaurant in your hometown?</option>

                                                <option value="Where did you celebrate your last birthday?">Where did you celebrate your last birthday?</option>

                                                <option value="What was the name of your childhood best friend?">What was the name of your childhood best friend?</option>

                                                <option value="What was your favorite toy as a child?">What was your favorite toy as a child?</option>

                                                <option value="What game did you play most as a child?">What game did you play most as a child?</option>

                                                <option value="What did you want to be when you grew up?">What did you want to be when you grew up?</option>

                                                <option value="What was the color of your childhood bedroom?">What was the color of your childhood bedroom?</option>

                                                <option value="What was the name of the town your grandparents lived in?">What was the name of the town your grandparents lived in?</option>

                                                <option value="What was the name of your first roommate?">What was the name of your first roommate?</option>

                                                <option value="What is the name of a place you’ve always wanted to visit?">What is the name of a place you’ve always wanted to visit?</option>

                                                <option value="What was the first foreign country you visited?">What was the first foreign country you visited?</option>

                                                <option value="What is the name of your favorite vacation spot?">What is the name of your favorite vacation spot?</option>

                                                <option value="What is the name of your first boyfriend/girlfriend?">What is the name of your first boyfriend/girlfriend?</option>

                                                <option value="What was the name of your first crush?">What was the name of your first crush?</option>

                                                <option value="What is your best friend’s nickname?">What is your best friend’s nickname?</option>

                                                <option value="Where did you meet your significant other?">Where did you meet your significant other?</option>

                                                <option value="What is the anniversary month of your parents?">What is the anniversary month of your parents?</option>

                                                <option value="What is your favorite meal your mom/dad used to cook?">What is your favorite meal your mom/dad used to cook?</option>

                                                <option value="What is your favorite dessert?">What is your favorite dessert?</option>

                                                <option value="What is your least favorite food?">What is your least favorite food?</option>

                                                <option value="What was your favorite food as a child?">What was your favorite food as a child?</option>

                                                <option value="What’s the name of your favorite hometown café or eatery?">What’s the name of your favorite hometown café or eatery?</option>

                                                <option value="In what city did you attend your first wedding?">In what city did you attend your first wedding?</option>

                                                <option value="Who was your childhood hero?">Who was your childhood hero?</option>

                                                <option value="What was your high school mascot?">What was your high school mascot?</option>

                                                <option value="What was the theme of your prom?">What was the theme of your prom?</option>

                                                <option value="What was your graduation year?">What was your graduation year?</option>

                                                <option value="What was the name of your imaginary friend?">What was the name of your imaginary friend?</option>

                                                <option value="What is the name of your favorite video game character?">What is the name of your favorite video game character?</option>

                                                <option value="What color was your first bicycle?">What color was your first bicycle?</option>

                                                <option value="What is your favorite board game?">What is your favorite board game?</option>

                                                <option value="What is a unique talent or hobby you had growing up?">What is a unique talent or hobby you had growing up?</option>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label" for="answer-2">Answer 2</label>
                                            <input type="text" class="form-control form-control-lg" name="answer-2" value="<?= $userData['answer-2'] ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                            <li>
                                                <button type="submit" id="update-security-details" class="btn btn-lg btn-primary">Update</button>
                                            </li>
                                            <li>
                                                <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                            </li>
                                        </ul>
                                    </div>

                                </div>
                            </form>
                        </div><!-- .tab-pane -->
                        <div class="tab-pane" id="misc">
                            <form method="post" id="form-misc-details">
                                <div class="row gy-4">
                                    <input type="hidden" name="user-id" value="<?= $id ?>">
                                    <div class="col-md-12">
                                        <p>NOK Details</p>
                                        <hr>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="nok-fname">Firstname</label>
                                            <input type="text" class="form-control form-control-lg" name="nok-fname" value="<?= $userData['nok-firstname'] ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="nok-mname">Middlename</label>
                                            <input type="text" class="form-control form-control-lg" name="nok-mname" value="<?= $userData['nok-middlename'] ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="nok-lname">Lastname</label>
                                            <input type="text" class="form-control form-control-lg" name="nok-lname" value="<?= $userData['nok-lastname'] ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="nok-dob">Date Of Birth</label>
                                            <input type="date" class="form-control form-control-lg" name="nok-dob" value="<?= $userData['nok-dob'] ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label" for="nok-rel">Relationship</label>
                                            <input type="text" class="form-control form-control-lg" name="nok-rel" value="<?= $userData['nok-rel'] ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label" for="nok-address">Address</label>
                                            <textarea rows="5" class="form-control form-control-lg" name="nok-address" required><?= $userData['nok-address'] ?></textarea>
                                        </div>
                                    </div>
                                 
                                    <div class="col-12">
                                        <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                                            <li>
                                                <button type="submit" id="update-misc-details" class="btn btn-lg btn-primary">Update</button>
                                            </li>
                                            <li>
                                                <a href="#" data-dismiss="modal" class="link link-light">Cancel</a>
                                            </li>
                                        </ul>
                                    </div>

                                </div>
                            </form>
                        </div><!-- .tab-pane -->
                    </div><!-- .tab-pane -->
                </div><!-- .modal-body -->
            </div><!-- .modal-content -->
        </div><!-- .modal-dialog -->
    
    </div><!-- .modal -->

    <!-- MODAL: Change Avatar -->

    <div class="modal fade" tabindex="-1" role="dialog" id="edit-pfp">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <a class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
                <div class="modal-body modal-body-lg">
                    <h5 class="title">Change User's Photo</h5>

                    <form method="post" id="update-pfp-form" enctype="multipart/form-data">

                        <div class="row gy-4">

                            <div class="col-12">

                                <div class="form-group">

                                    <?php

                                        $pfp = !is_null($userData['profile-image']) ? '../' . str_replace('../', '', $userData['profile-image']) : null;

                                        if ($pfp && is_file($pfp)) { ?>

                                            <div class="mx-auto my-3 d-flex align-center justify-center">
                                                <img src="<?= $pfp ?>" style="object-fit: contain;" width="300" height="300">
                                            </div>

                                        <?php }

                                    ?>

                                    <div class="form-control-wrap">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="new-pfp" accept="image/*" required>
                                            <label class="custom-file-label" for="new-pfp">Choose file</label>
                                        </div>
                                    </div>

                                    <input type="hidden" name="user" value="<?= isset($id) ? $id : null ?>">

                                    <input type="hidden" name="current-pfp" value="<?= $userData['profile-image'] ?>">

                                </div>

                            </div>

                            <div class="col-12">

                                <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">

                                    <li>
                                        
                                        <button type="submit" id="updatePfp" class="btn btn-lg btn-primary">Proceed</button>

                                    </li>

                                    <li>
                                        
                                        <button class="btn btn-lg btn-danger" data-dismiss="modal">Close</button>

                                    </li>

                                </ul>

                            </div>

                        </div>

                    </form>
                    
                </div><!-- .modal-body -->
            </div><!-- .modal-content -->
        </div><!-- .modal-dialog -->
    </div><!-- .modal -->


</div>

<?php

    require('utility/partials/footer.php');

?>