<?php

    require('utility/partials/header.php');
    
    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn);

        if (!$userData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

        // Get User Invoices

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`name`, B.`email` FROM `invoices` AS `A` JOIN `customers` AS `B` ON `A`.`customer_id` = `B`.`customer_id` WHERE `A`.`user_id` = ? ORDER BY `A`.`due` DESC"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s) 

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement


    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid Data",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal"><?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?> <i>Invoices</i></span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?= join (' ', [$userData['firstname'], $userData['lastname']]) ?> Invoices <?= '(' . invoiceCount($id, $conn) . ')' ?></h4>
                <div class="nk-block-des">
                    <p>Below is the list of Invoices</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">

                        <th class="nk-tb-col">#</th>

                        <th class="nk-tb-col"><span class="sub-text">Customer</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Invoice Number</span></th>
                        <th class="nk-tb-col"><span class="sub-text">Amount</span></th>
                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">Created / Due</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col nk-tb-col-tools"><span class="sub-text">Action</span></th>
                    </tr>
                </thead>
                <tbody>

                    <?php
                    
                        // Check Flag

                        if ($found) {

                            // Iterate Through Records

                            $i = 0; // Intiate Counter

                            foreach ($data as $row):

                                $i++; // Increment Counter

                                $num = $row['inv_num'];

                                $title = $row['title'];

                                $invID = $row['invoice_id'];

                                $currency = $row['currency'];

                                $symbol = $currSymbol[$currency];

                                $created = strtotime($row['created']);

                                $due = strtotime($row['due']);

                                $name = $row['name'];

                                $email = $row['email'];

                                $amount = $symbol . number_format($row['payable_amount'], 2);

                                $status = $row['status'];

                                if ($status == 'PAID') {

                                    $status = '<span class="text-success">' . $status . '</span>';

                                } else if ($status == 'UNPAID') {

                                    $status = '<span class="text-danger">' . $status . '</span>';

                                } else {

                                    $status = '<span class="text-warning">' . $status . '</span>';

                                }

                                ?>

                                <tr class="nk-tb-item">
                                    <td class="nk-tb-col">
                                        <span><?= $i ?></span>
                                    </td>
                                    <td class="nk-tb-col">
                                        <div class="user-card">
                                            <div class="user-info">
                                                <span class="tb-lead">
                                                    <?= $name ?>
                                                </span>
                                                <span>
                                                    <?= $email ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="nk-tb-col tb-col-md" data-order="35040.34">
                                        <span class="tb-amount">
                                            <?= $num ?>
                                        </span>
                                        <span><?= $title ?></span>
                                    </td>
                                    <td class="nk-tb-col" data-order="35040.34">
                                        <span class="tb-amount">
                                            <?= $amount ?><span class="currency">
                                            <?= $currency ?>
                                            </span>
                                        </span>
                                    </td>
                                    <td class="nk-tb-col tb-col-mb">
                                        <span class="tb-lead">
                                            <?= date('l M d, Y', $created) ?>
                                        </span>
                                        <span><?= date('l M d, Y', $due) ?></span>
                                    </td>

                                    <td class="nk-tb-col tb-col-md">
                                        <?= $status ?>
                                    </td>
                                    <td class="nk-tb-col nk-tb-col-tools">
                                        <form method="post" class="invoice-mgmt-form">

                                            <input type="hidden" name="inv-id" value="<?= $invID ?>">

                                            <ul class="nk-tb-actions gx-1">

                                                <li class="nk-tb-action-hidden">

                                                    <a href="<?= SITE_BASE_URL ?>/invoice/?accessKey=<?= urlencode(encrypt($invID)) ?>" target="_blank" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="View Invoice">
                                                        <em class="icon ni ni-eye text-primary"></em>
                                                    </a>

                                                </li>

                                                <li class="nk-tb-action-hidden">

                                                    <button type="submit" name="delete" value="DELETE" class="btn btn-trigger btn-icon"
                                                        data-toggle="tooltip" data-placement="top" title="Delete Invoice">
                                                        <em class="icon ni ni-trash text-danger"></em>
                                                    </button>

                                                </li>

                                            </ul>

                                        </form>    


                                    </td>
                                </tr>

                            <?php endforeach;

                        }

                    ?>

                </tbody>
            </table>
        </div>
    </div><!-- .card-preview -->
    </div> <!-- nk-block -->

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>