<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn); // Get User Data]

        if (!$userData) {

            echo '<script>
        
                swal({
                
                    title: "Attention!",

                    text: "Error! No data found.",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);

                });

            </script>';

            exit;

        }
    
    } else {

        echo '<script>

            swal({
                
                title: "Attention!",

                text: "Error! No data found.",

                icon: "error"

            }).then(() => {
            
                window.history.go(-1);

            });

        </script>';

        exit;

    }

?>

<!-- content @s -->
<div class="nk-content nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between g-3">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">KYC / <strong class="text-primary small">
                                <?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?>
                            </strong></h3>
                        <div class="nk-block-des text-soft">
                            <ul class="list-inline">
                                <li>ID: <span class="text-base">
                                        <?= $id ?>
                                    </span></li>
                                
                                <?php
                                
                                    if ($userData['reg-date'] != null) { ?>

                                        <li>Joined: <span class="text-base">
                                            <?= date('l d, m, Y', strtotime($userData['reg-date'])) ?>
                                        </span></li>

                                    <?php }

                                ?>    

                            </ul>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <a onclick="window.history.go(-1)"
                            class="btn btn-outline-light bg-white d-none d-sm-inline-flex"><em
                                class="icon ni ni-arrow-left"></em><span>Back</span></a>
                        <a onclick="window.history.go(-1)"
                            class="btn btn-icon btn-outline-light bg-white d-inline-flex d-sm-none"><em
                                class="icon ni ni-arrow-left"></em></a>
                    </div>
                </div>
            </div><!-- .nk-block-head -->
            <div class="nk-block">
                <div class="row gy-5">
                    <div class="col-lg-5">
                        <div class="nk-block-head">
                            <div class="nk-block-head-content">
                                <h5 class="nk-block-title title">Application Info</h5>
                                <p>KYC Status</p>
                            </div>
                        </div><!-- .nk-block-head -->
                        <div class="card card-bordered">
                            <ul class="data-list is-compact">
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Status</div>

                                        <?php
                                        
                                            if ($userData['kyc-status'] == 'VERIFIED') {

                                                echo '<div class="data-value"><span
                                                        class="badge badge-dim badge-sm badge-outline-success">VERIFIED</span>
                                                </div>';

                                            } else if ($userData['kyc-status'] == 'PROCESSING') {

                                                echo '<div class="data-value"><span
                                                        class="badge badge-dim badge-sm badge-outline-warning">PENDING</span>
                                                </div>';

                                            } else if ($userData['kyc-status'] == 'REJECTED') {

                                                echo '<div class="data-value"><span
                                                        class="badge badge-dim badge-sm badge-outline-danger">INVALID</span>
                                                </div>';

                                            } else {

                                                echo '<div class="data-value"><span
                                                        class="badge badge-dim badge-sm badge-outline-danger">UNVERIFIED</span>
                                                </div>';

                                            }
                                        
                                        ?>

                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Face ID</div>

                                        <?php
                                        
                                            if ($userData['face-id'] != null) {

                                                echo '<div class="data-value"><span
                                                        class="text-success">ENABLED</span>
                                                </div>';

                                            } else {

                                                echo '<div class="data-value"><span
                                                        class="text-danger">DISABLED</span>
                                                </div>';

                                            }
                                        
                                        ?>

                                    </div>
                                </li>

                            </ul>
                        </div><!-- .card -->
                        <div class="nk-block-head">
                            <div class="nk-block-head-content">
                                <h5 class="nk-block-title title">Uploaded Document</h5>
                                <p>Here is user uploaded documents.</p>
                            </div>
                        </div>
                        <div class="card card-bordered">
                            <ul class="data-list is-compact">
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Document Type</div>
                                        <div class="data-value">
                                            <?= $userData['proof-type'] ?>
                                        </div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Front Side</div>
                                        <div class="data-value">
                                            <?php

                                                if (($userData['proof-front'] != null)) {

                                                    echo '<button class="btn btn-info btn-sm proof-view" data-toggle="modal" data-target="#proofView" data-proof="../' . str_replace('../', '', $userData['proof-front']) . '">View Document</button>';

                                                } else {

                                                    echo '(EMPTY)';

                                                }
                                            
                                            ?>
                                        </div>
                                    </div>
                                </li>

                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Back Side</div>
                                        <div class="data-value">
                                            <?php

                                                if (($userData['proof-back'] != null)) {

                                                    echo '<button class="btn btn-info btn-sm proof-view" data-toggle="modal" data-target="#proofView" data-proof="../' . str_replace('../', '', $userData['proof-back']) . '">View Document</button>';

                                                } else {

                                                    echo '(EMPTY)';

                                                }

                                            ?>
                                        </div>
                                    </div>
                                </li>

                            </ul>
                        </div><!-- .card -->
                    </div><!-- .col -->
                    <div class="col-lg-7">
                        <div class="nk-block-head">
                            <div class="nk-block-head-content">
                                <h5 class="nk-block-title title">Applicant Information</h5>
                                <p>Basic info, like name, phone, address, country etc.</p>
                            </div>
                        </div>
                        <div class="card card-bordered">
                            <ul class="data-list is-compact">
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Tag</div>
                                        <div class="data-value">
                                            <?= $userData['tag'] == null ? '(EMPTY)' : $userData['tag'] ?>
                                        </div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">First Name</div>
                                        <div class="data-value">
                                            <?= $userData['firstname'] ?>
                                        </div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Last Name</div>
                                        <div class="data-value">
                                            <?= $userData['lastname'] ?>
                                        </div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Email Address</div>
                                        <div class="data-value">
                                            <?= $userData['email'] ?>
                                        </div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Phone Number</div>
                                        <div class="data-value text-soft"><em>
                                                <?= chunk_split($userData['phone'], 4, ' ') ?>
                                            </em></div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Date of Birth</div>
                                        <div class="data-value">
                                        <?= $userData['dob'] ? date('l d, M, Y', strtotime($userData['dob'])) : '-' ?>
                                        </div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Zip Code</div>
                                        <div class="data-value">
                                            <?= $userData['zip'] ?>
                                        </div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Full Address</div>
                                        <div class="data-value">
                                            <?= join(', ', [$userData['street'], $userData['city'], $userData['state']]) ?>
                                        </div>
                                    </div>
                                </li>
                                <li class="data-item">
                                    <div class="data-col">
                                        <div class="data-label">Country of Residence</div>
                                        <div class="data-value">
                                            <?= $userData['country'] ?>
                                        </div>
                                    </div>
                                </li>

                            </ul>
                        </div>
                        <!--  -->
                        <?php
                        
                            if ($userData['kyc-status'] != 'UNVERIFIED') { ?>

                                <div class="w-100">

                                    <form class="kyc_form" method="post">

                                        <input type="hidden" name="user-id" value="<?= isset($id) ? $id : '' ?>">

                                        <ul class="row p-3 g-3">

                                            <li><button type="submit" class="btn btn-danger" type="submit" name="decline" value="DECLINE">Reject</button></li>

                                            <li><button type="submit" class="btn btn-success" name="approve" value="APPROVE">Approve</button>

                                        </ul>

                                    </form>

                                </div>

                           <?php }

                        ?>
                    </div><!-- .col -->
                </div><!-- .row -->
            </div><!-- .nk-block -->
        </div>
    </div>
</div>
<!-- content @e -->

<!-- Proof Display Modal -->

<div class="modal fade" tabindex="-1" id="proofView">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <a href="#" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </a>
                <div class="modal-header text-white" style="background-color:#033d75; color: white;">
                    <h5 class="modal-title">KYC Proof</h5>
                </div>
                <div class="modal-body" id="proofDock">
                    
                </div>
                <div class="modal-footer">
                    <button class="btn btn-danger btn-sm" data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

<?php

    require('utility/partials/footer.php');

?>