<?php

    require('utility/partials/header.php');
    
    if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn);

        if (!$userData) {

            echo '<script>
            
                swal({
                
                    title: "Error!",

                    text: "User not found!",

                    icon: "error"

                }).then(() => {
                
                    window.history.go(-1);
                
                });
            
            </script>';

            exit;

        }

        // Get User Loans

        $found = false; // Flag

        $stmt =  mysqli_prepare($conn, "SELECT * FROM `loans` WHERE `user_id` = ? ORDER BY `id` DESC"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Get Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Collect Result Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement


    } else {

        echo '<script>
        
            swal({
            
                title: "Error!",

                text: "Invalid Data",

                icon: "error"
            
            }).then(() => {
            
                window.history.go(-1);
            
            });
        
        </script>';

        exit;

    }

?>

<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal"><?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?> <i>Loans</i></span></h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                        <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?= join (' ', [$userData['firstname'], $userData['lastname']]) ?> Loans <?= '(' . loanCount($id, $conn) . ')' ?></h4>
                <div class="nk-block-des">
                    <p>Below is the list of Loans</p>
                </div>
            </div>
        </div>
        <div class="card card-preview">
        <div class="card-inner">
            <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">

                        <th class="nk-tb-col">#</th>

                        <th class="nk-tb-col"><span class="sub-text">Loan Id</span></th>
                        <th class="nk-tb-col tb-col-mb"><span class="sub-text">Amount / Rate</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Duration / Paid</span></th>
                        <th class="nk-tb-col tb-col-lg"><span class="sub-text">Type (Purpose) / Due</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                        <th class="nk-tb-col tb-col-md"><span class="sub-text">Action</span></th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                        // Check Flag

                        if ($found) {

                            $i = 0; // Counter

                            // Iterate Through Data

                            foreach ($data as $row):

                                $i++;

                                $loanID = $row['loan_id'];

                                $type = $row['type'];

                                $date = $row['start'];

                                $ends = $row['due'];

                                $amount = $row['amount'];

                                $currency = $row['currency'];

                                $rate = $row['interest'];

                                $duration = $row['term'];

                                $payFreq = $row['frequency'];

                                $status = $row['status'];

                                $symbol = $currSymbol[$currency];

                            ?>

                            <tr class="nk-tb-item">
                        
                                <td class="nk-tb-col">
                                    <?= $i ?>
                                </td>
                                <td class="nk-tb-col">
                                    <div class="user-card">
                                        <div class="user-info">
                                            <span class="tb-lead">
                                                <?= $loanID ?>
                                            </span>
                                            <span>
                                                <?= date('l jS, F, Y', strtotime($date)) ?>
                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="nk-tb-col tb-col-mb" data-order="35040.34">
                                    <span class="tb-amount">
                                        <?= $symbol . $amount . ' (' . $currency . ')' ?>
                                    </span>
                                    <span class="currency">
                                        <?= $rate . '%' ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col tb-col-md">
                                    <span class="tb-lead">
                                        <?= $duration . ' days (' . $payFreq . ')' ?>
                                    </span>
                                    <span>
                                        <?= '0%' ?>
                                    </span>
                                </td>
                                <td class="nk-tb-col tb-col-lg" data-order="">

                                    <span class="tb-lead"><?= $type ?></span>

                                    <span><?= date('l jS, F, Y', strtotime($ends)) ?></span>

                                </td>

                                <td class="nk-tb-col tb-col-md">
                                    <?= $status ?>
                                </td>
                                <td class="nk-tb-col nk-tb-col-tools">
                                    <form method="post" class="loanMgmt_form">

                                        <input type="hidden" name="loan-id" value="<?= $loanID ?>">

                                        <ul class="nk-tb-actions gx-1">

                                            <li class="nk-tb-action-hidden">

                                                <button type="submit" name="delete" value="DELETE"
                                                    class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                    title="Delete Loan Record">
                                                    <em class="icon ni ni-delete text-danger"></em>
                                                </button>

                                            </li>

                                            <li>

                                                <div class="dropdown">

                                                    <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                        <ul class="link-list-opt no-bdr">
                                                            <li>
                                                                <a href="loan-repayments?id=<?= $loanID ?>"><em class="icon ni ni-list"></em><span>Repayment Schedule</span></a>

                                                            </li>

                                                        </ul>

                                                    </div>
                                                    
                                                </div>    

                                            </li>

                                        </ul>

                                    </form>
                                </td>
                            </tr>

                        <?php endforeach;

                            }

                        ?>

                </tbody>
            </table>
        </div>
    </div><!-- .card-preview -->
    </div> <!-- nk-block -->

</div><!-- .components-preview -->

<?php

  require('utility/partials/footer.php');

?>