<?php

    require('utility/partials/header.php');

    if (isset($_REQUEST['id'])) {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn); // Fetch User Accounts

        if (!$userData) {

            echo '<script>
        
                alert("An an error occurred!");

                window.history.go(-1);

            </script>';

            exit;

        }
    

    } else {

        echo '<script>

            alert("An error occurred!");

            window.history.go(-1);

        </script>';

        exit;

    }

?>

<div class="nk-content nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Update Account Status.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a onclick="window.history.go(-1);" class="btn btn-primary"><span>Back</span> <em class="icon ni ni-arrow-left"></em></a></li>
                        </ul>
                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="buysell wide-xs m-auto">
                <div class="buysell-nav text-center">
                    <ul class="nk-nav nav nav-tabs nav-tabs-s2">
                        <li class="nav-item">
                            <a class="nav-link">Account Status</a>
                        </li>
                    </ul>
                </div><!-- .buysell-nav -->
                
                <!-- <div class="buysell-title text-center">
                    <h2 class="title">Update Account Status</h2>
                </div>.buysell-title -->
                <div class="buysell-block">

                    <form id="statusForm" class="buysell-form" method="post">
                        <div class="buysell-field form-group">
                            <div class="form-label-group">
                                <label class="form-label">Account:</label>
                            </div>
                            <input type="hidden" value="<?= $id ?>" name="user" id="user">
                            <div class="dropdown buysell-cc-dropdown">
                                <a href="#" class="buysell-cc-choosen dropdown-indicator">
                                    <div class="coin-item coin-btc">
                                        <div class="coin-icon">
                                            <em class="icon ni ni-account-setting-alt"></em>
                                        </div>
                                        <div class="coin-info">
                                            <span class="coin-name">
                                                <?= join(' ', [$userData['firstname'], $userData['middlename'], $userData['lastname']]) ?>
                                            </span>
                                            <span class="coin-text">Account Status:
                                                <?= $userData['account-status'] ?>
                                            </span>
                                        </div>
                                    </div>
                                </a>
                            </div><!-- .dropdown -->
                        </div><!-- .buysell-field -->
                        
                        <div class="buysell-field form-group">
                            <div class="form-label-group">
                                <label class="form-label">Update status to</label>
                            </div>
                            <div class="buysell-field form-group">
                                <div class="form-label-group">
                                </div>
                                <div class="form-control-group">
                                    <select class="form-control form-control-lg form-control-number" id="status" name="status">
                                    
                                        <option value="ACTIVE"<?= $userData['account-status'] === 'ACTIVE' ? ' selected' : '' ?>>ACTIVE</option>

                                        <option value="BANNED"<?= $userData['account-status'] === 'BANNED' ? ' selected' : '' ?>>BANNED</option>

                                        <option value="BLOCKED"<?= $userData['account-status'] === 'BLOCKED' ? ' selected' : '' ?>>BLOCKED</option>

                                        <option value="INACTIVE"<?= $userData['account-status'] === 'INACTIVE' ? ' selected' : '' ?>>INACTIVE</option>

                                        <option value="SUSPENDED"<?= $userData['account-status'] === 'SUSPENDED' ? ' selected' : '' ?>>SUSPENDED</option>

                                        <option value="TRANSFER DISABLED"<?= $userData['account-status'] === 'TRANSFER DISABLED' ? ' selected' : '' ?>>TRANSFER DISABLED</option>

                                        <option value="LOAN DISABLED"<?= $userData['account-status'] === 'LOAN DISABLED' ? ' selected' : '' ?>>LOAN DISABLED</option>

                                        <option value="WIRE DISABLED"<?= $userData['account-status'] === 'WIRE DISABLED' ? ' selected' : '' ?>>WIRE TRANSFER DISABLED</option>

                                        <option value="LOCAL AND TAG DISABLED"<?= $userData['account-status'] === 'LOCAL AND TAG DISABLED' ? ' selected' : '' ?>>LOCAL & TAG TRANSFER DISABLED</option>
                                    
                                    </select>
                                    <div class="form-dropdown">
                                        <div class="text">Update<span></span></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="buysell-field form-action">
                            <button type="submit" class="btn btn-lg btn-block btn-primary" id="statusBtn">Continue</a>
                        </div><!-- .buysell-field -->
                    </form><!-- .buysell-form -->
                </div><!-- .buysell-block -->
            </div><!-- .buysell -->
        </div>
    </div>
</div>

<?php

    require('utility/partials/footer.php');

?>