<?php

    require('utility/partials/header.php');
    
    // checkInstallUrl($site_url)

?>


<div class="nk-content">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            <div class="nk-block-head">
                <div class="nk-block-head-sub">
                </div>
                <div class="nk-block-between-md g-4 card-bordered">
                    <div class="nk-block-head-content">
                        <h4 class="nk-block-title fw-normal">Manage users.</h4>
                        <div class="nk-block-des">
                            <p>
                            </p>
                        </div>
                    </div>
                    <div class="nk-block-head-content">
                        <ul class="nk-block-tools gx-3">
                            <li><a href="unverified-users" class="btn btn-danger"><span>Unverified Users</span> <em
                                        class="icon ni ni-user-check-fill"></em></a></li>
                            <li><a href="create-user" class="btn btn-primary"><span>Open an account</span> <em
                                        class="icon ni ni-user-add-fill"></em></a></li>

                        </ul>

                    </div><!-- .nk-block-head-content -->
                </div><!-- .nk-block-between -->
            </div><!-- .nk-block-head -->
        </div>
    </div>
    <div class="nk-block nk-block-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">All Users</h4>
                <div class="nk-block-des">
                    <p>Below is the list of all users and their account information</code>
                </div>
            </div>
        </div>
        <div class="card card-preview">
            <div class="card-inner">
                <table class="datatable-init nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th class="nk-tb-col">#</th>
                            <th class="nk-tb-col"><span class="sub-text">Fullname</span></th>
                            <th class="nk-tb-col tb-col-mb"><span class="sub-text">Account(s)</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">KYC</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Registration</span></th>
                            <th class="nk-tb-col tb-col-lg"><span class="sub-text">Date registered</span></th>
                            <th class="nk-tb-col tb-col-md"><span class="sub-text">Status</span></th>
                            <th class="nk-tb-col nk-tb-col-tools text-right">
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php

                            $usersFound = false; // User Flag

                            // Fetch All Users
                        
                            $users = mysqli_prepare($conn, "SELECT `A`.*, `B`.`status` AS `kyc_status`, COUNT(`C`.`acc_id`) AS `numb_acc` FROM `users` AS `A` LEFT JOIN `kyc_data` AS `B` ON `A`.`user_id` = `B`.`user_id` LEFT JOIN `accounts` AS `C` ON `A`.`user_id` = `C`.`user_id` GROUP BY `A`.`user_id` ORDER BY `A`.`id` DESC"); // Prepare Statement

                            mysqli_stmt_execute($users); // Execute Statement

                            $usersResult = mysqli_stmt_get_result($users); // Get Statement Result

                            if (mysqli_num_rows($usersResult) > 0) { // Compare Result Mass

                                $usersFound = true; // Update Flag

                                $usersData = mysqli_fetch_all($usersResult, MYSQLI_ASSOC); // Get All Rows

                            }

                            mysqli_free_result($usersResult); // Free Result

                            mysqli_stmt_close($users); // Close Statement

                            // Check Flag

                            if ($usersFound) {

                                $i = 0; // Declear Counter

                                foreach ($usersData as $userData): // Iterate Through Rows

                                    $i++; // Update Counter

                                    $userId = $userData['user_id'];

                                    $firstname = $userData['fname'];

                                    $middlename = $userData['mname'];

                                    $lastname = $userData['lname'];

                                    $fullname = join(' ', [$firstname, $middlename, $lastname]);

                                    $email = $userData['email'];

                                    $status = $userData['acc_status'];

                                    $regDate = $userData['reg_date'];

                                    $regStatus = $userData['reg_clearance'];

                                    $auth = $userData['factor_2FA'];

                                    $kyc = $userData['kyc_status'];

                                    $transfers = $userData['transfers'];

                                    $accounts = $userData['numb_acc'];
    
                                ?>    

                                    <tr class="nk-tb-item">
                                        <!-- <td class="nk-tb-col nk-tb-col-check">
                                            <div class="custom-control custom-control-sm custom-checkbox notext">
                                                <input type="checkbox" class="custom-control-input" id="<?= $userId ?>">
                                                <label class="custom-control-label" for="<?= $userId ?>"></label>
                                            </div>
                                        </td> -->
                                        <td class="nk-tb-col"><?= $i ?></td>

                                        <td class="nk-tb-col">
                                            <div class="user-card">
                                                <div class="user-avatar bg-dim-primary d-none d-sm-flex">
                                                    <span>
                                                        <?= strtoupper(substr($fullname, 0, 2)) ?>
                                                    </span>
                                                </div>
                                                <div class="user-info">
                                                    <span class="tb-lead">
                                                        <?= $fullname ?><span class="dot dot-success d-md-none ml-1"></span>
                                                    </span>
                                                    <span>
                                                        <?= $email ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <span>
                                                <?= $accounts ?>
                                            </span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <ul class="list-status">
                                            
                                                <?php
                                                
                                                    if ($kyc == 'PROCESSING') {

                                                        echo '<li><em class="icon text-warning ni ni-alert-circle"></em> <span>PROCESSING</span><li>';

                                                    } else if ($kyc == 'VERIFIED') {

                                                        echo '<li><em class="icon text-success ni ni-check-circle"></em> <span>VERIFIED</span></li>';

                                                    } else {

                                                        echo '<li><em class="icon text-danger ni ni-alert-circle"></em> <span>UNVERIFIED</span><li>';

                                                    }
                                                
                                                ?>

                                                </ul>
                                        </td>
                                        <td class="nk-tb-col tb-col-lg" data-order="Email Verified - Kyc Unverified">
                                            <ul class="list-status">
                                                <?php
                                                
                                                    if ($regStatus == 'CLEARED') {

                                                        echo '<li><em class="icon text-success ni ni-check-circle"></em> <span>VERIFIED</span></li>';

                                                    } else {

                                                        echo '<li><em class="icon text-danger ni ni-alert-circle"></em> <span>PENDING</span></li>';

                                                    }
                                                
                                                ?>
                                            </ul>
                                        </td>
                                        <td class="nk-tb-col tb-col-lg">
                                            <span>
                                                <?= ($regDate != null) ? date('l jS, F, Y', strtotime($regDate)) : '(Empty)' ?>
                                            </span>
                                        </td>
                                        <td class="nk-tb-col tb-col-md">
                                            <?= $status ?>
                                        </td>
                                        <td class="nk-tb-col nk-tb-col-tools">
                                            <form class="userMgmt-form" method="post">
                                                <input type="hidden" name="user-id" value="<?= $userId ?>">
                                                <ul class="nk-tb-actions gx-1">
                                                    <li class="nk-tb-action-hidden">
                                                        <a href="fund-user?id=<?= $userId ?>"
                                                            class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top"
                                                            title="Credit user">
                                                            <em class="icon ni ni-wallet-in text-success"></em>
                                                        </a>
                                                    </li>
                                                    <li class="nk-tb-action-hidden">
                                                        <a href="debit-user?id=<?= $userId ?>" class="btn btn-trigger btn-icon"
                                                            data-toggle="tooltip" data-placement="top" title="Debit user">
                                                            <em class="icon ni ni-wallet-out text-danger"></em>
                                                        </a>
                                                    </li>

                                                    <li class="nk-tb-action-hidden">
                                                        <button type="submit" name="toggle-2fa" value="<?= ($auth == 'ENABLED') ? 'DISABLE' : 'ENABLE' ?>" class="btn btn-trigger btn-icon" data-toggle="tooltip" data-placement="top" title="<?= ($auth == 'ENABLED') ? 'Disable ' : 'Enable ' ?>2FA">
                                                            <em class="icon ni ni-security<?= ($auth == 'ENABLED') ? ' text-danger' : ' text-success' ?>"></em>
                                                        </a>
                                                    </li>

                                                    <li>
                                                        <div class="dropdown">
                                                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger"
                                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                                            <div class="dropdown-menu dropdown-menu-right">
                                                                <ul class="link-list-opt no-bdr">
                                                                    <li><a href="user-details?id=<?= $userId ?>"><em
                                                                                class="icon ni ni-eye"></em><span>View
                                                                                Details</span></a></li>
                                                                    <li><a href="user-transactions?id=<?= $userId ?>"><em
                                                                                class="icon ni ni-repeat"></em><span>Transactions</span></a>
                                                                    </li>
                                                                    <li><a href="user-activity?id=<?= $userId ?>"><em
                                                                                class="icon ni ni-activity-round"></em><span>Activities</span></a>
                                                                    </li>
                                                                    <li><a href="billing-codes?id=<?= $userId ?>"><em
                                                                                class="icon ni ni-unlock"></em><span>Billing Codes</span></a>
                                                                    </li>
                                                                    <li class="divider"></li>
                                                                    <li><a href="user-status?id=<?= $userId ?>"><em
                                                                    class="icon ni ni-setting"></em><span>Account Status</span></a></li>
                                                                    <li><a href="generate-transactions?id=<?= $userId ?>"><em
                                                                    class="icon ni ni-setting"></em><span>Generate Transac.</span></a></li>
                                                                    <li><a href="password-reset?id=<?= $userId ?>"><em
                                                                                class="icon ni ni-shield-star"></em><span>Reset
                                                                                Password</span></a></li>
                                                                    <li><button class="btn w-100" type="submit" name="delete-user" value="DELETE"><em
                                                                                class="icon ni ni-delete text-danger"></em><span>Delete</span></button>
                                                                    </li>

                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </form>    
                                        </td>
                                    </tr>

                                <?php endforeach;

                            }

                        ?>

                    </tbody>
                </table>
            </div>
        </div><!-- .card-preview -->
    </div> <!-- nk-block -->
</div><!-- .components-preview -->


<?php

  require('utility/partials/footer.php');

?>