<?php
    
    session_name('ADMINSESSID');

    session_start(); // Initialize Session

    require('../controls/config/config.php'); // Configuration Settings

    require('../controls/engines/fxns.php'); // Functions File

    adminAccess(); // Perform Accessibility Check

    $adminData = adminData($conn); // Get Admin Info

    if (!$adminData) {

        $_SESSION = [];

        session_destroy();

        echo '<script>
        
            window.location.href = "login";
        
        </script>';

    }

?>

<!DOCTYPE html>

<html lang="en" class="js">

<head>
    <meta charset="UTF-8">
    <meta name="author" content="Smart">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?= SITE_DESCR ?>">
    <!-- Fav Icon  -->
    <link rel="shortcut icon" href="<?= SITE_FAVICON ?>">
    <!-- Page Title  -->
    <title><?= adminPageTitle() , ' | ' , SITE_NAME ?> Administrator</title>
    <!-- StyleSheets  -->

    <noscript>
        <meta http-equiv="refresh" content="0; url=../noscript" />
    </noscript>
    
    <link rel="stylesheet" href="assets/css/dashlite.css?ver=2.4.0">
    <link id="skin-default" rel="stylesheet" href="assets/css/theme.css?ver=2.4.0">
    <!-- <link rel="stylesheet" type="text/css" href="assets/css/libs/fontawesome-icons.css"> -->

    <script src="https://kit.fontawesome.com/0b68ed503d.js" crossorigin="anonymous" async=""></script>

    <!-- Sweetalert -->

    <link rel="stylesheet" href="../resources/swal/sweet-alert.css">
    <script src="../resources/swal/sweetalert.min.js"></script>

    <!-- Sweetalert 2 -->

    <!-- <script src="../resources/swal2/sweetalert2.all.min.js"></script> -->

    <!-- Toastr -->

    <link rel="stylesheet" href="../resources/toastr/toastr.css">
    <script src="../resources/toastr/toastr.js"></script>
    <!-- <link rel="stylesheet" -->
        <!-- href="https://www.jqueryscript.net/demo/jQuery-International-Telephone-Input-With-Flags-Dial-Codes/build/css/intlTelInput.css"> -->

    <style>

        .nk-sidebar .nk-sidebar-content .nk-sidebar-menu {
            overflow: auto;
            scrollbar-width: thin;
        }

    </style>

</head>

<body class="nk-body bg-white has-sidebar">
    <div class="nk-app-root">
        <!-- main @s -->
        <div class="nk-main ">
            <!-- sidebar @s -->
            <div class="nk-sidebar nk-sidebar-fixed " data-content="sidebarMenu">
                <div class="nk-sidebar-element nk-sidebar-head">
                    <div class="nk-sidebar-brand">
                        <a href="dashboard" class="logo-link nk-sidebar-logo">
                            <img class="logo-light logo-img" src="<?= SITE_LOGO_DARK ?>"
                                srcset="<?= SITE_LOGO_DARK ?> 2x" alt="logo">
                            <img class="logo-dark logo-img" src="<?= SITE_LOGO ?>"
                                srcset="<?= SITE_LOGO ?> 2x" alt="logo-dark">
                        </a>
                    </div>
                    <div class="nk-menu-trigger mr-n2">
                        <a href="#" class="nk-nav-toggle nk-quick-nav-icon d-xl-none" data-target="sidebarMenu"><em
                                class="icon ni ni-arrow-left"></em></a>
                    </div>
                </div><!-- .nk-sidebar-element -->
                <div class="nk-sidebar-element">
                    <div class="nk-sidebar-body" data-simplebar>
                        <div class="nk-sidebar-content">
                            <div class="nk-sidebar-menu">
                                <ul class="nk-menu">
                                    <li class="nk-menu-heading">
                                        <h6 class="overline-title text-primary-alt">Quick Action</h6>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="dashboard" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-dashboard"></em></span>
                                            <span class="nk-menu-text">Dashboard</span><span
                                                class="nk-menu-badge badge-danger">Metrics</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="users" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-users"></em></span>
                                            <span class="nk-menu-text">Users</span><span
                                                class="nk-menu-badge badge-danger">Manage</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="create-user" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-user-add"></em></span>
                                            <span class="nk-menu-text">Create a user account</span><span
                                                class="nk-menu-badge badge-danger">New</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-heading">
                                        <h6 class="overline-title text-primary-alt">Dashboards</h6>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="deposits" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-cc-alt2"></em></span>
                                            <span class="nk-menu-text">Deposits <span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(depositsCount($conn)) ?></span></span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="requests" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-question"></em></span>
                                            <span class="nk-menu-text">Requests</span><span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(requestsCount($conn)) ?></span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="payments" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-coins"></em></span>
                                            <span class="nk-menu-text">Payments</span><span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(paymentCount($conn)) ?></span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="investments" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-invest"></em></span>
                                            <span class="nk-menu-text">Investment Plans</span><span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(investmentCount($conn)) ?></span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="invoice-payments" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-reports"></em></span>
                                            <span class="nk-menu-text">Paid Invoices</span><span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(paidInvoicesCount($conn)) ?></span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="transfers" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-swap"></em></span>
                                            <span class="nk-menu-text">Transfers <span
                                            class="nk-menu-badge badge-danger">Withdrawals: <?= shortenNumber(transfersCount($conn)) ?></span></span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="transactions" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-tranx"></em></span>
                                            <span class="nk-menu-text">Transactions <span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(transactionsCount($conn)) ?></span></span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="support-tickets.php" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-chat-fill"></em></span>
                                            <span class="nk-menu-text">Support <span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(ticketsCount($conn)) ?></span></span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="virtual-cards" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-cc-alt2-fill"></em></span>
                                            <span class="nk-menu-text">Virtual Cards <span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(cardsCount($conn)) ?></span></span>
                                        </a>
                                    </li>
                                    <li class="nk-menu-item">
                                        <a href="kyc" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-file-docs"></em></span>
                                            <span class="nk-menu-text">KYC Application <span
                                            class="nk-menu-badge badge-danger"><?= shortenNumber(kycCount($conn)) ?></span></span>
                                        </a>
                                    </li>
                                    <li class="nk-menu-item has-sub">
                                        <a href="#" class="nk-menu-link  nk-menu-toggle">
                                            <span class="nk-menu-icon"><em class="icon ni ni-repeat"></em></span>
                                            <span class="nk-menu-text">Loan/Credit Financing</span>
                                        </a>
                                        <ul class="nk-menu-sub">
                                            <li class="nk-menu-item">
                                                <a href="loans" class="nk-menu-link"><span class="nk-menu-text">
                                                        Manage Loans <span
                                                            class="badge badge-primary"><?= shortenNumber(loansCount($conn)) ?></span></span></a>
                                            </li>

                                            <li class="nk-menu-item">
                                                <a href="loan-requests" class="nk-menu-link"><span
                                                        class="nk-menu-text">Loan Requests <span
                                                            class="badge badge-primary"><?= shortenNumber(loanRequestsCount($conn)) ?></span></span></a>
                                            </li>
                                        </ul><!-- .nk-menu-sub -->
                                    </li><!-- .nk-menu-item -->

                                    <li class="nk-menu-item">
                                        <a href="pay-settings" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-sign-mxn"></em></span>
                                            <span class="nk-menu-text">Payment Gateway Settings</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->

                                    <li class="nk-menu-item">
                                        <a href="banks" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-sign-dollar"></em></span>
                                            <span class="nk-menu-text">Banks</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->

                                    <li class="nk-menu-item">
                                        <a href="settings" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-setting"></em></span>
                                            <span class="nk-menu-text">General Settings</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    
                                    <li class="nk-menu-item">
                                        <a href="branding" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-camera"></em></span>
                                            <span class="nk-menu-text">Logo & Favicon</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <!-- <li class="nk-menu-item">
                                        <a href="plugins" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-toolbar"></em></em></span>
                                            <span class="nk-menu-text">Plugins</span>
                                        </a>
                                    </li>.nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="smtp" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em
                                                    class="icon ni ni-setting-alt-fill"></em></span>
                                            <span class="nk-menu-text">Email Configuration</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="location-restrictions" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-location"></em></span>
                                            <span class="nk-menu-text">Location Restrictions</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="security" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-lock"></em></span>
                                            <span class="nk-menu-text">Security / Maintenance</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <li class="nk-menu-item">
                                        <a href="website-activities" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-activity-round"></em></span>
                                            <span class="nk-menu-text">Website Activities</span>
                                        </a>
                                    </li><!-- .nk-menu-item -->
                                    <!-- <li class="nk-menu-item">
                                        <a href="sliders" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-camera-fill"></em></span>
                                            <span class="nk-menu-text">Slider Setting</span>
                                        </a>
                                    </li>.nk-menu-item -->
                                    <!-- <li class="nk-menu-item">
                                        <a href="miscellaneous" class="nk-menu-link">
                                            <span class="nk-menu-icon"><em class="icon ni ni-opt-dot-fill"></em></span>
                                            <span class="nk-menu-text">Miscellaneous</span>
                                        </a>
                                    </li>.nk-menu-item -->


                                </ul><!-- .nk-menu -->
                            </div><!-- .nk-sidebar-menu -->
                            <div class="nk-sidebar-footer">
                                <ul class="nk-menu nk-menu-footer">

                                    <!-- <a>
                                        <div id="google_translate_element"></div>
                                    </a> -->
                                </ul>
                            </div><!-- .nk-sidebar-footer -->
                        </div><!-- .nk-sidebar-content -->
                    </div><!-- .nk-sidebar-body -->
                </div><!-- .nk-sidebar-element -->
            </div>
            <!-- sidebar @e -->
            <!-- wrap @s -->
            <div class="nk-wrap ">
                <!-- main header @s -->
                <div class="nk-header nk-header-fixed is-light">
                    <div class="container-fluid">
                        <div class="nk-header-wrap">
                            <div class="nk-menu-trigger d-xl-none ml-n1">
                                <a href="#" class="nk-nav-toggle nk-quick-nav-icon" data-target="sidebarMenu"><em
                                        class="icon ni ni-menu"></em></a>
                            </div>
                            <div class="nk-header-brand d-xl-none">
                                <a href="html/index.html" class="logo-link">
                                    <img class="logo-light logo-img" src="<?= $siteLogo ?>"
                                        srcset="<?= $siteLogo ?>" alt="logo">
                                    <img class="logo-dark logo-img" src="<?= $siteLogo ?>"
                                        srcset="<?= $siteLogo ?> 2x" alt="logo-dark">
                                </a>
                            </div><!-- .nk-header-brand -->
                            <div class="nk-header-news d-none d-xl-block">
                                <div class="nk-news-list">
                                    <a class="nk-news-item" href="#">
                                        <!-- <div class="nk-news-icon">
                                            <em class="icon ni ni-card-view"></em>
                                        </div>
                                        <div class="nk-news-text">
                                            <p>Do you know the latest update of 2019? <span> A overview of our is now
                                                    available on YouTube</span></p>
                                            <em class="icon ni ni-external"></em>
                                        </div> -->
                                    </a>
                                </div>
                            </div><!-- .nk-header-news -->
                            <div class="nk-header-tools">
                                <ul class="nk-quick-nav">
                                    <li class="dropdown user-dropdown">
                                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                            <div class="user-toggle">
                                                <div class="user-avatar sm">
                                                    <em class="icon ni ni-user-alt"></em>
                                                </div>
                                                <div class="user-info d-none d-md-block">
                                                    <div class="user-status">Administrator</div>
                                                    <div class="user-name dropdown-indicator">
                                                        <?= $siteName . ' Administrator' ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                        <div
                                            class="dropdown-menu dropdown-menu-md dropdown-menu-right dropdown-menu-s1">
                                            <div class="dropdown-inner user-card-wrap bg-lighter d-none d-md-block">
                                                <div class="user-card">
                                                    <div class="user-avatar">
                                                        <span>AB</span>
                                                    </div>
                                                    <div class="user-info">
                                                        <span class="lead-text">
                                                             <!-- echo $adfirstname $admiddlename $adlastname; -->
                                                        </span>
                                                        <span class="sub-text">
                                                            <?= '' ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="dropdown-inner">
                                                <ul class="link-list">
                                                    <!-- <li><a href="admin_profile"><em
                                                                class="icon ni ni-user-alt"></em><span>View
                                                                Profile</span></a></li> -->
                                                    <li><a href="admin-settings"><em
                                                                class="icon ni ni-setting-alt"></em><span>Account
                                                                Setting</span></a></li>
                                                    <li><a href="login-activity"><em
                                                                class="icon ni ni-activity-alt"></em><span>Login
                                                                Activity</span></a></li>
                                                    <li><a class="dark-switch" href="#"><em
                                                                class="icon ni ni-moon"></em><span>Dark Mode</span></a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="dropdown-inner">
                                                <ul class="link-list">
                                                    <li><a href="logout"><em class="icon ni ni-signout"></em><span>Sign
                                                                out</span></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </li><!-- .dropdown -->
                                </ul><!-- .nk-quick-nav -->
                            </div><!-- .nk-header-tools -->
                        </div><!-- .nk-header-wrap -->
                    </div><!-- .container-fliud -->
                </div>