// Button Loading Functions 

function processStart(element) {

    let loadingText = '<i class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></i>&nbsp;Processing...';

    element.disabled = true;

    element.innerHTML = loadingText;
    
    if (element.disabled) return;

}

function processEnd(element, text) {

    element.disabled = false;

    element.innerHTML = text;

}

function showProcessingModal() {
  console.log("showProcessingModal was called");
  
  Swal.fire({
    title: 'Processing...',
    html: '<i>Just a moment, please...</i>',
    didOpen: () => {
      console.log("Modal is opened, showing loading spinner...");
      Swal.showLoading();  // Show the loading spinner
    },
    showConfirmButton: false,  // Hide the confirm button during processing
    allowOutsideClick: false   // Prevent closing modal by clicking outside
  });
}


// Process Modal Functions (Uses SweetAlert2)

let processModal;

// Open Process Modal

function openProcessModal() {

    processModal = Swal.fire({

        title: 'Processing',

        html: '<i>Just a moment...</i>',

        didOpen: () => {

            Swal.showLoading();

        },

        showConfirmButton: false,

        allowOutsideClick: false

    });

}

// Close Process Modal

function closeProcessModal() {

    if (processModal) {

        processModal.close();

    }

}

// Billing Code Manager Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.bcode-mgmt-form');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    // const name = buttonClicked.name;

                    let confirmationMsg = '';

                    switch (action) {

                        case 'SEND': confirmationMsg = 'You\'re about to mail this billing code to the user by doing so you\'ll automatically set the status as paid. Continue?';

                        break;

                        case 'DELETE': confirmationMsg = 'Are you sure you want to delete this billing code?';

                        break;

                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMsg,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    await processForm(form, action); // Process Form

                }

            });

        });

        async function processForm(form, action) {
            
            openProcessModal(); // Display Process Modal

            try {

                let formData = new FormData(form); // Get Form Data

                formData.append('action', action);

                let processor = await fetch('utility/processors/bcode-mgmt-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                let msg; // Holds Feeback 
                
                if (response.codeNotFound) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'warning',
        
                            text: 'Couldn\'t find billing code!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else if (response.userError) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'warning',
        
                            text: 'Couldn\'t find user!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else {

                    if (response.succeeded) {

                        // Customize Message

                        if (action == 'DELETE') {

                            msg = 'Billing code deleted!';

                        } else if (action == 'SEND') {

                            msg = 'Billing code sent!';

                        }

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: msg
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);

                    } else {

                        // Customize Message

                        if (action == 'DELETE') {

                            msg = 'Billing code deletion failed, try again!';

                        } else if (action == 'SEND') {

                            msg = 'Couldn\'t send billing code, try again!';

                        }

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'error',
            
                                text: msg
            
                            });

                        }, 2000);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log error to console

                setTimeout(() => {

                    closeProcessModal(); // Disable Process Modal

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                }, 1200);

            }

        }

    }

});

// Billing Code Creation Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#codeForm');

    if (form) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Stop Submission

            let type = document.querySelector('#code-type');

            let percent = document.querySelector('#code-percent');

            let amount = document.querySelector('#code-amount');

            if (type.value == 'PERCENTAGE' && percent.value.trim().length == 0) {

                new swal({

                    title: 'Error!',

                    icon: 'error',

                    text: 'Specify code percentage'

                });

            } else { 
                
                if (type.value == 'FIXED AMOUNT' && amount.value.trim().length == 0) {

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'Specify code amount'

                    });

                } else {

                    try {

                        // Process Form

                        let formData = new FormData(form); // Collect Form Data

                        let processor = await fetch('utility/processors/create-billing-code.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.codeCreated) {

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Billing code created!'
            
                            }).then(() => {

                                form.reset();

                                window.location.reload();

                                return;

                            });

                        } else {

                            new swal({

                                title: 'Attention!',
            
                                icon: 'error',
            
                                text: 'An error occurred!'
            
                            });

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log Error to Console

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Please, try again!'
        
                        });

                    }    

                }

            }

        });

    }

});

// Billing Code Edit Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#editCodeForm');

    let button = document.querySelector('#editCodeBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {
            
            event.preventDefault(); // Stop Submission

            let content = button.innerHTML; // Store Original Content 

            processStart(button);

            let type = document.querySelector('#code-type');

            let percent = document.querySelector('#code-percent');

            let amount = document.querySelector('#code-amount');

            if (type.value == 'PERCENTAGE' && percent.value.trim().length == 0) {

                new swal({

                    title: 'Error!',

                    icon: 'error',

                    text: 'Specify code percentage'

                });

            } else { 
                
                if (type.value == 'FIXED AMOUNT' && amount.value.trim().length == 0) {

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'Specify code amount'

                    });

                } else {

                    try {

                        // Process Form

                        let formData = new FormData(form); // Collect Form Data

                        let processor = await fetch('utility/processors/edit-billing-code.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.codeUpdated) {

                            setTimeout(() => {

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Billing code updated!'
                
                                }).then(() => {
    
                                    form.reset();
    
                                    window.location.reload();
    
                                    return;
    
                                });

                                processEnd(button, content);

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: 'An error occurred!'
                
                                });

                                processEnd(button, content);

                            }, 2000);

                            

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log Error to Console

                        setTimeout(() => {

                            new swal({

                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Please, try again!'
            
                            });

                            processEnd(button, content);

                        });

                    }    

                }

            }

        });

    }

});

// Website Settings Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#webForm');

    let button = document.querySelector('#webBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            let content = button.innerHTML; // Store Original Content

            processStart(button); // Prevent Multiple Clicks

            try {

                // Process Form

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/web-settings-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.urlError) {

                    setTimeout(() => {

                        new swal({
    
                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Invalid URL. Check Base URL, Buy Crypto & Support URL.'
        
                        });
    
                        processEnd(button, content);
    
                    }, 2000);
    

                } else if (response.updated) {

                    setTimeout(() => {

                        new swal({
    
                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Website settings updated.'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });
    
                        processEnd(button, content);
    
                    }, 2000);
    

                } else {

                    setTimeout(() => {

                        new swal({
    
                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'An error occurred. Please, try again!'
        
                        });
    
                        processEnd(button, content);
    
                    }, 2000);

                }

            } catch (error) {

                console.error('Error', error); // Log Error to Console

                setTimeout(() => {

                    new swal({

                        title: 'Error!',
    
                        icon: 'error',
    
                        text: 'Please, try again!'
    
                    });

                    processEnd(button, content);

                }, 2000);

            }

        });

    }

});

// Website Logo Upload Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#logoForm');

    let button = document.querySelector('#logoBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            let content = button.innerHTML; // Store Original Content

            processStart(button); // Prevent Multiple Clicks

            try {

                // Process Form

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/logo-upload.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.nullInput) {

                    setTimeout(() => {

                        new swal({
    
                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Please upload a file.'
        
                        });
    
                        processEnd(button, content);
    
                    }, 2000);
    

                } else if (response.uploadError) {

                    let msg = response.msg;

                    setTimeout(() => {

                        new swal({
    
                            title: 'Error!',
        
                            icon: 'error',
        
                            text: msg
        
                        });
    
                        processEnd(button, content);
    
                    }, 2000);
    

                } else {

                    if (response.upload) {

                        setTimeout(() => {

                            new swal({
        
                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Updated successfully.'
            
                            }).then(() => {
    
                                window.location.reload();
    
                                return;
    
                            });
        
                            processEnd(button, content);
        
                        }, 2000);

                    } else {

                        setTimeout(() => {

                            new swal({
        
                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'An error occurred. Please, try again!'
            
                            });
        
                            processEnd(button, content);
        
                        }, 2000);

                    }    

                }

            } catch (error) {

                console.error('Error', error); // Log Error to Console

                setTimeout(() => {

                    new swal({

                        title: 'Error!',
    
                        icon: 'error',
    
                        text: 'Please, try again!'
    
                    });

                    processEnd(button, content);

                }, 2000);

            }

        });

    }

});

// Credit User Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#creditForm');

    let button = document.querySelector('#creditBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            let content = button.innerHTML;

            processStart(button); // Prevent User Interaction

            let account = form.querySelector('select[name="account"]')

            if (account.value.trim() == 0) {

                new swal({

                    title: 'Error!',

                    icon: 'info',

                    text: 'Please, select account!'

                });

                processEnd(button, content);

            } else {

                // Process Form

                try {

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/credit-processor.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        window.location.reload();

                        return;

                    } else if (response.amtError) {

                        setTimeout(() => {

                            new swal({
        
                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Invalid Amount.'
            
                            });
        
                            processEnd(button, content);
        
                        }, 1200);

                    } else {

                        if (response.credited) {

                            setTimeout(() => {

                                new swal({
            
                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account credited successfully.'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });
            
                                processEnd(button, content);
            
                            }, 2000);

                        } else {

                            setTimeout(() => {

                                new swal({
            
                                    title: 'Error!',
                
                                    icon: 'error',
                
                                    text: 'An error occurred.'
                
                                });
            
                                processEnd(button, content);
            
                            }, 2000);

                        }

                    }

                } catch (error) {

                    console.error('Error', error); // Log Error to Console

                    setTimeout(() => {

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Please, try again!'
        
                        });

                        processEnd(button, content);

                    }, 2000);

                }

            }    

        });

    }

});

// Debit User Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#debitForm');

    let button = document.querySelector('#debitBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            let content = button.innerHTML;

            processStart(button); // Prevent User Interaction

            let account = form.querySelector('select[name="account"]')

            if (account.value.trim() == 0) {

                new swal({

                    title: 'Error!',

                    icon: 'info',

                    text: 'Please, select account!'

                });

                processEnd(button, content);

            } else {

                // Process Form

                try {

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/debit-processor.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.refresh) {

                        window.location.reload();

                        return;

                    } else if (response.amtError) {

                        setTimeout(() => {

                            new swal({
        
                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Invalid Amount.'
            
                            });
        
                            processEnd(button, content);
        
                        }, 1200);

                    } else {

                        if (response.debited) {

                            setTimeout(() => {

                                new swal({
            
                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account debited successfully.'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });
            
                                processEnd(button, content);
            
                            }, 2000);

                        } else {

                            setTimeout(() => {

                                new swal({
            
                                    title: 'Error!',
                
                                    icon: 'error',
                
                                    text: 'An error occurred.'
                
                                });
            
                                processEnd(button, content);
            
                            }, 2000);

                        }

                    }

                } catch (error) {

                    console.error('Error', error); // Log Error to Console

                    setTimeout(() => {

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Please, try again!'
        
                        });

                        processEnd(button, content);

                    }, 2000);

                }

            }    

        });

    }

});

// Update User Status Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#statusForm');

    let button = document.querySelector('#statusBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            let content = button.innerHTML;

            processStart(button); // Prevent User Interaction

            // Process Form

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/account-status-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                    return;

                } else {


                    if (response.statusUpdated) {

                        setTimeout(() => {

                            new swal({
        
                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Account status updated.'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });
        
                            processEnd(button, content);
        
                        }, 2000);

                    } else {

                        setTimeout(() => {

                            new swal({
        
                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'An error occurred.'
            
                            });
        
                            processEnd(button, content);
        
                        }, 2000);

                    }

                }

            } catch (error) {

                console.error('Error', error); // Log Error to Console

                setTimeout(() => {

                    new swal({

                        title: 'Error!',
    
                        icon: 'error',
    
                        text: 'Please, try again!'
    
                    });

                    processEnd(button, content);

                }, 2000);

            }  

        });

    }

});

// Reset Password Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#keyForm');

    let button = document.querySelector('#keyBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            let content = button.innerHTML;

            processStart(button); // Prevent User Interaction

            // Process Form

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/reset-password-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                    return;

                } else {

                    if (response.lengthError) {

                        setTimeout(() => {

                            new swal({
        
                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Password must be at least 8 characters.'
            
                            });
        
                            processEnd(button, content);
        
                        }, 2000);

                    } else if (response.matchError) {

                        setTimeout(() => {

                            new swal({
        
                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Passwords don\'t match.'
            
                            });
        
                            processEnd(button, content);
        
                        }, 2000);

                    } else {

                        if (response.pwrdReset) {

                            setTimeout(() => {

                                new swal({
            
                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account password reset.'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });
            
                                processEnd(button, content);
            
                            }, 2000);

                        } else {

                            setTimeout(() => {

                                new swal({
            
                                    title: 'Error!',
                
                                    icon: 'error',
                
                                    text: 'An error occurred.'
                
                                });
            
                                processEnd(button, content);
            
                            }, 2000);

                        }

                    }    

                }

            } catch (error) {

                console.error('Error', error); // Log Error to Console

                setTimeout(() => {

                    new swal({

                        title: 'Error!',
    
                        icon: 'error',
    
                        text: 'Please, try again!'
    
                    });

                    processEnd(button, content);

                }, 2000);

            }  

        });

    }

});

// Supoort Ticket Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.ticket-mgmt-form');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    // const name = buttonClicked.name;

                    let confirmationMsg = '';

                    switch (action) {

                        case 'PAUSE': confirmationMsg = 'Are you sure you want to put this user on hold? Message delivery will be disabled';

                        break;

                        case 'RESUME': confirmationMsg = 'Release hold? Message delivery will be restored';

                        break;

                        case 'DELETE': confirmationMsg = 'You\'re about to delete this ticket along with it\'s messages!';

                        break;

                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMsg,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    await processForm(form, action); // Process Form

                }

            });

        });

        async function processForm(form, action) {
            
            openProcessModal(); // Display Process Modal

            try {

                let formData = new FormData(form); // Get Form Data

                formData.append('action', action);

                let processor = await fetch('utility/processors/support-ticket-manager.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                let msg; // Holds Feeback Message

                if (response.updated) {

                    msg = (action == 'PAUSE') ? 'Support ticket Held, user can\'t reply.' : 'Hold released, user messaging privilege restored'

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: msg
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else if (response.deleted) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Ticket deleted!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else {

                    // Customize Message

                    if (action == 'DELETE') {

                        msg = 'Deletion failed, try again!';

                    } else if (action == 'PAUSE') {

                        msg = 'Hold failed, try again!';

                    } else if (action == 'RESUME') {

                        msg = 'Hold still active, try again!';

                    }

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'error',
        
                            text: msg
        
                        });

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log error to console

                setTimeout(() => {

                    closeProcessModal(); // Disable Process Modal

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                }, 1200);

            }

        }

    }

});

// User Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.userMgmt-form');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    // const name = buttonClicked.name;

                    let confirmationMsg = '';

                    switch (action) {

                        case 'APPROVE': confirmationMsg = 'You\'re about to grant this user login access by upgrading registration state. Continue?';

                        break;

                        case 'DENY': confirmationMsg = 'Denying this user dashboard access will essentially be deletion';

                        break;

                        case 'ENABLE': confirmationMsg = 'You\'re about to activate 2FA Authentication';

                        break;

                        case 'DISABLE': confirmationMsg = 'You\'re about to deactivate 2FA Authentication';

                        break;

                        case 'DELETE': confirmationMsg = 'You\'re about to delete a user\'s records and data, including unpaid loans, if any?';

                        break;

                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMsg,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    await processForm(form, action); // Process Form

                }

            });

        });

        async function processForm(form, action) {
            
            openProcessModal(); // Display Process Modal

            try {

                let formData = new FormData(form); // Get Form Data

                formData.append('action', action);

                let processor = await fetch('utility/processors/user-mgmt.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                let msg; // Holds Feeback Message

                if (response.succeeded) {

                    // Customize Message

                    if (action == 'APPROVE') {

                        msg = 'Registration approved, dashboard access granted!';

                    } else if (action == 'DELETE') {

                        msg = 'User record(s) deleted!';

                    } else if (action == 'DENY') {

                        msg = 'Registration denied, user deleted!';

                    } else {

                        msg = (action == 'ENABLE') ? '2FA authentication enabled!' : '2FA authentication disabled!';

                    }

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: msg
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else {

                    // Customize Message

                    if (action == 'APPROVE') {

                        msg = 'Registration approval failed!';

                    } else if (action == 'DELETE') {

                        msg = 'User record(s) deletion failed, try again!';

                    } else if (action == 'DENY') {

                        msg = 'Registration denial failed!';

                    } else {

                        msg = (action == 'ENABLE') ? '2FA authentication couldn\'t be enabled, try again!' : '2FA authentication couldn\'t be disabled, try again!';

                    }

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'error',
        
                            text: msg
        
                        });

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log error to console

                setTimeout(() => {

                    closeProcessModal(); // Disable Process Modal

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                }, 1200);

            }

        }

    }

});

// User Access Action Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.access-mgmt-form');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    // const name = buttonClicked.name;

                    let confirmationMsg = '';

                    switch (action) {

                        case 'ALLOW': confirmationMsg = 'Grant IP & Cookie Access? Continue?';

                        break;

                        case 'BLOCK': confirmationMsg = 'Deny IP & Cookie Access? Continue?';

                        break;

                        case 'DELETE': confirmationMsg = 'You\'re about to delete this access record!';

                        break;

                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMsg,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    await processForm(form, action); // Process Form

                }

            });

        });

        async function processForm(form, action) {
            
            openProcessModal(); // Display Process Modal

            try {

                let formData = new FormData(form); // Get Form Data

                formData.append('action', action);

                let processor = await fetch('utility/processors/access-mgmt.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                let msg; // Holds Feeback Message

                if (response.succeeded) {

                    // Customize Message

                    if (action == 'ALLOW') {

                        msg = 'Access Granted!';

                    } else if (action == 'DELETE') {

                        msg = 'Record deleted!';

                    } else if (action == 'BLOCK') {

                        msg = 'Access Denied!';

                    }

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: msg
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else {

                    // Customize Message

                    // if (action == 'ALLOW') {

                    //     msg = 'Access Granted!';

                    // } else if (action == 'DELETE') {

                    //     msg = 'Record deleted!';

                    // } else if (action == 'BLOCK') {

                    //     msg = 'Access Denied!';

                    // } else {

                        msg = 'Action Failed!';

                    // }

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'error',
        
                            text: msg
        
                        });

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log error to console

                setTimeout(() => {

                    closeProcessModal(); // Disable Process Modal

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                }, 1200);

            }

        }

    }

});

// Clear Access Log Handler

document.addEventListener("DOMContentLoaded", () => {

    let button = document.querySelector('#delete-access-logs');

    if (button) {

        button.addEventListener("click", async () => {

            const confirmDialog = await Swal.fire({
                title: 'Confirm Action',
                text: 'Clear all access logs?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, proceed',
                cancelButtonText: 'Cancel',
            
            }); 

            if (!confirmDialog.isConfirmed) {

                return;

            }

            try {

                openProcessModal();

                let processor = await fetch('utility/processors/delete-activity-logs.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlenconded'

                    }

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                let msg; // Holds Feeback Message

                if (response.deleted) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Access logs cleared!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'error',
        
                            text: 'Couldn\'t clear access logs!'
        
                        });

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log error to console

                setTimeout(() => {

                    closeProcessModal(); // Disable Process Modal

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                }, 1200);

            }

        });

    }

});

// Joint User Action Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.jointUserMgmt-form');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    // const name = buttonClicked.name;

                    let confirmationMsg = '';

                    switch (action) {

                        case 'RESET': confirmationMsg = 'Are you sure you want to reset transaction count?';

                        break;

                        case 'DELETE': confirmationMsg = 'You\'re about to delete a joint user?';

                        break;

                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMsg,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    await processForm(form, action); // Process Form

                }

            });

        });

        async function processForm(form, action) {
            
            openProcessModal(); // Display Process Modal

            try {

                let formData = new FormData(form); // Get Form Data

                formData.append('action', action);

                let processor = await fetch('utility/processors/joint-user-manager.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                let msg; // Holds Feeback Message

                if (response.reset) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Transaction count reset!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else if (response.deleted) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Record deleted!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else {

                    // Customize Message

                    if (action == 'DELETE') {

                        msg = 'Deletion failed, try again!';

                    } else {

                        msg = 'Reset failed, try again!';

                    }

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'error',
        
                            text: msg
        
                        });

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log error to console

                setTimeout(() => {

                    closeProcessModal(); // Disable Process Modal

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                }, 1200);

            }

        }

    }

});

// Payment Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.pay_form');

    if (forms) {
        forms.forEach(form => {
            form.addEventListener("submit", async (event) => {
                event.preventDefault(); // Prevent form submission

                const buttonClicked = event.submitter; // Get the clicked button
                if (buttonClicked) {
                    const action = buttonClicked.value; //name.toUpperCase(); // Get the action (approve, decline, delete)
                    
                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'APPROVE':
                            confirmationMessage = 'APPROVE: This is irreversible, are you sure?';
                            break;
                        case 'DECLINE':
                            confirmationMessage = 'DECLINE: This is irreversible, are you sure?';
                            break;
                        case 'DELETE':
                            confirmationMessage = 'DELETE: This is irreversible, are you sure?';
                            break;
                    }

                    // // Trigger the confirmation
                    // if (confirmationMessage && !confirm(confirmationMessage)) {
                    //     return;  // If user cancels, stop the submission
                    // }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                        // reverseButtons: true
                    });

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    // Process the form with the corresponding action
                    await processForm(form, action);
                }
            });
        });

        async function processForm(form, action) {
            openProcessModal(); // Show the process modal

            try {
                let formData = new FormData(form); // Collect form data
                formData.append('action', action); // Add action (approve, decline, delete)

                let processor = await fetch('utility/processors/payment-validator.php', {
                    method: 'POST',
                    body: formData
                });

                let response = await processor.json(); // Parse the response

                // Handle the response
                if (response.recordError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Record not found!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else if (response.userError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'User not found!'
        
                        });

                    }, 2000);

                } else if (response.itemError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Item not found!'
        
                        });

                    }, 2000);

                } else {

                    if (response.approved) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Payment approved!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else if (response.declined) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Payment declined!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Payment record deleted!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else {
                        
                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Please, try again!'
            
                            });

                        }, 2000);
                        
                    }
                }
            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    // Feedback

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                }, 1200);
                
            }
        }

    }

}); 

// Deposit Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.deposit_form');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Prevent Submission

                const buttonClicked = event.submitter; // Get the clicked button
                if (buttonClicked) {
                    const action = buttonClicked.value; //name.toUpperCase(); // Get the action (approve, decline, delete)
                    
                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'APPROVE':
                            confirmationMessage = 'APPROVE: This is irreversible, are you sure?';
                            break;
                        case 'DECLINE':
                            confirmationMessage = 'DECLINE: This is irreversible, are you sure?';
                            break;
                        case 'DELETE':
                            confirmationMessage = 'DELETE: This is irreversible, are you sure?';
                            break;
                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                        // reverseButtons: true
                    });

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    // Process the form with the corresponding action
                    await processForm(form, action);
                }

            });

            async function processForm(form, action) {

                openProcessModal(); // Initiate Process Modal

                try {

                    let formData = new FormData(form); // Collect Form Data

                    formData.append('action', action); // Add Action 

                    let processor = await fetch('utility/processors/deposit-validator.php', {

                        method: 'POST',

                        body: formData

                    }); // Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.recordError) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Record not found!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);

                    } else if (response.userError) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'User not found!'
            
                            });

                        }, 2000);

                    } else if (response.accError) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Account not found!'
            
                            });

                        }, 2000);

                    } else {

                        if (response.approved) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Deposit approved!'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else if (response.declined) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Deposit declined!'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Deposit deleted!'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Error!',
                
                                    icon: 'error',
                
                                    text: 'Please, try again!'
                
                                });

                            }, 2000);    

                        }

                    }
 
                } catch (error) {

                    console.error('Error:', error); // Log error to Console

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'An error occurred!'
        
                        });

                    }, 2000);

                }   

            }
            
        });

    }

});

// Loan Request Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.loanReq_form');

    if (forms) {
        forms.forEach(form => {
            form.addEventListener("submit", async (event) => {
                event.preventDefault(); // Prevent form submission

                const buttonClicked = event.submitter; // Get the clicked button
                if (buttonClicked) {
                    const action = buttonClicked.value; //name.toUpperCase(); // Get the action (approve, decline, delete)

                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'APPROVE':
                            confirmationMessage = 'APPROVE: This is irreversible, are you sure?';
                            break;
                        case 'DECLINE':
                            confirmationMessage = 'DECLINE: This is irreversible, are you sure?';
                            break;
                        case 'DELETE':
                            confirmationMessage = 'DELETE: This is irreversible, are you sure?';
                            break;
                    }

                    // Trigger the confirmation
                    if (confirmationMessage && !confirm(confirmationMessage)) {
                        return;  // If user cancels, stop the submission
                    }

                    // Process the form with the corresponding action
                    await processForm(form, action);
                }
            });
        });

        async function processForm(form, action) {
            openProcessModal(); // Show the process modal

            try {
                let formData = new FormData(form); // Collect form data
                formData.append('action', action); // Add action (approve, decline, delete)

                let processor = await fetch('utility/processors/loan-request-validator.php', {
                    method: 'POST',
                    body: formData
                });

                let response = await processor.json(); // Parse the response

                // Handle the response
                if (response.recordError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Record not found!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else if (response.userError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'User not found!'
        
                        });

                    }, 2000);

                } else if (response.accError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Account not found!'
        
                        });

                    }, 2000);

                } else {

                    if (response.approved) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Loan request approved!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else if (response.declined) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Loan request declined!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Loan request deleted!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else {
                        
                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Please, try again!'
            
                            });

                        }, 2000);
                        
                    }
                }
            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    // Feedback

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                }, 1200);
                
            }
        }

    }

});

// Loan Management Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.loanMgmt_form');

    forms.forEach(form => {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            const buttonClicked = event.submitter;

            if (buttonClicked) {

                const confirmDialog = await Swal.fire({
                    title: 'Confirm Action',
                    text: 'You\'re about to delete this loan and all related records, this is irreversible!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, proceed',
                    cancelButtonText: 'Cancel',
                    // reverseButtons: true
                });

                if (!confirmDialog.isConfirmed) {

                    return;

                }

                // Process Form

                try {

                    openProcessModal();

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/loan-delete.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Loan and related records deleted!'
            
                            }).then(() => {

                                window.location.reload();

                            });

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'error',
            
                                text: 'Loan record deletion failed!'
            
                            });

                        }, 2000);

                    }

                } catch (error) {

                    console.error('Error:', error);

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'An error occurred!'
        
                        });

                    }, 2000);

                }

            }

        });

    });

});

// Invoice Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.invoice-mgmt-form');

    forms.forEach(form => {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            const buttonClicked = event.submitter;

            if (buttonClicked) {

                const confirmDialog = await Swal.fire({
                    title: 'Confirm Action',
                    text: 'You\'re about to delete this invoice, this is irreversible!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, proceed',
                    cancelButtonText: 'Cancel',
                    // reverseButtons: true
                });

                if (!confirmDialog.isConfirmed) {

                    return;

                }

                // Process Form

                try {

                    openProcessModal();

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/invoice-delete.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Invoice deleted!'
            
                            }).then(() => {

                                window.location.reload();

                            });

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'error',
            
                                text: 'Invoice deletion failed!'
            
                            });

                        }, 2000);

                    }

                } catch (error) {

                    console.error('Error:', error);

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'An error occurred!'
        
                        });

                    }, 2000);

                }

            }

        });

    });

});

// User Investments Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.user-investment-form');

    forms.forEach(form => {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            const buttonClicked = event.submitter;

            if (buttonClicked) {

                const confirmDialog = await Swal.fire({
                    title: 'Confirm Action',
                    text: 'You\'re about to delete this investment & it\'s related records, this is irreversible!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, proceed',
                    cancelButtonText: 'Cancel',
                    // reverseButtons: true
                });

                if (!confirmDialog.isConfirmed) {

                    return;

                }

                // Process Form

                try {

                    openProcessModal();

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/subscription-delete.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Investment & related records deleted!'
            
                            }).then(() => {

                                window.location.reload();

                            });

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'error',
            
                                text: 'Investment deletion failed!'
            
                            });

                        }, 2000);

                    }

                } catch (error) {

                    console.error('Error:', error);

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'An error occurred!'
        
                        });

                    }, 2000);

                }

            }

        });

    });

});

// Payout Schedule Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.user-payout-form');

    forms.forEach(form => {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            const buttonClicked = event.submitter;

            if (buttonClicked) {

                const confirmDialog = await Swal.fire({
                    title: 'Confirm Action',
                    text: 'You\'re about to delete this payout, this is irreversible!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, proceed',
                    cancelButtonText: 'Cancel',
                    // reverseButtons: true
                });

                if (!confirmDialog.isConfirmed) {

                    return;

                }

                // Process Form

                try {

                    openProcessModal();

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/payout-delete.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Payout deleted!'
            
                            }).then(() => {

                                window.location.reload();

                            });

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'error',
            
                                text: 'Payout deletion failed!'
            
                            });

                        }, 2000);

                    }

                } catch (error) {

                    console.error('Error:', error);

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'An error occurred!'
        
                        });

                    }, 2000);

                }

            }

        });

    });

});

// Edit Payout Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#edit-payout-form');

    let button = document.querySelector('#edit-payout');

    if (form && button) {

        form.addEventListener("submit", async (event) => {
            
            event.preventDefault(); // Stop Submission

            openProcessModal();

            let content = button.innerHTML; // Store Original Content 

            processStart(button);

            // Process Form

            try {

                // Process Form

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/edit-payout-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.updated) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Payout details updated!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                        processEnd(button, content);

                    }, 2000);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',
        
                            icon: 'error',
        
                            text: 'Payout details update failed!'
        
                        });

                        processEnd(button, content);

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',
    
                        icon: 'error',
    
                        text: 'Please, try again!'
    
                    });

                    processEnd(button, content);

                });

            }    

        });

    }

});

// Repayment Schedule Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.user-rpym-form');

    forms.forEach(form => {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            const buttonClicked = event.submitter;

            if (buttonClicked) {

                const confirmDialog = await Swal.fire({
                    title: 'Confirm Action',
                    text: 'You\'re about to delete this repayment, this is not advised!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, proceed',
                    cancelButtonText: 'Cancel',
                    // reverseButtons: true
                });

                if (!confirmDialog.isConfirmed) {

                    return;

                }

                // Process Form

                try {

                    openProcessModal();

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/repayment-delete.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Repayment record deleted!'
            
                            }).then(() => {

                                window.location.reload();

                            });

                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'error',
            
                                text: 'Repayment deletion failed!'
            
                            });

                        }, 2000);

                    }

                } catch (error) {

                    console.error('Error:', error);

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'An error occurred!'
        
                        });

                    }, 2000);

                }

            }

        });

    });

});

// Edit Repayment Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#edit-rpym-form');

    let button = document.querySelector('#edit-rpym');

    if (form && button) {

        form.addEventListener("submit", async (event) => {
            
            event.preventDefault(); // Stop Submission

            openProcessModal();

            let content = button.innerHTML; // Store Original Content 

            processStart(button);

            // Process Form

            try {

                // Process Form

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/edit-repayment-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.updated) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Repayment details updated!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                        processEnd(button, content);

                    }, 2000);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',
        
                            icon: 'error',
        
                            text: 'Repayment details update failed!'
        
                        });

                        processEnd(button, content);

                    }, 2000);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',
    
                        icon: 'error',
    
                        text: 'Please, try again!'
    
                    });

                    processEnd(button, content);

                });

            }    

        });

    }

});

// Virtual Card Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.vCard_form');

    if (forms) {
        forms.forEach(form => {
            form.addEventListener("submit", async (event) => {
                event.preventDefault(); // Prevent form submission

                const buttonClicked = event.submitter; // Get the clicked button
                if (buttonClicked) {
                    const action = buttonClicked.value; //name.toUpperCase(); // Get the action (approve, decline, delete)
                    
                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'ACTIVATE':
                            confirmationMessage = 'ACTIVATE: You\'re about to activate a virtual card';
                            break;
                        case 'DEACTIVATE':
                            confirmationMessage = 'DEACTIVATE: You\'re about to deactivate a virtual card?';
                            break;
                        case 'DELETE':
                            confirmationMessage = 'DELETE: You\'re about to delete a virtual card?';
                            break;
                    }

                    // // Trigger the confirmation
                    // if (confirmationMessage && !confirm(confirmationMessage)) {
                    //     return;  // If user cancels, stop the submission
                    // }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                        // reverseButtons: true
                    });

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    // Process the form with the corresponding action
                    await processForm(form, action);
                }
            });
        });

        async function processForm(form, action) {
            openProcessModal(); // Show the process modal

            try {
                let formData = new FormData(form); // Collect form data
                formData.append('action', action); // Add action (approve, decline, delete)

                let processor = await fetch('utility/processors/virtual-card-validator.php', {
                    method: 'POST',
                    body: formData
                });

                let response = await processor.json(); // Parse the response

                // Handle the response

                if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Virtual card status updated!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);
                    
                } else if (response.deleted) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Virtual card deleted!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);
                    
                } else {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Please, try again!'
        
                        });

                    }, 2000);
                    
                }
                
            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    // Feedback

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                }, 1200);
                
            }
        }

    }

});

// KYC Actions Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.kyc_form');

    if (forms) {
        forms.forEach(form => {
            form.addEventListener("submit", async (event) => {
                event.preventDefault(); // Prevent form submission

                const buttonClicked = event.submitter; // Get the clicked button
                if (buttonClicked) {
                    const action = buttonClicked.value; //name.toUpperCase(); // Get the action (approve, decline, delete)
                    
                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'APPROVE':
                            confirmationMessage = 'You\'re about to approve a KYC request, proceed?';
                            break;
                        case 'DECLINE':
                            confirmationMessage = 'You\'re about to decline a KYC request, proceed?';
                            break;
                        case 'DELETE':
                            confirmationMessage = 'DELETE: This is irreversible, are you sure?';
                            break;
                    }

                    // // Trigger the confirmation
                    // if (confirmationMessage && !confirm(confirmationMessage)) {
                    //     return;  // If user cancels, stop the submission
                    // }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                        // reverseButtons: true
                    });

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    // Process the form with the corresponding action
                    await processForm(form, action);
                }
            });
        });

        async function processForm(form, action) {
            openProcessModal(); // Show the process modal

            try {
                let formData = new FormData(form); // Collect form data
                formData.append('action', action); // Add action (approve, decline, delete)

                let processor = await fetch('utility/processors/kyc-validator.php', {
                    method: 'POST',
                    body: formData
                });

                let response = await processor.json(); // Parse the response

                // Handle the response
                if (response.userError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'User not found!'
        
                        });

                    }, 2000);

                } else {

                    if (response.approved) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'KYC verified!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else if (response.declined) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'KYC recjected!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'KYC Rejected!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else {
                        
                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Please, try again!'
            
                            });

                        }, 2000);
                        
                    }
                }
            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    // Feedback

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                }, 1200);
                
            }
        }

    }

}); 

// Payment Resource Action Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.payResource_form');

    if (forms) {
        forms.forEach(form => {
            form.addEventListener("submit", async (event) => {
                event.preventDefault(); // Prevent form submission

                const buttonClicked = event.submitter; // Get the clicked button
                if (buttonClicked) {
                    const action = buttonClicked.value; //name.toUpperCase(); // Get the action (approve, decline, delete)
                    
                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'DELETE':
                            confirmationMessage = 'DELETE: You\'re about to delete a payment resource';
                        break;
                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Proceed?',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                        // reverseButtons: true
                    });

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    // Process the form with the corresponding action
                    await processForm(form, action);
                }
            });
        });

        async function processForm(form, action) {
            openProcessModal(); // Show the process modal

            try {
                let formData = new FormData(form); // Collect form data
                formData.append('action', action); // Add action (approve, decline, delete)

                let processor = await fetch('utility/processors/pay-resource-validator.php', {
                    method: 'POST',
                    body: formData
                });

                let response = await processor.json(); // Parse the response

                // Handle the response

                if (response.deleted) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Attention!',
        
                            icon: 'success',
        
                            text: 'Payment resource deleted!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);
                    
                } else {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Please, try again!'
        
                        });

                    }, 2000);
                    
                }
                
            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    // Feedback

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                }, 1200);
                
            }
        }

    }

});

// User Creation Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#addUserForm');

    let button = document.querySelector('#addUser');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            openProcessModal(); // Open Processing Modal

            let content = button.innerHTML;

            processStart(button); // Disable User Interaction

            try {

                // Process Form

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/create-user-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.typeEmpty) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Processing Modal
    
                        processEnd(button, content); // Enable User Interaction
    
                        // Feedback
    
                        new swal({
    
                            title: 'Attention!',
    
                            text: 'Please, specify account type!',
    
                            icon: 'error'
    
                        });
    
                    }, 2000);    

                } else if (response.currEmpty) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Processing Modal
    
                        processEnd(button, content); // Enable User Interaction
    
                        // Feedback
    
                        new swal({
    
                            title: 'Attention!',
    
                            text: 'Please, specify account currency!',
    
                            icon: 'error'
    
                        });
    
                    }, 2000);

                } else if (response.emailError) {

                    setTimeout(() => {

                        closeProcessModal(); // Close Processing Modal
    
                        processEnd(button, content); // Enable User Interaction
    
                        // Feedback
    
                        new swal({
    
                            title: 'Attention!',
    
                            text: 'Email address already in use!',
    
                            icon: 'error'
    
                        });
    
                    }, 2000);

                } else {

                    if (response.userAdded) {

                        let loc = `user-details?id=${response.id}`;

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal
        
                            processEnd(button, content); // Enable User Interaction
        
                            // Feedback

                            Swal.fire({

                                icon: 'info',

                                title: 'Attention!',

                                text: 'This is a partial registration, the user will be required to complete the registration on login. Would you like to complete the registration?',

                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Yes, Proceed!"

                            }).then((result) => {

                                if (result.isConfirmed) {

                                    loc = `complete-registration?id=${response.id}`;

                                    window.location.href = loc;

                                } else {

                                    new swal({
        
                                        title: 'Attention!',
                
                                        text: 'New user added (Partial Registration)!',
                
                                        icon: 'success'
                
                                    }).then(() => {

                                        window.location.href = loc;

                                    });
        
                                    
                                }

                            });
        
                        
                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal
        
                            processEnd(button, content); // Enable User Interaction
        
                            // Feedback
        
                            new swal({
        
                                title: 'Error!',
        
                                text: 'Please, try again!',
        
                                icon: 'error'
        
                            });
        
                        }, 2000);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    processEnd(button, content); // Enable User Interaction

                    // Feedback

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                }, 1200);

            }

        });

    }

});

// Finalize User Creation Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#finalizeRegForm');

    let button = document.querySelector('#finalize-reg');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            openProcessModal(); // Open Processing Modal

            let content = button.innerHTML;

            processStart(button); // Disable User Interaction

            try {

                // Process Form

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/finalize-user-creation.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.tPinError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Transaction PIN must be a 6-digit number',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                } else {

                    if (response.finalized) {

                        let loc = `user-details?id=${response.id}`;

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal

                            new swal({
        
                                title: 'Attention!',
        
                                text: 'User registration finalized!',
        
                                icon: 'success'
        
                            }).then(() => {

                                window.location.href = loc;

                            });
        
                            processEnd(button, content); // Enable User Interaction
        
                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal
        
                            processEnd(button, content); // Enable User Interaction
        
                            // Feedback
        
                            new swal({
        
                                title: 'Error!',
        
                                text: 'Please, try again!',
        
                                icon: 'error'
        
                            });
        
                        }, 2000);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    processEnd(button, content); // Enable User Interaction

                    // Feedback

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                }, 1200);

            }

        });

    }

});

// Add Joint User Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#addJointUserForm');

    let button = document.querySelector('#addJointUser');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            openProcessModal(); // Open Processing Modal

            let content = button.innerHTML;

            processStart(button); // Disable User Interaction

            let gender = form.querySelector('select[name="gender"]');

            let status = form.querySelector('select[name="acc-status"]');

            // Validate Fields

            if (gender.value == 0) {

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    processEnd(button, content); // Enable User Interaction

                    // Feedback

                    new swal({

                        title: 'Attention!',

                        text: 'Please, specify gender!',

                        icon: 'error'

                    });

                    gender.focus();

                }, 1200);    

            } else if (status.value == 0) {

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    processEnd(button, content); // Enable User Interaction

                    // Feedback

                    new swal({

                        title: 'Attention!',

                        text: 'Please, specify account status!',

                        icon: 'error'

                    });

                    status.focus();

                }, 1200);

            } else {

                try {

                    // Process Form

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/add-joint-user.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.emailTaken) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal
        
                            processEnd(button, content); // Enable User Interaction
        
                            // Feedback
        
                            new swal({
        
                                title: 'Attention!',
        
                                text: 'Email address already in use!',
        
                                icon: 'error'
        
                            });
        
                        }, 2000);

                    } else {

                        if (response.added) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Processing Modal
            
                                processEnd(button, content); // Enable User Interaction
            
                                // Feedback
            
                                new swal({
            
                                    title: 'Attention!',
            
                                    text: 'Joint user added!',
            
                                    icon: 'success'
            
                                }).then(() => {

                                    window.location.reload();

                                });
            
                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Processing Modal
            
                                processEnd(button, content); // Enable User Interaction
            
                                // Feedback
            
                                new swal({
            
                                    title: 'Error!',
            
                                    text: 'Please, try again!',
            
                                    icon: 'error'
            
                                });
            
                            }, 2000);

                        }

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error To Console

                    setTimeout(() => {

                        closeProcessModal(); // Close Processing Modal

                        processEnd(button, content); // Enable User Interaction

                        // Feedback

                        new swal({

                            title: 'Error!',

                            text: 'An error occurred!',

                            icon: 'error'

                        });

                    }, 1200);

                }

            }

        });

    }

});

// Edit Joint User Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#editJointUserForm');

    let button = document.querySelector('#editJointUser');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            openProcessModal(); // Open Processing Modal

            let content = button.innerHTML;

            processStart(button); // Disable User Interaction

            let gender = form.querySelector('select[name="gender"]');

            let status = form.querySelector('select[name="acc-status"]');

            // Validate Fields

            if (gender.value == 0) {

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    processEnd(button, content); // Enable User Interaction

                    // Feedback

                    new swal({

                        title: 'Attention!',

                        text: 'Please, specify gender!',

                        icon: 'error'

                    });

                    gender.focus();

                }, 1200);    

            } else if (status.value == 0) {

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    processEnd(button, content); // Enable User Interaction

                    // Feedback

                    new swal({

                        title: 'Attention!',

                        text: 'Please, specify account status!',

                        icon: 'error'

                    });

                    status.focus();

                }, 1200);

            } else {

                try {

                    // Process Form

                    let formData = new FormData(form); // Collect Form Data

                    let processor = await fetch('utility/processors/edit-joint-user.php', {

                        method: 'POST',

                        body: formData

                    }); // Processor Credentials

                    let response = await processor.json(); // Parse JSON Response

                    // Handle Response

                    if (response.invalidUser) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal
        
                            processEnd(button, content); // Enable User Interaction
        
                            // Feedback
        
                            new swal({
        
                                title: 'Attention!',
        
                                text: 'Joint user not found!',
        
                                icon: 'error'
        
                            }).then(() => {

                                window.location.reload();

                            });
        
                        }, 2000);

                    } else if (response.invalidEmail) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal
        
                            processEnd(button, content); // Enable User Interaction
        
                            // Feedback
        
                            new swal({
        
                                title: 'Attention!',
        
                                text: 'E-mail! address already in use!',
        
                                icon: 'warning'
        
                            }).then(() => {

                                window.location.reload();

                            });
        
                        }, 2000);

                    } else if (response.edited) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal
        
                            processEnd(button, content); // Enable User Interaction
        
                            // Feedback
        
                            new swal({
        
                                title: 'Attention!',
        
                                text: 'Joint user edited!',
        
                                icon: 'success'
        
                            }).then(() => {

                                window.location.reload();

                            });
        
                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Close Processing Modal
        
                            processEnd(button, content); // Enable User Interaction
        
                            // Feedback
        
                            new swal({
        
                                title: 'Error!',
        
                                text: 'Please, try again!',
        
                                icon: 'error'
        
                            });
        
                        }, 2000);

                    }

                } catch (error) {

                    console.error('Error:', error); // Log Error To Console

                    setTimeout(() => {

                        closeProcessModal(); // Close Processing Modal

                        processEnd(button, content); // Enable User Interaction

                        // Feedback

                        new swal({

                            title: 'Error!',

                            text: 'An error occurred!',

                            icon: 'error'

                        });

                    }, 1200);

                }

            }

        });

    }

});

// Update Virtual Card Balance Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#cardBalForm');

    let button = document.querySelector('#cardBalBtn');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button); // Prevent User Interaction

            // Process Form

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/vcard-balance-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.refresh) {

                    window.location.reload();

                    return;

                } else {


                    if (response.balUpdated) {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({
        
                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Card balance updated.'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });
        
                            processEnd(button, content);
        
                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({
        
                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'An error occurred.'
            
                            });
        
                            processEnd(button, content);
        
                        }, 2000);

                    }

                }

            } catch (error) {

                console.error('Error', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',
    
                        icon: 'error',
    
                        text: 'Please, try again!'
    
                    });

                    processEnd(button, content);

                }, 2000);

            }  

        });

    }

});

// Add Pay Resource Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#pay-resource-form');

    let button = document.querySelector('#addResource');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/add-pay-resource.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.typeError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Please specify \'TYPE\'',

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else if (response.credError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Please specify \'CREDENTIAL\'',

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else if (response.symbError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Please specify crypto symbol',

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else if (response.qrError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'QR code is required',

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else if (response.uploadError) {

                    const msg = response.msg;

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: msg,

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else {

                    if (response.created) {

                        setTimeout(() => {
        
                            new swal({

                                title: 'Attention!',

                                text: 'New payment channel created.',

                                icon: 'success'

                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                            closeProcessModal();

                            processEnd(button, content);

                        }, 2000)

                    } else {

                        setTimeout(() => {
        
                            new swal({

                                title: 'Error!',

                                text: 'An error occurred. Please, try again.',

                                icon: 'error'

                            });

                            closeProcessModal();

                            processEnd(button, content);

                        }, 2000)

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }


        });

    }

});

// Edit Pay Resource Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#editResource-form');

    let button = document.querySelector('#editResource');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/edit-resource.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.credError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Please specify \'CREDENTIAL\'',

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else if (response.symbError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Please specify crypto symbol',

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else if (response.qrError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'QR code is required',

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else if (response.uploadError) {

                    const msg = response.msg;

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: msg,

                            icon: 'info'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else {

                    if (response.edited) {

                        setTimeout(() => {
        
                            new swal({

                                title: 'Attention!',

                                text: 'Payment resource edited.',

                                icon: 'success'

                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                            closeProcessModal();

                            processEnd(button, content);

                        }, 2000)

                    } else {

                        setTimeout(() => {
        
                            new swal({

                                title: 'Error!',

                                text: 'An error occurred. Please, try again.',

                                icon: 'error'

                            });

                            closeProcessModal();

                            processEnd(button, content);

                        }, 2000)

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }


        });

    }

});

// Add Bank Resource Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#bank-resource-form');

    let button = document.querySelector('#bankResource');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/add-bank-resource.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.cntryError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Please specify country',

                            icon: 'warning'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else {

                    if (response.created) {

                        setTimeout(() => {
        
                            new swal({

                                title: 'Attention!',

                                text: 'Bank account created.',

                                icon: 'success'

                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                            closeProcessModal();

                            processEnd(button, content);

                        }, 2000)

                    } else {

                        setTimeout(() => {
        
                            new swal({

                                title: 'Error!',

                                text: 'An error occurred. Please, try again.',

                                icon: 'error'

                            });

                            closeProcessModal();

                            processEnd(button, content);

                        }, 2000)

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }


        });

    }

});

// Edit Bank Resource Handler 

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#editBank-form');

    let button = document.querySelector('#editResource');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Prevent Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/edit-bank-resource.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.cntryError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Please specify country',

                            icon: 'warning'

                        });

                        closeProcessModal();

                        processEnd(button, content);

                    }, 2000)

                } else {

                    if (response.edited) {

                        setTimeout(() => {
        
                            new swal({

                                title: 'Attention!',

                                text: 'Bank account edited.',

                                icon: 'success'

                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                            closeProcessModal();

                            processEnd(button, content);

                        }, 2000)

                    } else {

                        setTimeout(() => {
        
                            new swal({

                                title: 'Error!',

                                text: 'An error occurred. Please, try again.',

                                icon: 'error'

                            });

                            closeProcessModal();

                            processEnd(button, content);

                        }, 2000)

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }


        });

    }

});

// Add New Bank Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#newBankForm');

    let button = document.querySelector('#addBank');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            try {

                let formData = new FormData(form);

                let processor = await fetch('utility/processors/add-bank-processor.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json();

                if (response.cntryError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error',

                            text: 'Please specify COUNTRY or set as DEFAULT',

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else if (response.uploadError) {

                    let msg = `BANK LOGO: ${response.message}`;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error',

                            text: msg,

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else if (response.typeError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error',

                            text: 'Please specify CODE TYPE',

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else if (response.codeError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error',

                            text: 'Please input CODE',

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else {

                    if (response.bankAdded) {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                title: 'Attention!',
    
                                text: 'New Bank Added!',
    
                                icon: 'success'
    
                            }).then(()=>{

                                window.location.reload();

                                return;

                            });
    
                            processEnd(button, content);
    
                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                title: 'Error',
    
                                text: 'Please, try again.',
    
                                icon: 'error'
    
                            });
    
                            processEnd(button, content);
    
                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error);

                setTimeout(() => {

                    closeProcessModal();

                    processEnd(button, content);

                    new swal({

                        title: 'Error',

                        text: 'An error occurred',

                        icon: 'error',

                    });

                }, 1200);

            }

        });

    }

});

// Edit Bank Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#editBankForm');

    let button = document.querySelector('#editBank');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            try {

                let formData = new FormData(form);

                let processor = await fetch('utility/processors/edit-bank-processor.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json();

                if (response.cntryError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error',

                            text: 'Please specify COUNTRY or set as DEFAULT',

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else if (response.uploadError) {

                    let msg = `BANK LOGO: ${response.message}`;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error',

                            text: msg,

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else if (response.typeError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error',

                            text: 'Please specify CODE TYPE',

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else if (response.codeError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error',

                            text: 'Please input CODE',

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else {

                    if (response.bankEdited) {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                title: 'Attention!',
    
                                text: 'Bank edited!',
    
                                icon: 'success'
    
                            }).then(()=>{

                                window.location.reload();

                                return;

                            });
    
                            processEnd(button, content);
    
                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                title: 'Error',
    
                                text: 'Please, try again.',
    
                                icon: 'error'
    
                            });
    
                            processEnd(button, content);
    
                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error);

                setTimeout(() => {

                    closeProcessModal();

                    processEnd(button, content);

                    new swal({

                        title: 'Error',

                        text: 'An error occurred',

                        icon: 'error',

                    });

                }, 1200);

            }

        });

    }

});

// Create Virtual Card Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#cardForm');

    let button = document.querySelector('#addCard');

    if (form && button) {

        let randomizer = form.querySelector('#radomize-color');

        let custom = form.querySelector('#card-color');

        if (randomizer && custom) {

            if (randomizer.checked) {

                custom.disabled = true;

            }

            randomizer.addEventListener('change', () => {

                custom.disabled = randomizer.checked;

            })

        }

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            // Process Form

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/create-vcard-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Credentials
                
                
                let response = await processor.json(); // Parse JSON Response
                
                if (response.userError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error!',

                            text: 'User not found!',

                            icon: 'error'

                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else {

                    if (response.created) {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({
    
                                title: 'Attention!',
    
                                text: 'Virtual card created!',
    
                                icon: 'success'
    
                            }).then(() => {
    
                                window.location.reload();
    
                                return;
    
                            });
    
                        }, 2000);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();

                            processEnd(button, content);
        
                            new swal({
        
                                title: 'Attention!',
        
                                text: 'Please try again.',
        
                                icon: 'error'
        
                            });
        
                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error);

                setTimeout(() => {

                    closeProcessModal();

                    processEnd(button, content);

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred.',

                        icon: 'error'

                    });

                }, 1200);

            }

        });

    }

});

// Edit Virtual Card Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#cardPropForm');

    let button = document.querySelector('#editCard');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            // Process Form

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/edit-vcard-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Credentials
                
                
                let response = await processor.json(); // Parse JSON Response
                
                if (response.edited) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Virtual card edited!',

                            icon: 'success'

                        }).then(() => {

                            window.history.go(-1);

                            return;

                        });

                    }, 2000);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        processEnd(button, content);
    
                        new swal({
    
                            title: 'Attention!',
    
                            text: 'Please try again.',
    
                            icon: 'error'
    
                        });
    
                    }, 1200);

                }


            } catch (error) {

                console.error('Error:', error);

                setTimeout(() => {

                    closeProcessModal();

                    processEnd(button, content);

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred.',

                        icon: 'error'

                    });

                }, 1200);

            }

        });

    }

});

// Add Investment Plan Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#planForm');

    let button = document.querySelector('#addPlan');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button); // Deny Interaction

            // Process Form

            try {

                let formData =  new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/add-investment-plan.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.fieldError) {

                    let msg = response.message;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: msg

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else if (response.maxError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: 'Min can\'t be greater than Max'

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else if (response.factorError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: 'Payout frequency not found'

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else if (response.uploadFailure) {

                    let msg = response.message;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: msg

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else {

                    if (response.added) {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                icon: 'success',
    
                                title: 'Attention!',
    
                                text: 'Investment plan added!'
    
                            }).then(() => {

                                window.location.reload();

                                return;

                            });
    
                            processEnd(button, content); // Restore Interaction Privileges
    
                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                icon: 'error',
    
                                title: 'Attention!',
    
                                text: 'An error occurred. Please try again!'
    
                            });
    
                            processEnd(button, content); // Restore Interaction Privileges
    
                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({ // Feedback

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                    processEnd(button, content); // Restore Privileges

                }, 1200);

            }

        });

    }

});

// Edit Investment Plan Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#editPlanForm');

    let button = document.querySelector('#editPlan');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button); // Deny Interaction

            // Process Form

            try {

                let formData =  new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/edit-investment-plan.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.fieldError) {

                    let msg = response.message;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: msg

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else if (response.maxError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: 'Min can\'t be greater than Max'

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else if (response.factorError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: 'Payout frequency not found'

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else if (response.uploadFailure) {

                    let msg = response.message;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: msg

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else {

                    if (response.edited) {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                icon: 'success',
    
                                title: 'Attention!',
    
                                text: 'Investment plan edited!'
    
                            }).then(() => {

                                window.location.reload();

                                return;

                            });
    
                            processEnd(button, content); // Restore Interaction Privileges
    
                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                icon: 'error',
    
                                title: 'Attention!',
    
                                text: 'An error occurred. Please try again!'
    
                            });
    
                            processEnd(button, content); // Restore Interaction Privileges
    
                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({ // Feedback

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                    processEnd(button, content); // Restore Privileges

                }, 1200);

            }

        });

    }

});

// Set Withdrawal Limit Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#wth-limit-form');

    let button = document.querySelector('#set-wth-limit');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button); // Deny Interaction

            // Process Form

            try {

                let formData =  new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/set-withdrawal-limit.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.added) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'success',

                            title: 'Attention!',

                            text: 'Withdrawal limit  set!'

                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Attention!',

                            text: 'An error occurred. Please try again!'

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({ // Feedback

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                    processEnd(button, content); // Restore Privileges

                }, 1200);

            }

        });

    }

});


// Add Timing Factor Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#timeForm');

    let button = document.querySelector('#addTime');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            // Process Form

            try {

                let formData = new FormData(form);

                let processor = await fetch('utility/processors/add-timing-factor.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json();

                if (response.created) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            icon: 'success',

                            text: 'Timing factor added!'

                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 1200);

                } else {

                    let message = response.msg;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Warning!',

                            icon: 'warning',

                            text: message

                        });

                        processEnd(button, content);

                    }, 1200);

                }

            } catch (error) {
            
                console.error('Error:', error);

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }

        });  

    }

});

// Edit Transactions Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#transcForm');

    let button = document.querySelector('#edit-transc');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Cancel Submission

            openProcessModal();

            let content = button.innerHTML;

            processStart(button); // Deny Interaction

            // Process Form

            try {

                let formData =  new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/edit-transaction-processor.php', {

                    method: 'POST',

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.fieldError) {

                    let msg = response.message;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: msg

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else if (response.userError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: 'User not found!'

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else if (response.accError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            icon: 'error',

                            title: 'Error!',

                            text: 'User account/currency invalid'

                        });

                        processEnd(button, content); // Restore Interaction Privileges

                    }, 1200);

                } else {

                    if (response.edited) {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                icon: 'success',
    
                                title: 'Attention!',
    
                                text: 'Transaction edited!'
    
                            }).then(() => {

                                window.location.reload();

                                return;

                            });
    
                            processEnd(button, content); // Restore Interaction Privileges
    
                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();
    
                            new swal({
    
                                icon: 'error',
    
                                title: 'Attention!',
    
                                text: 'Transacion edit failed!'
    
                            });
    
                            processEnd(button, content); // Restore Interaction Privileges
    
                        }, 1200);

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({ // Feedback

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                    processEnd(button, content); // Restore Privileges

                }, 1200);

            }

        });

    }

});

// Create New Account Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#add-acc-Form');

    let button = document.querySelector('#add-acc');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            // Process Form

            try {

                let formData = new FormData(form);

                let processor = await fetch('utility/processors/create-new-account-processor.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json();

                if (response.accExists) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error!',

                            text: `${response.currency} account already exists!`,

                            icon: 'warning'

                        });

                        processEnd(button, content);

                    }, 1200);


                } else {

                    if (response.added) {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Attention!',

                                icon: 'success',

                                text: 'Account created!'

                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Attention!',

                                icon: 'error',

                                text: 'An error occurred, couldn\'t create account'

                            });

                        }, 1200);

                    }

                }    

            } catch (error) {
            
                console.error('Error:', error);

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }

        });  

    }

});

// Edit Account Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#edit-acc-Form');

    let button = document.querySelector('#edit-acc');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            // Process Form

            try {

                let formData = new FormData(form);

                let processor = await fetch('utility/processors/edit-account-processor.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json();

                if (response.refresh) {

                    window.location.reload();

                } else if (response.accExists) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Error!',

                            text: `${response.currency} account already exists!`,

                            icon: 'warning'

                        });

                        processEnd(button, content);

                    }, 1200);


                } else {

                    if (response.updated) {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Attention!',

                                icon: 'success',

                                text: 'Account edited!'

                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Attention!',

                                icon: 'error',

                                text: 'An error occurred, couldn\'t edit account'

                            });

                        }, 1200);

                    }

                }    

            } catch (error) {
            
                console.error('Error:', error);

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }

        });  

    }

});


// Update Admin Data Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#formAdminData');

    let button = document.querySelector('#updateAdminData');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            // Process Form

            try {

                let formData = new FormData(form);

                let processor = await fetch('utility/processors/admin-data-update.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response
            
                if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Data successfully updated!',

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                    }, 1200);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Update failed!',

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'Please, try again!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }

        });

    }

});

// Update Admin Password Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#formAdminPwrd');

    let button = document.querySelector('#resetAdminPwrd');

    if (form && button) {

        let pwrd = form.querySelector('input[name="pwrd"]');

        let cPwrd = form.querySelector('input[name="confirm-pwrd"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            // Validate Pwrd Fields

            if (pwrd.value.length < 8) {

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Attention!',

                        text: 'Password must be at least 8 characters long!',

                        icon: 'warning'

                    });

                    processEnd(button, content);

                }, 1200);

            } else {

                if (pwrd.value != cPwrd.value) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Password mismatch!',

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                } else {

                    // Process Form

                    try {

                        let formData = new FormData(form);

                        let processor = await fetch('utility/processors/admin-pwrd-reset.php', {

                            method: 'POST',

                            body: formData

                        });

                        let response = await processor.json();

                        if (response.invalidPwrd) {

                            setTimeout(() => {

                                closeProcessModal();

                                new swal({

                                    title: 'Attention!',

                                    text: 'Invalid password!',

                                    icon: 'error'

                                });

                                processEnd(button, content);

                            }, 1200);

                        } else {

                            if (response.updated) {

                                setTimeout(() => {

                                    closeProcessModal();

                                    new swal({

                                        title: 'Attention!',

                                        text: 'Password updated!',

                                        icon: 'success'

                                    }).then(() => {

                                        window.location.reload();

                                    });

                                }, 1200);

                            } else {

                                setTimeout(() => {

                                    closeProcessModal();

                                    new swal({

                                        title: 'Attention!',

                                        text: 'Password update failed!',

                                        icon: 'error'

                                    });

                                    processEnd(button, content);

                                }, 1200);

                            }

                        }

                    } catch (error) {

                        console.error('Error:', error); // LOg Error To Console

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Error!',

                                text: 'Please, try again!',

                                icon: 'error'

                            });

                            processEnd(button, content);

                        }, 1200);

                    }

                }

            }    

        });

    }

});

// Support Chat Systems

document.addEventListener("DOMContentLoaded", () => {

    chatScroll();

    function chatScroll() {

        let chatWindow = document.querySelector('#chatSection');

        if (chatWindow) {

            chatWindow.scrollTop = chatWindow.scrollHeight;

        }

    }

    let form = document.querySelector('#chatForm');

    let send = document.querySelector('#sendMsg');

    if (form && send) {

        // Send Message

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            send.disabled = true; // Disable Button

            let msg = form.querySelector('textarea[name="reply"]');

            msg.disabled = true; 

            // Process Form

            try {

                let formData = new FormData(form); // Collect Form Data

                formData.append('reply', msg.value);

                let processor = await fetch('utility/processors/send-message.php', {

                    method: 'POST', 

                    body: formData

                }); // Processor Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.noTcket) {

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'Support ticket not found!'

                    }).then(() => {

                        window.location.reload();

                    });

                } else {

                    if (response.sent) {

                        updateChat(msg);

                    } else {

                        new swal({

                            title: 'Attetion!',

                            icon: 'error',

                            text: 'Message not sent, try again!'

                        });

                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                new swal({

                    title: 'Error!',

                    text: 'An error occurred!',

                    icon: 'error'

                });

            } finally {

                send.disabled = false;

                msg.disabled = false;

            }

            function updateChat(field) {

                let chatWindow = document.querySelector('#chatSection');

                if (field && chatWindow) {

                    let msg = document.createElement('div');

                    msg.className = 'card p-3 w-auto my-1 bg-dark text-light ml-auto';

                    msg.style.maxWidth = '450px';

                    msg.innerHTML = `<p>${field.value}</p>

                    <p class="text-right"><small>Now</small></p>`;
                    
                    field.value = "";

                    chatWindow.appendChild(msg);

                    chatWindow.scrollTop = chatWindow.scrollHeight;

                }

            }

        });

    }

});

// Create Notification Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#create-notf-form');

    let button = document.querySelector('#createNotf');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Hold Original Content

            openProcessModal(); // Display Processing Modal

            processStart(button);

            // Commence Processing

            try {

                let formData = new FormData(form); // Collect Form Data

                let processor = await fetch('utility/processors/create-notification.php', {

                    method: 'POST',

                    body: formData

                }); // Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.userError) {

                    setTimeout(() => {

                        closeProcessModal(); // Terminate Processing Modal

                        new swal({

                            title: 'Attention!',

                            text: 'User not found!',

                            icon: 'warning'

                        }).then(() => {

                            window.location.reload();

                        });

                    }, 1200);

                } else {

                    if (response.created) {

                        setTimeout(() => {

                            closeProcessModal(); // Terminate Processing Modal

                            new swal({

                                title: 'Attention!',

                                text: 'Notification creation success!',

                                icon: 'success'

                            }).then(() => {

                                window.location.reload();

                            });

                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal(); // Terminate Processing Modal

                            new swal({

                                title: 'Attention!',

                                text: 'Notification creation failure!',

                                icon: 'error'

                            });

                            processEnd(button, content);

                        }, 1200);

                    }

                }    

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal(); // Terminate Processing Modal

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred, please try again!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }

        });

    }

});

// Edit User Details Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#form-user-details');

    let button = document.querySelector('#update-user-details');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            let content = button.innerHTML; // Hold Button's Original Content

            openProcessModal(); // Display Processing Modal

            processStart(button); // Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/update-user-details.php', {

                    method: 'POST',

                    body: formData

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.emailError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Email already in use!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                } else if (response.updated) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'User\'s details updated!',

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                        processEnd(button, content); // End Loading Sequence

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                } else {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'User\'s detail update failed!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                    closeProcessModal(); // Terminate Processing Modal

                }, 1200);

            }

        });

    }

});

// Edit User Banking Details Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#form-banking-details');

    let button = document.querySelector('#update-banking-details');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            openProcessModal();

            let content = button.innerHTML; // Hold Original Content

            processStart(button); // Start Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/update-banking-details.php', {

                    method: 'POST',

                    body: formData

                }); // Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.userError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Warning!',

                            text: 'User not found!',

                            icon: 'error'

                        }).then(() => {

                            window.location.reload();

                        });

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                } else if (response.invalidTag) {

                    setTimeout(() => {

                        new swal({

                            title: 'Username Invalid!',

                            text: `Username can't contain: ${response.invalidChars}`,

                            icon: 'warning'

                        });

                        processEnd(button, content); // End Loading Sequence

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                } else if (response.lengthError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Username must be at least 3 characters long!',

                            icon: 'warning'

                        });

                        processEnd(button, content); // End Loading Sequence

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                } else if (response.tagExists) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Username already use!',

                            icon: 'warning'

                        });

                        processEnd(button, content); // End Loading Sequence

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                } else if (response.tPinError) {

                    setTimeout(() => {

                        new swal({

                            title: 'Attention!',

                            text: 'Transaction PIN must be a 6-digit number',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                        closeProcessModal(); // Terminate Processing Modal

                    }, 1200);

                } else { 
                    
                    if (response.updated) {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Attention!',

                                text: 'Banking details updated!',

                                icon: 'success'

                            }).then(() => {

                                window.location.reload();

                            });

                            processEnd(button, content); // End Loading Sequence

                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Attention!',

                                text: 'Banking details update failed!',

                                icon: 'error'

                            });

                            processEnd(button, content); // End Loading Sequence

                        }, 1200);


                    }

                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Edit User Security Details Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#form-security-details');

    let button = document.querySelector('#update-security-details');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            openProcessModal();

            let content = button.innerHTML; // Hold Original Content

            processStart(button); // Start Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/update-security-details.php', {

                    method: 'POST',

                    body: formData

                }); // Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response
                    
                if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Security details updated!',

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Security details update failed!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);


                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Edit User Miscellanous Details Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#form-misc-details');

    let button = document.querySelector('#update-misc-details');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            openProcessModal();

            let content = button.innerHTML; // Hold Original Content

            processStart(button); // Start Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/update-misc-details.php', {

                    method: 'POST',

                    body: formData

                }); // Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response
                    
                if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Miscellanous details updated!',

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Miscellanous details update failed!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);


                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Set User's Avatar Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#update-pfp-form');

    let button = document.querySelector('#updatePfp');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            openProcessModal();

            let content = button.innerHTML; // Hold Original Content

            processStart(button); // Start Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/update-user-avatar.php', {

                    method: 'POST',

                    body: formData

                }); // Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.uploadFail) {

                    let message = response.error;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: message,

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'User\'s avatar updated!',

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'User\'s avatar update failure!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);


                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Add Country to Accesslist Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#access-country-form');

    let button = document.querySelector('#add-access-country');

    if (form && button) {

        let field = form.querySelector('select[name="country-code"]')

        form.addEventListener("submit", async (event) => {

            event.preventDefault();

            openProcessModal();

            let content = button.innerHTML;

            processStart(button);

            // Validate Field

            if (field.value == 0) {

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Attention!',

                        text: 'Please, select country!',

                        icon: 'warning'

                    });

                    processEnd(button, content);

                }, 1200);

                return; // End Run

            }

            // Process Form

            try {

                let formData = new FormData(form);

                let processor = await fetch('utility/processors/update-location-accesslist.php', {

                    method: 'POST',

                    body: formData

                });

                let response = await processor.json(); // Parse JSON Response

                // Handle Response
            
                if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Country added successfully!',

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                    }, 1200);

                } else {

                    let msg = response.error;

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: `Action failure. ${msg}`,

                            icon: 'error'

                        });

                        processEnd(button, content);

                    }, 1200);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error to Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'Please, try again!',

                        icon: 'error'

                    });

                    processEnd(button, content);

                }, 1200);

            }

        });

    }

});

// Remove Country (Access List Manager)

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.country-accesslist-mgmt');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: 'Are you sure you want to delete this country?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    openProcessModal(); // Display Process Modal

                    try {

                        let formData = new FormData(form); // Get Form Data

                        let processor = await fetch('utility/processors/delete-country-accesslist.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Country deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: 'Deletion failed!'
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }

            });

        });

    }

});

// Remove Timing Factor

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.timing-mgmt-form');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: 'Are you sure you want to delete this timing factor?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    openProcessModal(); // Display Process Modal

                    try {

                        let formData = new FormData(form); // Get Form Data

                        let processor = await fetch('utility/processors/delete-timing-factor.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Subscription timing factor deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: 'Deletion failed!'
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }

            });

        });

    }

});

// Request Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.request-mgmt-form');

    if (forms) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    let confirmationMessage = '';
                    switch (action) {
                        case 'DECLINE':
                            confirmationMessage = 'You sure you want to decline this request?';
                        break;
                        case 'DELETE':
                            confirmationMessage = 'You sure you want to delete this request?';
                        break;
                        case 'APPROVE':
                            confirmationMessage = 'You about to approve this request?';
                        break;
                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    await processForm(form, action);  

                }

                async function processForm(form, action) {
                    
                    openProcessModal(); // Display Process Modal

                    try {
                    
                        

                        let formData = new FormData(form); // Get Form Data

                        formData.append('action', action);

                        let processor = await fetch('utility/processors/account-request-processor.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        if (response.recordError) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'warning',
                
                                    text: 'Record not found!'
                
                                });

                            }, 2000);

                        } else if (response.userError) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'warning',
                
                                    text: 'User not found!'
                
                                });

                            }, 2000);

                        } else if (response.accExists) {

                            setTimeout(() => {

                                let msg = `${response.curr} account already exists!`;

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'warning',
                
                                    text: msg
                
                                });

                            }, 2000);

                        } else if (response.approved) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Request approved!'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else if (response.declined) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account request declined!'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account request deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: 'Action failed!'
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }  

            });

        });

    }

});

// Toggle Location Restrictor Handler

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#toggle-restrictor');

    if (command) {
    
        command.addEventListener("click", async () => {

            openProcessModal(); // Open  Process Modal

            try {

                let processor = await fetch('utility/processors/toggle-location-restrictor.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlenconded'

                    }

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.noList) {

                    setTimeout(() => {

                        closeProcessModal(); // Disable Process Modal

                        new swal({

                            title: 'Attention!',

                            icon: 'info',

                            text: 'Country accesslist empty, please add a location.'

                        });

                    }, 1200);

                } else {
                    
                    if (response.updated) {

                        const msg = `Location restrictor ${response.msg} successful!`;

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Attention!',

                                icon: 'success',

                                text: msg

                            }).then(() => {

                                window.location.reload();

                            });

                        }, 1200);

                    } else {

                        const msg = `Location restrictor ${response.msg} failed!`;

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Attention!',

                                icon: 'error',

                                text: msg

                            });

                        }, 1200);

                    }

                }    

            } catch (error) {

                console.error('Error:', error); // Log Error
                
                setTimeout(() => {

                    closeProcessModal(); // Disable Process Modal

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                }, 1200);

            }

        });

    }

});

// Toggle Maintenance Mode

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#m-mode-form');

    let button = document.querySelector('#m-mode-toggle');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            openProcessModal();

            let content = button.innerHTML; // Hold Original Content

            processStart(button); // Start Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/toggle-m-mode.php', {

                    method: 'POST',

                    body: formData

                }); // Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.invalidKey) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'PIN Error!',

                            text: 'PIN invalid!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: response.msg,

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Action failed!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);


                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Reset Security Key Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#securityKeyForm');

    let button = document.querySelector('#resetKey');

    if (form && button) {

        let oldKey = form.querySelector('input[name="current-key"]');

        let key = form.querySelector('input[name="new-key"]');

        let confirm = form.querySelector('input[name="confirm-key"]');

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            openProcessModal();

            let content = button.innerHTML; // Hold Original Content

            processStart(button); // Start Loading Sequence

            if (String(key.value) !== String(confirm.value)) {

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'PIN mismatch!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence
                    
                    confirm.focus();

                    return; // Exit

                }, 1200);

            }

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/reset-security-key.php', {

                    method: 'POST',

                    body: formData

                }); // Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.invalidKey) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'PIN Error!',

                            text: 'PIN invalid!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Security key updated!',

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Security key update failed!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);


                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Update Blacklist Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#blackListForm');

    let button = document.querySelector('#updateBlacklist');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            openProcessModal();

            let content = button.innerHTML; // Hold Original Content

            processStart(button); // Start Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/update-blacklist.php', {

                    method: 'POST',

                    body: formData

                }); // Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.updated) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Blacklist updated!',

                            icon: 'success'

                        }).then(() => {

                            window.location.reload();

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: 'Blacklist update failed!',

                            icon: 'error'

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);


                }

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Account Management Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.acc-mgmt-form');

    if (forms.length > 0) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'RESET':
                            confirmationMessage = 'Reset account balance to 0.00, are you sure?';
                            break;
                        case 'PRIMARY':
                            confirmationMessage = 'You are about to make this the primary account, are you sure?';
                            break;
                        case 'DELETE':
                            confirmationMessage = 'DELETE: You are about to delete this account?';
                            break;
                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    openProcessModal(); // Display Process Modal

                    try {

                        let formData = new FormData(form); // Get Form Data

                        formData.append('action', action);

                        let processor = await fetch('utility/processors/account-mgmt-processor.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        let msg; // Holds Feeback Message

                        if (response.reset) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account balance reset'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else if (response.primary) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account updated to primary'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            msg = 'Error!, action failed'

                            switch (action) {
                                case 'RESET':
                                msg = 'Couldn\'t reset account balance';
                                    break;
                                case 'PRIMARY':
                                msg = 'Couldn\'t upgrade to primary account';
                                    break;
                                case 'DELETE':
                                msg = 'Deletion failed!';
                                    break;
                            }

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: msg
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }

            });

        });

    }

});

// Withdrawal Limit Management Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.wth-limit-mgmt-form');

    if (forms.length > 0) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'RESET':
                            confirmationMessage = 'Reset account limit to 0.00, are you sure?';
                            break;
                        case 'DELETE':
                            confirmationMessage = 'DELETE: You are about to delete this limit?';
                            break;
                    }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    openProcessModal(); // Display Process Modal

                    try {

                        let formData = new FormData(form); // Get Form Data

                        formData.append('action', action);

                        let processor = await fetch('utility/processors/wth-limit-mgmt-processor.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        let msg; // Holds Feeback Message

                        if (response.reset) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account limit reset'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Account limit deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            msg = 'Error!, action failed'

                            switch (action) {
                                case 'RESET':
                                msg = 'Couldn\'t reset account limit';
                                    break;
                                case 'DELETE':
                                msg = 'Deletion failed!';
                                    break;
                            }

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: msg
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }

            });

        });

    }

});

// Delete Bank Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.bank-mgmt-form');

    if (forms.length > 0) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: 'You are sure you want to delete this bank, accounts with this bank will be affected?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    openProcessModal(); // Display Process Modal

                    try {

                        let formData = new FormData(form); // Get Form Data

                        let processor = await fetch('utility/processors/delete-bank-processor.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        let msg; // Holds Feeback Message

                        if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Bank deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: 'Deletion failed!'
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }

            });

        });

    }

});

// Delete Bank Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.transc-mgmt-form');

    if (forms.length > 0) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: 'You\'re about to delete a transaction, this can\'t be undone!',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    openProcessModal(); // Display Process Modal

                    try {

                        let formData = new FormData(form); // Get Form Data

                        let processor = await fetch('utility/processors/delete-transaction-processor.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        let msg; // Holds Feeback Message

                        if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Transaction deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: 'Deletion failed!'
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }

            });

        });

    }

});

// Investment Account Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.investment-mgmt-form');

    if (forms.length > 0) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: 'You are about to delete this investment plan?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    openProcessModal(); // Display Process Modal

                    try {

                        let formData = new FormData(form); // Get Form Data

                        let processor = await fetch('utility/processors/delete-plan-processor.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        let msg; // Holds Feeback Message

                        if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Investment plan deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: 'Deletion failed!'
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }

            });

        });

    }

});

// Investment Account Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.log-mgmt-form');

    if (forms.length > 0) {

        forms.forEach(form => {

            form.addEventListener("submit", async (event) => {

                event.preventDefault(); // Deny Submission

                const buttonClicked = event.submitter; // Get Button

                if (buttonClicked) {

                    const action = buttonClicked.value;

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: 'Sure you want to delete this?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                    
                    }); 

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    openProcessModal(); // Display Process Modal

                    try {

                        let formData = new FormData(form); // Get Form Data

                        let processor = await fetch('utility/processors/delete-log-processor.php', {

                            method: 'POST',

                            body: formData

                        }); // Processor Credentials

                        let response = await processor.json(); // Parse JSON Response

                        // Handle Response

                        let msg; // Holds Feeback Message

                        if (response.deleted) {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'success',
                
                                    text: 'Activity log deleted'
                
                                }).then(() => {

                                    window.location.reload();

                                    return;

                                });

                            }, 2000);

                        } else {

                            setTimeout(() => {

                                closeProcessModal(); // Close Process Modal

                                new swal({

                                    title: 'Attention!',
                
                                    icon: 'error',
                
                                    text: 'Deletion failed!'
                
                                });

                            }, 2000);

                        }

                    } catch (error) {

                        console.error('Error:', error); // Log error to console

                        setTimeout(() => {

                            closeProcessModal(); // Disable Process Modal

                            new swal({

                                title: 'Error!',

                                icon: 'error',

                                text: 'An error occurred!'

                            });

                        }, 1200);

                    }

                }

            });

        });

    }

});

// Invoice Payment Management Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let forms = document.querySelectorAll('.invoice-payment-mgmt');

    if (forms) {
        forms.forEach(form => {
            form.addEventListener("submit", async (event) => {
                event.preventDefault(); // Prevent form submission

                const buttonClicked = event.submitter; // Get the clicked button
                if (buttonClicked) {
                    const action = buttonClicked.value; //name.toUpperCase(); // Get the action (approve, decline, delete)
                    
                    // Define confirmation messages for each action
                    let confirmationMessage = '';
                    switch (action) {
                        case 'APPROVE':
                            confirmationMessage = 'APPROVE: This is irreversible, are you sure?';
                            break;
                        case 'DECLINE':
                            confirmationMessage = 'DECLINE: This is irreversible, are you sure?';
                            break;
                        case 'DELETE':
                            confirmationMessage = 'DELETE: This is irreversible, are you sure?';
                            break;
                    }

                    // // Trigger the confirmation
                    // if (confirmationMessage && !confirm(confirmationMessage)) {
                    //     return;  // If user cancels, stop the submission
                    // }

                    const confirmDialog = await Swal.fire({
                        title: 'Confirm Action',
                        text: confirmationMessage,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, proceed',
                        cancelButtonText: 'Cancel',
                        // reverseButtons: true
                    });

                    if (!confirmDialog.isConfirmed) {

                        return;

                    }

                    // Process the form with the corresponding action
                    await processForm(form, action);
                }
            });
        });

        async function processForm(form, action) {
            openProcessModal(); // Show the process modal

            try {
                let formData = new FormData(form); // Collect form data
                formData.append('action', action); // Add action (approve, decline, delete)

                let processor = await fetch('utility/processors/invoice-payment-manager.php', {
                    method: 'POST',
                    body: formData
                });

                let response = await processor.json(); // Parse the response

                // Handle the response
                if (response.recordError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Record not found!'
        
                        }).then(() => {

                            window.location.reload();

                            return;

                        });

                    }, 2000);

                } else if (response.userError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'User not found!'
        
                        });

                    }, 2000);

                } else if (response.accError) {
                    
                    setTimeout(() => {

                        closeProcessModal(); // Close Process Modal

                        new swal({

                            title: 'Error!',
        
                            icon: 'error',
        
                            text: 'Item not found!'
        
                        });

                    }, 2000);

                } else {

                    if (response.approved) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Invoice payment approved!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else if (response.declined) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Invoice payment declined!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else if (response.deleted) {

                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Attention!',
            
                                icon: 'success',
            
                                text: 'Invoice payment record deleted!'
            
                            }).then(() => {

                                window.location.reload();

                                return;

                            });

                        }, 2000);
                        
                    } else {
                        
                        setTimeout(() => {

                            closeProcessModal(); // Close Process Modal

                            new swal({

                                title: 'Error!',
            
                                icon: 'error',
            
                                text: 'Please, try again!'
            
                            });

                        }, 2000);
                        
                    }
                }
            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal(); // Close Processing Modal

                    // Feedback

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                }, 1200);
                
            }
        }

    }

});

// Update Mail Settings Form Handler

document.addEventListener("DOMContentLoaded", () => {

    let form = document.querySelector('#mail-settings-form');

    let button = document.querySelector('#update-mail-settings');

    if (form && button) {

        form.addEventListener("submit", async (event) => {

            event.preventDefault(); // Deny Submission

            openProcessModal();

            let content = button.innerHTML; // Hold Original Content

            processStart(button); // Start Loading Sequence

            // Process Form

            try {

                let formData = new FormData(form); // Gain Form Data

                let processor = await fetch('utility/processors/mail-settings-handler.php', {

                    method: 'POST',

                    body: formData

                }); // Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.uploadError) {

                    setTimeout(() => {

                        closeProcessModal();

                        new swal({

                            title: 'Attention!',

                            text: `Mail logo: ${response.message}`,

                            icon: 'error'

                        }).then(() => {

                            window.location.reload();

                        });

                        processEnd(button, content); // End Loading Sequence

                    }, 1200);

                } else {

                    if (response.updated) {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Attention!',

                                text: 'Mail settings updated!',

                                icon: 'success'

                            }).then(() => {

                                window.location.reload();

                            });

                            processEnd(button, content); // End Loading Sequence

                        }, 1200);

                    } else {

                        setTimeout(() => {

                            closeProcessModal();

                            new swal({

                                title: 'Attention!',

                                text: 'Mail settings update failed!',

                                icon: 'error'

                            });

                            processEnd(button, content); // End Loading Sequence

                        }, 1200);


                    }

                }    

            } catch (error) {

                console.error('Error:', error); // Log Error To Console

                setTimeout(() => {

                    closeProcessModal();

                    new swal({

                        title: 'Error!',

                        text: 'An error occurred!',

                        icon: 'error'

                    });

                    processEnd(button, content); // End Loading Sequence

                }, 1200);

            }

        });

    }

});

// Test Mail Handler

document.addEventListener("DOMContentLoaded", () => {

    let command = document.querySelector('#test-mail');

    if (command) {
    
        command.addEventListener("click", async () => {

            openProcessModal(); // Open  Process Modal

            try {

                let processor = await fetch('utility/processors/mail-tester.php', {

                    method: 'POST',

                    headers: {

                        'Content-Type': 'application/x-www-form-urlenconded'

                    }

                }); // Request Handler, Credentials

                let response = await processor.json(); // Parse JSON Response

                // Handle Response

                if (response.sent) {

                    const msg = `Message delivered to ${response.mail} successfully!`;

                    setTimeout(() => {

                        closeProcessModal(); // Disable Process Modal

                        new swal({

                            title: 'Attention!',

                            icon: 'success',

                            text: msg

                        }).then(() => {

                            window.location.reload();

                        });

                    }, 1200);

                } else {

                    const msg = `Message delivery to ${response.mail} failed!`;

                    setTimeout(() => {

                        closeProcessModal(); // Disable Process Modal

                        new swal({

                            title: 'Attention!',

                            icon: 'error',

                            text: msg

                        }).then(() => {

                            window.location.reload();

                        });

                    }, 1200);

                }

            } catch (error) {

                console.error('Error:', error); // Log Error
                
                setTimeout(() => {

                    closeProcessModal(); // Disable Process Modal

                    new swal({

                        title: 'Error!',

                        icon: 'error',

                        text: 'An error occurred!'

                    });

                }, 1200);

            }

        });

    }

});
