<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Function Definitions

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $succeed = false; // Flag

        // Carry-out Specific Action

        if ($action == 'ALLOW') {

            $stmt = mysqli_prepare($conn, "UPDATE `users_activity` SET `cookie_status` = ?, `ip_status` = ? WHERE `user_id` = ?"); // Prepare Statement

            $param = 'ALLOWED';

            $param2 = 'INACTIVE';

            mysqli_stmt_bind_param($stmt, "sss", $param, $param, $user); // Bind Parameter(s)

            $stmt2 = mysqli_prepare($conn, "UPDATE `users` SET `acc_status` = ? WHERE `user_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt2, "ss", $param2, $user); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2)) { // Execute Statement

                $succeed = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

        } else if ($action == 'BLOCK') {

            $stmt = mysqli_prepare($conn, "UPDATE `users_activity` SET `cookie_status` = ?, `ip_status` = ? WHERE `user_id` = ?"); // Prepare Statement

            $param = 'BLOCKED';

            $param2 = 'BANNED';

            mysqli_stmt_bind_param($stmt, "sss", $param, $param, $user); // Bind Parameter(s)

            $stmt2 = mysqli_prepare($conn, "UPDATE `users` SET `acc_status` = ? WHERE `user_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt2, "ss", $param2, $user); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2)) { // Execute Statement

                $succeed = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

        } else if ($action == 'DELETE') {

            $stmt = mysqli_prepare($conn, "DELETE FROM `users_activity` WHERE `user_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $user); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $succeed = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

        }

        echo json_encode(['succeeded' => $succeed]); // Encode JSON Response

    }

?>