<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    // Process Form

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['user'], FILTER_SANITIZE_SPECIAL_CHARS);

        $status = filter_var($_REQUEST['status'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Data Drop

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `acc_status` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $status, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['statusUpdated' => $updated]); // Encode JSON Response

    }

?>