<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $name = filter_var(trim($_REQUEST['plan-name']), FILTER_SANITIZE_SPECIAL_CHARS);

        $descr = !empty($_REQUEST['plan-desc']) ? filter_var(trim($_REQUEST['plan-desc']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $type = filter_var($_REQUEST['plan-category'], FILTER_SANITIZE_SPECIAL_CHARS);

        $min = !empty($_REQUEST['plan-min']) ? filter_var($_REQUEST['plan-min'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : null;
        
        $max = filter_var($_REQUEST['plan-max'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $duration = filter_var($_REQUEST['plan-duration'], FILTER_SANITIZE_NUMBER_INT);

        $return = filter_var($_REQUEST['plan-return'], FILTER_SANITIZE_SPECIAL_CHARS);

        $rate = filter_var($_REQUEST['plan-rate'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $frequency = filter_var($_REQUEST['plan-frequency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $risk = filter_var($_REQUEST['plan-risk'], FILTER_SANITIZE_SPECIAL_CHARS);

        $image = !empty($_FILES['plan-image']['name']) ? $_FILES['plan-image'] : null;

        $imagePath = null;

        $directory = '../../../vault/plans/';

        // Validate Field(s)

        $fields = [$type, $return, $frequency, $risk];

        // Array to store the human-readable field names
        $emptyFields = [];

        // Human-readable field names mapping to the form input names
        $fieldNames = [
            'type' => 'Plan Category',
            'return' => 'ROI Type',
            'frequency' => 'Payout Frequency',
            'risk' => 'Risk'
        ];

        // Check if each field is empty and collect the human-readable names
        if ($type == 0) {
            $emptyFields[] = $fieldNames['type'];
        }

        if ($return == 0) {
            $emptyFields[] = $fieldNames['return'];
        }

        if ($frequency == 0) {
            $emptyFields[] = $fieldNames['frequency'];
        }

        if ($risk == 0) {
            $emptyFields[] = $fieldNames['risk'];
        }

        if (!empty($emptyFields)) {

            $message = 'Please specify field(s): ' . join(', ', $emptyFields);

            echo json_encode(['fieldError' => true, 'message' => $message]);

            exit;

        }

        if ($min > $max) {

            echo json_encode(['maxError' => true]);

            exit;

        }

        $factor = timingFactor($frequency, $conn); // Search For Timing Factor

        if (!$factor) {

            echo json_encode(['factorError' => true]);

            exit;

        }

        $timingUnit = ($factor['days'] > $factor['hours']) ? 'DAYS' : 'HOURS';

        $timing = ($timingUnit == 'DAYS') ? $factor['days'] : $factor['hours'];

        if ($image) { // Handle Image Upload

            $imagePath = fileUpload($image, $directory, 'comdty', null, 250, true); // Upload Image

            if ($imagePath['status']) {

                $imagePath = $imagePath['vault'];

            } else {

                echo json_encode(['uploadFailure' => true, 'message' => $imagePath['message']]);

                exit;

            }

        }

        // Initiate Data Drop

        $created = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `investments` (`inv_id`, `image`, `name`, `category`, `descr`, `min_amount`, `max_amount`, `duration`, `interest_rate`, `return_type`, `frequency`, `risk_factor`, `timing`, `timing_unit`) VALUES(?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        $id = generateUniqueID($conn, 'investments', 'INV'); // Generate ID

        $image = ($imagePath != null) ? $imagePath : null;

        mysqli_stmt_bind_param($stmt, "sssssddidsssss", $id, $image, $name, $type, $descr, $min, $max, $duration, $rate, $return, $frequency, $risk, $timing, $timingUnit); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) {

            $created = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement
        
        if (!$created && $imagePath) { // Delete Uploaded Image (Incase of Statement Failure)

            deleteFile($imagePath);

        }

        echo json_encode(['added' => $created]);

    }

?>