<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup
    
    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol 

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        
        // Sanitize Field(s)

        $user = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $fname = filter_var($_REQUEST['fname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !empty($_REQUEST['mname']) ? filter_var($_REQUEST['mname'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var($_REQUEST['lname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $email = filter_var(strtolower(trim($_REQUEST['email'])), FILTER_SANITIZE_EMAIL);

        $gender = filter_var($_REQUEST['gender'], FILTER_SANITIZE_SPECIAL_CHARS);

        $title = ($_REQUEST['title'] == 0) ? filter_var($_REQUEST['title'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $status = filter_var($_REQUEST['acc-status'], FILTER_SANITIZE_SPECIAL_CHARS);

        $wLimit = filter_var($_REQUEST['wth-limit'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $tLimit = filter_var($_REQUEST['trans-limit'], FILTER_SANITIZE_NUMBER_INT);

        $barredList = null;

        if (isset($_REQUEST['barred']) && is_array($_REQUEST['barred'])) {

            $barred = array_map('htmlspecialchars', $_REQUEST['barred']);
            
            $barredList = implode(', ', $barred); // Join Into Comma-Separated String

        }

        $userData = userData($user, $conn);

        if (!$userData) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $emailInUse = emailExists($email, $conn); // Check If Email Is In Use

        if ($emailInUse) {

            echo json_encode(['emailTaken' => true]); // Encode JSON Response

            exit; // End Run

        }

        $password = randomString(8); // Generate Password

        $key = md5($password); // Hash Password

        $id = generateUniqueID($conn, 'third_party', 'TPY'); // Generate Unique ID

        // Commence Data Drop

        $created = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `third_party` (`tp_id`, `email`, `password`, `pre_hash`, `fname`, `mname`, `lname`, `gender`, `title`, `status`, `wth_limit`, `trans_limit`, `no_access`, `user_id`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssssssssssdiss", $id, $email, $key, $password, $fname, $mname, $lname, $gender, $title, $status, $wLimit, $tLimit, $barredList, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $created = true;

        }
         
        mysqli_stmt_close($stmt); // Close Statement

        if ($created) {

            // Send Email

            $mail = thirdPartyMail($fname, join(' ', [$userData['firstname'], $userData['lastname']]), $email, $password); // Mail

            $subject = 'Joint User Alert';

            $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $email, join(' ', [$fname, $mname]));

            if (!$deliver) {

                $deliver = @deliverByPHPMail(join(' ', [$fname, $mname]), $subject, $mail);

            }

        }
        
        echo json_encode(['added' => $created]); // Echo JSON Response

    }

?>