<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Functions

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $factor = filter_var(trim($_REQUEST['factor-name']), FILTER_SANITIZE_SPECIAL_CHARS);

        $type = filter_var($_REQUEST['duration-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $duration = filter_var($_REQUEST['factor-duration'], FILTER_SANITIZE_NUMBER_INT);

        if ($type == 'HOURS') {

            $hours = $duration;

            $days = daysToHours($duration, true);

        } else {

            $days = $duration;

            $hours = daysToHours($duration);

        }

        $factor = strtoupper($factor);

        // Validate Name

        // Initiate Data Drop

        $created = false; // Flag

        $error = null;

        $stmt = mysqli_prepare($conn, "INSERT INTO `timing_factors` (`factor`, `days`, `hours`) VALUES(?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sii", $factor, $days, $hours); // Bind Parameter(s)

        try {

            if (mysqli_stmt_execute($stmt)) {

                $created = true; // Update Flag

            }

        } catch (mysqli_sql_exception $e) {

            $error = mysqli_stmt_error($stmt); // Get Statement Error

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['created' => $created, 'msg' => $error]); // Encode JSON Response

    }

?>