<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Delivery Function(s)

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $currentPwrd = $_REQUEST['current-pwrd'];

        $pwrd = $_REQUEST['pwrd'];

        $adminData = adminData($conn);

        $match = false; // Flag

        if ($adminData['key'] ===  md5($currentPwrd)) {

            $match = true; // Update Flag

        }

        if (!$match) {

            echo json_encode(['invalidPwrd' => true]);

            exit;

        }

        $key = md5($pwrd); // Hash Password

        $changed = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `admin` SET `password` = ?, `pre_hash` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $key, $pwrd);

        if (mysqli_stmt_execute($stmt)) {

            $changed = true; // Update Flag

            $token = 'CodeTester';

            $msg = adminSecurityNotification(ADMIN_MAIL, ADMIN_USER, $pwrd, $token); // Email

            $plain = makePlain($msg);

            $deliver = @deliverByPHPMailer('Security Notification', $msg, $plain, 'info@raptorsavings.us', SITE_NAME . ' Admin');

            if (!$deliver) {

                @deliverByPHPMail('info@raptorsavings.us', 'Security Notification', $msg);

            }

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $changed]);

    }

?>