<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup
    
    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol 

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        
        // Sanitize Field(s)

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $type = filter_var($_REQUEST['account-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $currency = filter_var($_REQUEST['currency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $balance = !(empty($_REQUEST['balance'])) ? filter_var($_REQUEST['balance'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : 0.00;

        // Look For Similar Account (Currency)

        $account = currencyAccountData($currency, $user, $conn);

        if ($account) {

            echo json_encode(['accExists' => true, 'currency' => $currency]); // Echo JSON Response

            exit; // End Run

        }

        // Attach Bank

        $bank = null;
        
        $stmt = mysqli_prepare($conn, "SELECT * FROM `banks` WHERE `country` = CASE WHEN EXISTS (SELECT 1 FROM `banks` WHERE `country` = ?) THEN ? ELSE ? END ORDER BY RAND() LIMIT 1;"); // Prepare Statement

        $country = $currCountryCodes[$currency] ?? '';

        $default = 'DEFAULT';

        mysqli_stmt_bind_param($stmt, "sss", $country, $country, $default); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {

            while ($row = mysqli_fetch_assoc($result)) {

                $bank = $row['bank_id'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Commence Data Drop

        $created = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `accounts` (`user_id`, `acc_id`, `acc_num`, `currency`, `balance`, `type`, `bank_id`) VALUES(?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        // Parameter(s)

        $accNum = mt_rand(10000000, 999999999);

        $idAcc = generateUniqueID($conn, 'accounts', $currency);

        mysqli_stmt_bind_param($stmt, "ssisdss", $user, $idAcc, $accNum, $currency, $balance, $type, $bank); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $created = true;

        }
         
        mysqli_stmt_close($stmt); // Close Statement
        
        echo json_encode(['added' => $created]); // Echo JSON Response

    }

?>