<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // file_put_contents('../../../error.log', print_r($_REQUEST, true));

        // Sanitize Fields

        $user = filter_var(trim($_REQUEST['user']), FILTER_SANITIZE_SPECIAL_CHARS);

        $title = filter_var($_REQUEST['title'], FILTER_SANITIZE_SPECIAL_CHARS);

        $msg = filter_var($_REQUEST['msg'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $id = generateUniqueID($conn, 'notifications', 'NOTF'); // Generate Unique 
        
        $date = timeGMT('Y-m-d'); // Get UTC Date

        // Create Notification

        $created = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `notifications` (`notf_id`, `user_id`, `title`, `message_text`, `date_created`) VALUES(?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssss", $id, $user, $title, $msg, $date); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $created = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['created' => $created]); // Encode JSON Response

    }

?>