<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['plan-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $oldImage = filter_var($_REQUEST['old-image'], FILTER_SANITIZE_SPECIAL_CHARS);;

        // Commence Deletion

        $deleted = false; // Flag

        $stmt = mysqli_prepare($conn, "DELETE FROM `investments` WHERE `inv_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
  
            $deleted = true; // Update Flag
        
            deleteFile($oldImage, '../../../');

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['deleted' => $deleted]); // Encode JSON Response

    }

?>