<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['factor-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Commence Deletion

        $deleted = false; // Flag

        $stmt = mysqli_prepare($conn, "DELETE FROM `timing_factors` WHERE `id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
  
            $deleted = true; // Update Flag
        
        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['deleted' => $deleted]); // Encode JSON Response

    }

?>