<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var(trim($_REQUEST['bank-id']), FILTER_SANITIZE_SPECIAL_CHARS);

        $oldImage = !empty($_REQUEST['current-image']) ? filter_var(trim($_REQUEST['current-image']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $name = filter_var(trim($_REQUEST['bank-name']), FILTER_SANITIZE_SPECIAL_CHARS);

        $country = filter_var(trim($_REQUEST['bank-country']), FILTER_SANITIZE_SPECIAL_CHARS);

        $branch = filter_var(trim($_REQUEST['bank-branch']), FILTER_SANITIZE_SPECIAL_CHARS);

        $default = isset($_REQUEST['bank-default']) ? true : null;

        $code = !empty($_REQUEST['bank-code']) ? filter_var(trim($_REQUEST['bank-code']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $codeType = filter_var(trim($_REQUEST['code-type']), FILTER_SANITIZE_SPECIAL_CHARS);

        $logo = !empty($_FILES['bank-logo']['name']) ? $_FILES['bank-logo'] : null;

        $logoPath = null;

        $directory = '../../../vault/bank-data/';

        if ($default) {

            $country = 'DEFAULT';

        }

        if ($country == '0' && !$default) {

            echo json_encode(['cntryError' => true]);

            exit;

        }

        if ($codeType == 0) {

            $codeType = null;

        }

        if ($code == null && $codeType) {

            echo json_encode(['codeError' => true]);

            exit;

        }

        if ($codeType == null && $code) {

            echo json_encode(['typeError' => true]);

            exit;

        }

        if ($logo) {

            $logoPath = fileUpload($logo, $directory, 'bnk-', null, true); // Upload Logo

            if (!$logoPath['status']) {

                echo json_encode(['uploadError' => true, 'message' => $logoPath['message']]);

                exit;

            }
        
            $logoPath = $logoPath['vault'];

        }
        
        // Build Query

        $query = "UPDATE `banks` SET `name` = ?, `country` = ?, `branch` = ?, `bank_code` = ?, `bank_codetype` = ?";

        $type = "sssss";

        $params = [$name, $country, $branch, $code, $codeType];

        if ($logoPath) {

            $query .= ", `logo` = ?";

            $type .= "s";

            $params[] = $logoPath;

        }

        $query .= " WHERE `bank_id` = ?";

        $type .= "s";

        $params[] = $id;

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, $type, ...$params); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) {

            $edited = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        if ($logoPath) {

            if (!$edited) {

                deleteFile($logoPath); // Uploaded Logo

            } else {

                deleteFile($oldImage, '../../../');

            }

        }    

        echo json_encode(['bankEdited' => $edited]);

    }

?>