<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['r-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bank = filter_var($_REQUEST['acc-bank'], FILTER_SANITIZE_SPECIAL_CHARS);

        $name = filter_var($_REQUEST['acc-name'], FILTER_SANITIZE_SPECIAL_CHARS);

        $number = filter_var($_REQUEST['acc-num'], FILTER_SANITIZE_SPECIAL_CHARS);

        $country = filter_var($_REQUEST['acc-country'], FILTER_SANITIZE_SPECIAL_CHARS);

        $swift = !empty($_REQUEST['acc-swift']) ? filter_var($_REQUEST['acc-swift'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $iban = !empty($_REQUEST['acc-iban']) ? filter_var($_REQUEST['acc-iban'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $routing = !empty($_REQUEST['acc-routing']) ? filter_var($_REQUEST['acc-routing'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $sorting = !empty($_REQUEST['acc-sort']) ? filter_var($_REQUEST['acc-sort'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        // Validate Country

        if ($country == null || empty($country)) {

            echo json_encode(['cntryError' => true]);

            exit;

        }

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `pay_resources` SET `resource_name` = ?, `bank_name` = ?, `resource_attr` = ?, `country_code` = ?, `sorting` = ?, `routing` = ?, `swift` = ?, `iban` = ? WHERE `id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssssss", $name, $bank, $number, $country, $sorting, $routing, $swift, $iban, $id);

        if (mysqli_stmt_execute($stmt)) {

            $edited = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['edited' => $edited]); // Encode JSON Response

    }

?>