<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup
    
    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol 

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        
        // Sanitize Field(s)

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $fname = filter_var($_REQUEST['fname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !empty($_REQUEST['mname']) ? filter_var($_REQUEST['mname'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var($_REQUEST['lname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $gender = filter_var($_REQUEST['gender'], FILTER_SANITIZE_SPECIAL_CHARS);

        $title = ($_REQUEST['title'] == 0) ? filter_var($_REQUEST['title'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $status = filter_var($_REQUEST['acc-status'], FILTER_SANITIZE_SPECIAL_CHARS);

        $wLimit = filter_var($_REQUEST['wth-limit'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $tLimit = filter_var($_REQUEST['trans-limit'], FILTER_SANITIZE_NUMBER_INT);

        $tCount = filter_var($_REQUEST['trans-count'], FILTER_SANITIZE_NUMBER_INT);

        $barredList = null;

        if (isset($_REQUEST['barred']) && is_array($_REQUEST['barred'])) {

            $barred = array_map('htmlspecialchars', $_REQUEST['barred']);
            
            $barredList = implode(', ', $barred); // Join Into Comma-Separated String

        }

        $email = filter_var(strtolower(trim($_REQUEST['email'])), FILTER_SANITIZE_EMAIL);

        $password = $_REQUEST['password'];

        $key = md5($password); // Hash Password

        $thirdPartyData = thirdPartyData($id, $conn); // Get Third Party Data

        if (!$thirdPartyData) {

            echo json_encode(['invalidUser' => true]); // Encode JSON Response

            exit;

        }

        $emailExists = emailExists($email, $conn); // Check If Email Exist

        if ($emailExists && $email != $thirdPartyData['email']) {

            echo json_encode(['invalidEmail' => true]); // Encode JSON Response

            exit;

        }

        // Commence Data Drop

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `third_party` SET `email` = ?, `password` = ?, `pre_hash` = ?, `fname` = ?, `mname` = ?, `lname` = ?, `gender` = ?, `title` = ?, `status` = ?, `wth_limit` = ?, `trans_limit` = ?, `trans_count` = ?, `no_access` = ? WHERE `tp_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssssssdiiss", $email, $key, $password, $fname, $mname, $lname, $gender, $title, $status, $wLimit, $tLimit, $tCount, $barredList, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $edited = true;

        }
         
        mysqli_stmt_close($stmt); // Close Statement
        
        echo json_encode(['edited' => $edited]); // Encode JSON Response

    }

?>