<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitze Field(s)

        $id = filter_var($_REQUEST['payout-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $due = sanitizeDateTime($_REQUEST['due']);

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `payout_schedule` SET `due` = ?, `amount` = ? WHERE `id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sds", $due, $amount, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement(s)

            $edited = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $edited]); // Encode JSON Response

    }

?>