<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    require('../../../vendor/autoload.php'); // Composer Package(s) File

    require('../../../controls/engines/mail-delivery-engine.php'); // Mail Fxns

    require('../../../controls/engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['transc-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $approval = !empty($_REQUEST['approval-flag']) ? filter_var($_REQUEST['approval-flag'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $time = $_REQUEST['transc-date'];

        $date = sanitizeDateTime($time);

        $type = filter_var($_REQUEST['transc-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['transc-action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $account = filter_var($_REQUEST['transc-account'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['transc-amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $dest = !empty($_REQUEST['transc-destination']) ? filter_var($_REQUEST['transc-destination'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $bank = !empty($_REQUEST['transc-bank']) ? filter_var($_REQUEST['transc-bank'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $recipient = !empty($_REQUEST['transc-recipient']) ? filter_var($_REQUEST['transc-recipient'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $codeType = filter_var($_REQUEST['transc-code-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bankCode = !empty($_REQUEST['transc-bank']) ? filter_var($_REQUEST['transc-bank'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $description = !empty($_REQUEST['transc-descr']) ? filter_var($_REQUEST['transc-descr'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $status = filter_var($_REQUEST['transc-status'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Validate Field(s)

        $fields = [$account, $action];

        // Array to store the human-readable field names
        $emptyFields = [];

        // Human-readable field names mapping to the form input names
        $fieldNames = [
            'account' => 'Account / Currency',
            'action' => 'Scope',
        ];

        // Check if each field is empty and collect the human-readable names
        if ($account == 0) {
            $emptyFields[] = $fieldNames['account'];
        }

        if ($action == 0) {
            $emptyFields[] = $fieldNames['action'];
        }

        if (!empty($emptyFields)) {

            $message = 'Please specify field(s): ' . join(', ', $emptyFields);

            echo json_encode(['fieldError' => true, 'message' => $message]);

            exit;

        }

        $thirdParty = false; // Flag

        $userData = userData($user, $conn); // Find User

        if (!$userData) {

            $userData = thirdPartyData($user, $conn); // Try Third Party 

            if ($userData) {

                $thirdParty = true; // Flag

                $accOwner = $userData['main-user']; // Account Owner

            }

        }

        if (!$userData) {

            echo json_encode(['userError' => true]);

            exit;

        }

        // Find Account

        $source = accountData($account, $user, $conn);

        if ($thirdParty) {

            $source = accountData($account, $accOwner, $conn);

        }

        if (!$source) {

            echo json_encode(['accError' => true]);

            exit;

        }

        $accNum = $source['acc-number']; // Acc Number

        $currency = $source['currency'];

        $transfer = false; // Flag (For Transfers)

        if ($action == 'CROSS-BORDER TRANSFER' || $action == 'LOCAL TRANSFER') {

            $transfer = true; // Update Flag

            // Validate Field(s)
            $fields = [$dest, $bank, $recipient];

            // Array to store the human-readable field names
            $emptyFields = [];

            // Human-readable field names mapping to the form input names
            $fieldNames = [
                'dest' => 'Recipient Account',
                'bank' => 'Recipient Bank',
                'recipient' => 'Recipient / Account Name'
            ];

            // Check if each field is empty and collect the human-readable names
            if (is_null($dest)) {
                $emptyFields[] = $fieldNames['dest'];
            }

            if ($bank == 0) {
                $emptyFields[] = $fieldNames['bank'];
            }

            if ($recipient == 0) {
                $emptyFields[] = $fieldNames['recipient'];
            }

            if ($action == 'CROSS-BORDER TRANSFER') {

                // Add to $fields array for further validation or processing
                $fields[] = $codeType; 
                $fields[] = $bankCode;

                // Add new keys to $fieldNames associative array properly
                $fieldNames['codeType'] = 'Banking Code Type';
                $fieldNames['bankCode'] = 'Bank Code';

                if ($codeType == 0) {
                    $emptyFields[] = $fieldNames['codeType'];
                }

                if ($bankCode == 0) {
                    $emptyFields[] = $fieldNames['bankCode'];
                }
            }

            if (!empty($emptyFields)) {
                $message = 'Please specify field(s): ' . join(', ', $emptyFields);
                echo json_encode(['fieldError' => true, 'message' => $message]);
                exit;
            }

        }

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `transactions` SET  `date` = ?, `type` = ?, `action` = ?, `descr` = ?, `currency` = ?, `acc_id` = ?, `acc_num` = ?, `amount` = ?, `recpt_acc` = ?, `recpt_name` = ?, `recpt_bank` = ?, `banking_codetype` = ?, `banking_code` = ?, `status` = ? WHERE `trans_id` = ? AND `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssssdssssssss", $date, $type, $action, $description, $currency, $account, $accNum, $amount, $dest, $recipient, $bank, $codeType, $bankCode, $status, $id, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) {

            $edited = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        if ($edited && $transfer && $approval == 'MANUAL') {

            $money = ($currSymbol[$currency] ?? null) . number_format($amount, 2) . ' ' . $currency;

            mysqli_query($conn, "UPDATE `transactions` SET `approval_flag` = NULL WHERE `trans_id` = '$id'"); // Update Approval Flag 

            if ($status == 'COMPLETED') {

                $subject = 'Transfer Confirmed #' . mt_rand(10000000, 99999999); // Mail Subject;

                $mail = transferConfirmation($userData['firstname'], $money, date('l M d, Y', strtotime($time)), $recipient . '(' . $dest . ')', $dest);

                // Update Account Balance

                $stmt = mysqli_prepare($conn,  "UPDATE `accounts` SET `balance` = `balance` - ? WHERE `acc_id` = ?"); // Prepare Statement

                mysqli_stmt_bind_param($stmt, "ds", $amount, $account); // Bind Parameter(s)

                mysqli_stmt_execute($stmt); // Execute Statement

            } else {

                $subject = 'Transfer Declined #' . mt_rand(10000000, 99999999); // Mail Subject;

                $mail = transferDeclined($userData['firstname'], $money, date('l M d, Y', strtotime($time)), $recipient . '(' . $dest . ')', $dest);

            }

            $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

            if (!$deliver) {

                @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

            }
                
        }

        echo json_encode(['edited' => $edited]);

    }

?>