<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    require('../../../controls/engines/fxns.php'); // Custom Function File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['card'], FILTER_SANITIZE_SPECIAL_CHARS);

        $balance = !empty($_REQUEST['card-balance']) ? filter_var($_REQUEST['card-balance'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) : 0;

        $color = isset($_REQUEST['radomize-color']) ? generateRGB() : filter_var($_REQUEST['card-color'], FILTER_SANITIZE_SPECIAL_CHARS);

        $expires = !empty($_REQUEST['card-expires']) ? $_REQUEST['card-expires'] : null;
         
        $fund = filter_var($_REQUEST['card-fund'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Format Date

        $date = new DateTime($expires);

        // Move to the last day of the month
        $date->modify('last day of this month');

        $expires = $date->format('Y-m-d');

        $edited = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `virtual_cards` SET `expires` = ?, `fund_by` = ?, `color` = ?, `balance` = ? WHERE `card_id` = ?"); // Prepare Statement (For Card Creation)

        mysqli_stmt_bind_param($stmt, "sssss", $expires, $fund, $color, $balance, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) {

            $edited = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['edited' => $edited]); // Encode JSON Response

    }

?>