<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitze Field(s)

        $id = filter_var($_REQUEST['inv-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $deleted = false; // Flag

        $stmt = mysqli_prepare($conn, "DELETE FROM `invoices` WHERE `invoice_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement(s)

            $deleted = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['deleted' => $deleted]); // Encode JSON Response

    }

?>