<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup
    
    require('../../../controls/engines/fxns.php'); // Function(s) File

    header('Content-Type: application/json'); // Communication Protocol 

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $id = filter_var($_REQUEST['tpy-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        if ($action == 'DELETE') {

            // Commence User Deletion

            $deleted = deleteJointUser($conn, $id, '../../../'); // Flag

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response            

        } else if ($action == 'RESET') {

            // Commence Transaction Count

            $reset = false; // Flag

            $stmt = mysqli_prepare($conn, "UPDATE `third_party` SET `trans_count` = ? WHERE `tp_id` = ?"); // Prepare Statement

            $param = 0;

            mysqli_stmt_bind_param($stmt, "is", $param, $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $reset = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['reset' => $reset]); // Encode JSON Response

        }

    }

?>