<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitze Field(s)

        $loanID = filter_var($_REQUEST['loan-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $deleted = false; // Flag

        $stmt = mysqli_prepare($conn, "DELETE FROM `repayments_schedule` WHERE `loan_id` = ?"); // Prepare Statement (Delete Repayment Schedule Record(s))

        mysqli_stmt_bind_param($stmt, "s", $loanID); // Bind Parameter(s)

        $stmt2 = mysqli_prepare($conn, "DELETE FROM `loans` WHERE `loan_id` = ?"); // Prepare Statement (Delete Loan Record)

        mysqli_stmt_bind_param($stmt2, "s", $loanID); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2)) { // Execute Statement(s)

            $deleted = true; // Update Flag

        }

        // Close Statement(s)

        mysqli_stmt_close($stmt);

        mysqli_stmt_close($stmt2);

        echo json_encode(['deleted' => $deleted]); // Encode JSON Response

    }

?>