<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $directory = '../../../vault/web-data/';

        // Sanitize Fields

        $presentLogo = !empty($_REQUEST['currentLogo']) ? filter_var($_REQUEST['currentLogo'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $presentDLogo = !empty($_REQUEST['currentAltLogo']) ? filter_var($_REQUEST['currentAltLogo'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $presentIcon = !empty($_REQUEST['currentIcon']) ? filter_var($_REQUEST['currentIcon'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $presentPrelIcon = !empty($_REQUEST['currentPrelIcon']) ? filter_var($_REQUEST['currentPrelIcon'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $logo = !empty($_FILES['logo']['name']) ?  $_FILES['logo'] : null;

        $logoD = !empty($_FILES['logoAlt']['name']) ?  $_FILES['logoAlt'] : null;

        $icon = !empty($_FILES['favicon']['name']) ?  $_FILES['favicon'] : null;

        $pIcon = !empty($_FILES['prelIcon']['name']) ?  $_FILES['prelIcon'] : null;

        $logoPath = null;

        $logoDPath = null;

        $iconPath = null;

        $pIconPath = null;

        if (!$logo && !$logoD && !$icon && !$pIcon) {

            echo json_encode(['nullInput' => true]);

            exit;

        }

        if ($logo) {

            $logoPath = fileUpload($logo, $directory, 'logo-', null, true);

            if (!$logoPath['status']) {

                $error = 'Website logo: ' . $logoPath['message'];

                echo json_encode(['uploadError' => true, 'msg' => $error]);

                exit; // End Run

            } else {

                $logoPath = $logoPath['vault'];

            }

        }

        if ($logoD) {

            $logoDPath = fileUpload($logoD, $directory, 'logo-dark-', null, true);

            if (!$logoDPath['status']) {

                $error = 'Website Dark logo: ' . $logoDPath['message'];

                echo json_encode(['uploadError' => true, 'msg' =>  $error]);

                exit; // End Run

            } else {

                $logoDPath = $logoDPath['vault'];

            }

        }

        if ($icon) {

            $iconPath = fileUpload($icon, $directory, 'icon-', null, true);

            if (!$iconPath['status']) {

                $error = 'Website Icon: ' . $iconPath['message'];

                echo json_encode(['uploadError' => true, 'msg' => $error]);

                exit; // End Run

            } else {

                $iconPath = $iconPath['vault'];

            }

        }

        if ($pIcon) {

            $pIconPath = fileUpload($pIcon, $directory, 'p-icon-', null, true);

            if (!$pIconPath['status']) {

                $error = 'Website Icon: ' . $pIconPath['message'];

                echo json_encode(['uploadError' => true, 'msg' => $error]);

                exit; // End Run

            } else {

                $pIconPath = $pIconPath['vault'];

            }

        }

        // Prepare Query

        $query = 'UPDATE `settings` SET ';

        $queryParts = [];

        $params = '';

        $values = [];

        if ($logoPath) {

            $queryParts[] = '`siteLogo` = ?';

            $params .= 's';

            $values[] = $logoPath;

        }

        if ($logoDPath) {

            $queryParts[] = '`siteLogo_dark` = ?';

            $params .= 's';

            $values[] = $logoDPath;

        }

        if ($iconPath) {

            $queryParts[] = '`siteIcon` = ?';

            $params .= 's';

            $values[] = $iconPath;

        }

        if ($pIconPath) {

            $queryParts[] = '`preloader_icon` = ?';

            $params .= 's';

            $values[] = $pIconPath;

        }

        $subQuery = join(', ', $queryParts);

        $query .= $subQuery;

        $query .= ' LIMIT 1';

        // Pour Data

        $updated = false; // Flag

        $upload =  mysqli_prepare($conn, $query); // Prepare Statement

        mysqli_stmt_bind_param($upload, $params, ...$values);

        if (mysqli_stmt_execute($upload)) { // Execute Statement

            $updated = true; // Update Flag

        }

        // Delete Old Files

        if ($updated) {

            if ($logoPath && $presentLogo) {

                $file = '../../../' . str_replace('../', '', $presentLogo); // Re-construct Path

                if (is_file($file) && file_exists($file)) {

                    unlink($file);

                }

            }

            if ($logoDPath && $presentDLogo) {

                $file = '../../../' . str_replace('../', '', $presentDLogo); // Re-construct Path

                if (is_file($file) && file_exists($file)) {

                    unlink($file);

                }

            }

            if ($iconPath && $presentIcon) {

                $file = '../../../' . str_replace('../', '', $presentIcon); // Re-construct Path

                if (is_file($file) && file_exists($file)) {

                    unlink($file);

                }

            }

            if ($pIconPath && $presentPrelIcon) {

                $file = '../../../' . str_replace('../', '', $presentPrelIcon); // Re-construct Path

                if (is_file($file) && file_exists($file)) {

                    unlink($file);

                }

            }


        }

        mysqli_stmt_close($upload); // Close Statement

       echo json_encode(['upload' => $updated]); // Encode Response

    }

?>