<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Commmunication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['notf-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Determine Action

        if ($action === 'DELETE') {

            // Commence Deletion

            $deleted = false; // Flag

            $stmt = mysqli_prepare($conn, "DELETE FROM `notifications` WHERE `notf_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement

                $deleted = true; // Update Flag

            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

        }

    }

?>