<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Hash Field(s)

        $currentKey = md5($_REQUEST['current-key']);

        $newKey = md5($_REQUEST['new-key']);

        // Validate Key

        if ($currentKey !== M_KEY) { // Invalid Key

            echo json_encode(['invalidKey' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Commence Security Key Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `settings` SET `m_key` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $newKey); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON      

    }

?>