<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field

        $currency = filter_var($_REQUEST['currency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $limit = filter_var($_REQUEST['wth-limit'], FILTER_SANITIZE_NUMBER_INT);

        $amount = filter_var($_REQUEST['wth-max'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        // Commence Update

        $dropped = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `wth_max` = ?, `wth_limit` = ? WHERE `currency` = ? AND `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "idss", $limit, $amount, $currency, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $dropped = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['added' => $dropped]); // Encode JSON      

    }

?>